/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Log {
    private static final String SOURCE_FILE = "SourceFile";
    private static int LEVEL = 10;
    private static boolean withMethodName;
    private static boolean withLineNumber;
    public static String customTag;

    private Log() {
    }

    public static void setLevel(int level) {
        LEVEL = level;
    }

    public static void logMethodName(boolean method, boolean line) {
        withMethodName = method;
        withLineNumber = line;
    }

    public static boolean isVerboseEnabled() {
        return LEVEL <= 2;
    }

    public static boolean isDebugEnabled() {
        return LEVEL <= 3;
    }

    public static boolean isInfoEnabled() {
        return LEVEL <= 4;
    }

    public static boolean isWarnEnabled() {
        return LEVEL <= 5;
    }

    public static boolean isErrorEnabled() {
        return LEVEL <= 6;
    }

    public static void v(String msg, Object ... args) {
        if (Log.isVerboseEnabled()) {
            android.util.Log.v((String)Log.getTag(), (String)Log.formatMessage(msg, args));
        }
    }

    public static void d(String msg, Object ... args) {
        if (Log.isDebugEnabled()) {
            android.util.Log.d((String)Log.getTag(), (String)Log.formatMessage(msg, args));
        }
    }

    public static void i(String msg, Object ... args) {
        if (Log.isInfoEnabled()) {
            android.util.Log.i((String)Log.getTag(), (String)Log.formatMessage(msg, args));
        }
    }

    public static void iTag(String tag, String msg, Object ... args) {
        if (Log.isInfoEnabled()) {
            android.util.Log.i((String)tag, (String)Log.formatMessage(msg, args));
        }
    }

    public static void w(String msg, Object ... args) {
        if (Log.isWarnEnabled()) {
            android.util.Log.w((String)Log.getTag(), (String)Log.formatMessage(msg, args));
        }
    }

    public static void w(Throwable t, String msg, Object ... args) {
        if (Log.isWarnEnabled()) {
            android.util.Log.w((String)Log.getTag(), (String)Log.formatMessage(msg, args), (Throwable)t);
        }
    }

    public static void e(String msg, Object ... args) {
        if (Log.isErrorEnabled()) {
            android.util.Log.e((String)Log.getTag(), (String)Log.formatMessage(msg, args));
        }
    }

    public static void e(Throwable t, String msg, Object ... args) {
        if (Log.isErrorEnabled()) {
            android.util.Log.e((String)Log.getTag(), (String)Log.formatMessage(msg, args), (Throwable)t);
        }
    }

    public static void wtf(String msg, Object ... args) {
        if (Log.isErrorEnabled()) {
            android.util.Log.wtf((String)Log.getTag(), (String)Log.formatMessage(msg, args));
        }
    }

    public static void wtf(Throwable t, String msg, Object ... args) {
        if (Log.isErrorEnabled()) {
            android.util.Log.wtf((String)Log.getTag(), (String)Log.formatMessage(msg, args), (Throwable)t);
        }
    }

    public static void useTag(@Nullable String customTag) {
        Log.customTag = customTag;
    }

    private static String getTag() {
        if (customTag != null) {
            return customTag;
        }
        StackTraceElement traceElement = new Throwable().getStackTrace()[2];
        String fileName = traceElement.getFileName();
        if (fileName == null) {
            return SOURCE_FILE;
        }
        return fileName.split("[.]")[0];
    }

    static String formatMessage(String msg, Object ... args) {
        return Log.createLog(args != null && args.length == 0 ? msg : String.format(msg, args));
    }

    private static String createLog(String log) {
        if (withMethodName) {
            StackTraceElement traceElement = new Throwable().getStackTrace()[3];
            if (withLineNumber) {
                return String.format("[%s:%s] %s", traceElement.getMethodName(), traceElement.getLineNumber(), log);
            }
            return String.format("[%s] %s", traceElement.getMethodName(), log);
        }
        return log;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Level {
        public static final int VERBOSE = 2;
        public static final int DEBUG = 3;
        public static final int INFO = 4;
        public static final int WARN = 5;
        public static final int ERROR = 6;
        public static final int SUPPRESS = 10;
    }
}

