/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.animation.Animator;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.IHeader;
import eu.davidea.flexibleadapter.utils.LayoutUtils;
import eu.davidea.flexibleadapter.utils.Log;
import eu.davidea.viewholders.FlexibleViewHolder;

public final class StickyHeaderHelper
extends RecyclerView.OnScrollListener {
    private FlexibleAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private ViewGroup mStickyHolderLayout;
    private FlexibleViewHolder mStickyHeaderViewHolder;
    private FlexibleAdapter.OnStickyHeaderChangeListener mStickyHeaderChangeListener;
    private int mHeaderPosition = -1;
    private boolean displayWithAnimation = false;
    private float mElevation;

    public StickyHeaderHelper(FlexibleAdapter adapter, FlexibleAdapter.OnStickyHeaderChangeListener stickyHeaderChangeListener, ViewGroup stickyHolderLayout) {
        this.mAdapter = adapter;
        this.mStickyHeaderChangeListener = stickyHeaderChangeListener;
        this.mStickyHolderLayout = stickyHolderLayout;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        this.displayWithAnimation = this.mRecyclerView.getScrollState() == 0;
        this.updateOrClearHeader(false);
    }

    public void attachToRecyclerView(RecyclerView parent) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            this.clearHeader();
        }
        if (parent == null) {
            throw new IllegalStateException("Adapter is not attached to RecyclerView. Enable sticky headers after setting adapter to RecyclerView.");
        }
        this.mRecyclerView = parent;
        this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        this.initStickyHeadersHolder();
    }

    public void detachFromRecyclerView() {
        this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
        this.mRecyclerView = null;
        this.clearHeaderWithAnimation();
        Log.d("StickyHolderLayout detached", new Object[0]);
    }

    private FrameLayout createContainer(int width, int height) {
        FrameLayout frameLayout = new FrameLayout(this.mRecyclerView.getContext());
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(width, height));
        return frameLayout;
    }

    private ViewGroup getParent(View view) {
        return (ViewGroup)view.getParent();
    }

    private void initStickyHeadersHolder() {
        if (this.mStickyHolderLayout == null) {
            ViewGroup oldParentLayout = this.getParent((View)this.mRecyclerView);
            if (oldParentLayout != null) {
                this.mStickyHolderLayout = this.createContainer(-2, -2);
                oldParentLayout.addView((View)this.mStickyHolderLayout);
                Log.i("Default StickyHolderLayout initialized", new Object[0]);
            }
        } else {
            Log.i("User defined StickyHolderLayout initialized", new Object[0]);
        }
        this.displayWithAnimation = true;
        this.updateOrClearHeader(false);
    }

    public int getStickyPosition() {
        return this.mHeaderPosition;
    }

    private boolean hasStickyHeaderTranslated(int position) {
        RecyclerView.ViewHolder vh = this.mRecyclerView.findViewHolderForAdapterPosition(position);
        return vh != null && (vh.itemView.getX() < 0.0f || vh.itemView.getY() < 0.0f);
    }

    private void onStickyHeaderChange(int newPosition, int oldPosition) {
        if (this.mStickyHeaderChangeListener != null) {
            this.mStickyHeaderChangeListener.onStickyHeaderChange(newPosition, oldPosition);
        }
    }

    public void updateOrClearHeader(boolean updateHeaderContent) {
        if (!this.mAdapter.areHeadersShown() || this.mAdapter.getItemCount() == 0) {
            this.clearHeaderWithAnimation();
            return;
        }
        int firstHeaderPosition = this.getStickyPosition(-1);
        if (firstHeaderPosition >= 0) {
            this.updateHeader(firstHeaderPosition, updateHeaderContent);
        } else {
            this.clearHeader();
        }
    }

    private void updateHeader(int headerPosition, boolean updateHeaderContent) {
        if (this.mHeaderPosition != headerPosition && this.mStickyHolderLayout != null) {
            int firstVisibleItemPosition = this.mAdapter.getFlexibleLayoutManager().findFirstVisibleItemPosition();
            if (this.displayWithAnimation && this.mHeaderPosition == -1 && headerPosition != firstVisibleItemPosition) {
                this.displayWithAnimation = false;
                this.mStickyHolderLayout.setAlpha(0.0f);
                this.mStickyHolderLayout.animate().alpha(1.0f).start();
            } else {
                this.mStickyHolderLayout.setAlpha(1.0f);
            }
            int oldHeaderPosition = this.mHeaderPosition;
            this.mHeaderPosition = headerPosition;
            FlexibleViewHolder holder = this.getHeaderViewHolder(headerPosition);
            this.swapHeader(holder, oldHeaderPosition);
        } else if (updateHeaderContent) {
            if (this.mStickyHeaderViewHolder.getItemViewType() == this.mAdapter.getItemViewType(headerPosition)) {
                this.mAdapter.onBindViewHolder(this.mStickyHeaderViewHolder, headerPosition);
            } else {
                Log.e("updateHeader Wrong itemViewType for StickyViewHolder=%s, PositionViewHolder=%s", LayoutUtils.getClassName(this.mStickyHeaderViewHolder), LayoutUtils.getClassName(this.getHeaderViewHolder(headerPosition)));
            }
            this.ensureHeaderParent();
        }
        this.translateHeader();
    }

    private void configureLayoutElevation() {
        this.mElevation = ViewCompat.getElevation((View)this.mStickyHeaderViewHolder.getContentView());
        if (this.mElevation == 0.0f) {
            this.mElevation = this.mRecyclerView.getContext().getResources().getDisplayMetrics().density * (float)this.mAdapter.getStickyHeaderElevation();
        }
        if (this.mElevation > 0.0f) {
            ViewCompat.setBackground((View)this.mStickyHolderLayout, (Drawable)this.mStickyHeaderViewHolder.getContentView().getBackground());
        }
    }

    private void translateHeader() {
        int headerOffsetX = 0;
        int headerOffsetY = 0;
        float elevation = this.mElevation;
        for (int i = 0; i < this.mRecyclerView.getChildCount(); ++i) {
            int adapterPos;
            int nextHeaderPosition;
            View nextChild = this.mRecyclerView.getChildAt(i);
            if (nextChild == null || this.mHeaderPosition == (nextHeaderPosition = this.getStickyPosition(adapterPos = this.mRecyclerView.getChildAdapterPosition(nextChild)))) continue;
            if (this.mAdapter.getFlexibleLayoutManager().getOrientation() == 0) {
                if (nextChild.getLeft() <= 0) continue;
                int headerWidth = this.mStickyHolderLayout.getMeasuredWidth();
                int nextHeaderOffsetX = nextChild.getLeft() - headerWidth - this.mRecyclerView.getLayoutManager().getLeftDecorationWidth(nextChild) - this.mRecyclerView.getLayoutManager().getRightDecorationWidth(nextChild);
                headerOffsetX = Math.min(nextHeaderOffsetX, 0);
                if (nextHeaderOffsetX < 5) {
                    elevation = 0.0f;
                }
                if (headerOffsetX >= 0) continue;
                break;
            }
            if (nextChild.getTop() <= 0) continue;
            int headerHeight = this.mStickyHolderLayout.getMeasuredHeight();
            int nextHeaderOffsetY = nextChild.getTop() - headerHeight - this.mRecyclerView.getLayoutManager().getTopDecorationHeight(nextChild) - this.mRecyclerView.getLayoutManager().getBottomDecorationHeight(nextChild);
            headerOffsetY = Math.min(nextHeaderOffsetY, 0);
            if (nextHeaderOffsetY < 5) {
                elevation = 0.0f;
            }
            if (headerOffsetY < 0) break;
        }
        ViewCompat.setElevation((View)this.mStickyHolderLayout, (float)elevation);
        this.mStickyHolderLayout.setTranslationX((float)headerOffsetX);
        this.mStickyHolderLayout.setTranslationY((float)headerOffsetY);
    }

    private void swapHeader(FlexibleViewHolder newHeader, int oldHeaderPosition) {
        Log.d("swapHeader newHeaderPosition=%s", this.mHeaderPosition);
        if (this.mStickyHeaderViewHolder != null) {
            this.resetHeader(this.mStickyHeaderViewHolder);
            if (this.mHeaderPosition > oldHeaderPosition) {
                this.mAdapter.onViewRecycled(this.mStickyHeaderViewHolder);
            }
        }
        this.mStickyHeaderViewHolder = newHeader;
        this.mStickyHeaderViewHolder.setIsRecyclable(false);
        this.ensureHeaderParent();
        this.onStickyHeaderChange(this.mHeaderPosition, oldHeaderPosition);
    }

    public void ensureHeaderParent() {
        View view = this.mStickyHeaderViewHolder.getContentView();
        this.mStickyHeaderViewHolder.itemView.getLayoutParams().width = view.getMeasuredWidth();
        this.mStickyHeaderViewHolder.itemView.getLayoutParams().height = view.getMeasuredHeight();
        this.mStickyHeaderViewHolder.itemView.setVisibility(4);
        this.applyLayoutParamsAndMargins(view);
        StickyHeaderHelper.removeViewFromParent(view);
        StickyHeaderHelper.addViewToParent(this.mStickyHolderLayout, view);
        this.configureLayoutElevation();
    }

    private void applyLayoutParamsAndMargins(View view) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mStickyHolderLayout.getLayoutParams();
        params.width = view.getLayoutParams().width;
        params.height = view.getLayoutParams().height;
        if (params.leftMargin == 0) {
            params.leftMargin = this.mRecyclerView.getLayoutManager().getLeftDecorationWidth(this.mStickyHeaderViewHolder.itemView);
        }
        if (params.topMargin == 0) {
            params.topMargin = this.mRecyclerView.getLayoutManager().getTopDecorationHeight(this.mStickyHeaderViewHolder.itemView);
        }
        if (params.rightMargin == 0) {
            params.rightMargin = this.mRecyclerView.getLayoutManager().getRightDecorationWidth(this.mStickyHeaderViewHolder.itemView);
        }
        if (params.bottomMargin == 0) {
            params.bottomMargin = this.mRecyclerView.getLayoutManager().getBottomDecorationHeight(this.mStickyHeaderViewHolder.itemView);
        }
    }

    private void restoreHeaderItemVisibility() {
        if (this.mRecyclerView == null) {
            return;
        }
        for (int i = 0; i < this.mRecyclerView.getChildCount(); ++i) {
            View oldHeader = this.mRecyclerView.getChildAt(i);
            int headerPos = this.mRecyclerView.getChildAdapterPosition(oldHeader);
            if (!this.mAdapter.isHeader(this.mAdapter.getItem(headerPos))) continue;
            oldHeader.setVisibility(0);
        }
    }

    private void resetHeader(FlexibleViewHolder header) {
        this.restoreHeaderItemVisibility();
        View view = header.getContentView();
        StickyHeaderHelper.removeViewFromParent(view);
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
        if (!header.itemView.equals(view)) {
            StickyHeaderHelper.addViewToParent((ViewGroup)header.itemView, view);
        }
        header.setIsRecyclable(true);
        header.itemView.getLayoutParams().width = view.getLayoutParams().width;
        header.itemView.getLayoutParams().height = view.getLayoutParams().height;
    }

    private void clearHeader() {
        if (this.mStickyHeaderViewHolder != null) {
            Log.d("clearHeader", new Object[0]);
            this.resetHeader(this.mStickyHeaderViewHolder);
            this.mStickyHolderLayout.setAlpha(0.0f);
            this.mStickyHolderLayout.animate().cancel();
            this.mStickyHolderLayout.animate().setListener(null);
            this.mStickyHeaderViewHolder = null;
            this.restoreHeaderItemVisibility();
            int oldPosition = this.mHeaderPosition;
            this.mHeaderPosition = -1;
            this.onStickyHeaderChange(this.mHeaderPosition, oldPosition);
        }
    }

    public void clearHeaderWithAnimation() {
        if (this.mStickyHeaderViewHolder != null && this.mHeaderPosition != -1) {
            this.mStickyHolderLayout.animate().setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    StickyHeaderHelper.this.mHeaderPosition = -1;
                }

                public void onAnimationEnd(Animator animation) {
                    StickyHeaderHelper.this.displayWithAnimation = true;
                    StickyHeaderHelper.this.mStickyHolderLayout.setAlpha(0.0f);
                    StickyHeaderHelper.this.clearHeader();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.mStickyHolderLayout.animate().alpha(0.0f).start();
        }
    }

    private static void addViewToParent(ViewGroup parent, View child) {
        try {
            parent.addView(child);
        }
        catch (IllegalStateException e) {
            Log.wtf("The specified child already has a parent! (but parent was removed!)", new Object[0]);
        }
    }

    private static void removeViewFromParent(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(view);
        }
    }

    private int getStickyPosition(int adapterPosHere) {
        if (adapterPosHere == -1 && (adapterPosHere = this.mAdapter.getFlexibleLayoutManager().findFirstVisibleItemPosition()) == 0 && !this.hasStickyHeaderTranslated(0)) {
            return -1;
        }
        IHeader header = this.mAdapter.getSectionHeader(adapterPosHere);
        if (header == null || this.mAdapter.isExpandable(header) && !this.mAdapter.isExpanded(header)) {
            return -1;
        }
        return this.mAdapter.getGlobalPositionOf(header);
    }

    private FlexibleViewHolder getHeaderViewHolder(int position) {
        FlexibleViewHolder holder = (FlexibleViewHolder)this.mRecyclerView.findViewHolderForAdapterPosition(position);
        if (holder == null) {
            int heightSpec;
            int widthSpec;
            holder = (FlexibleViewHolder)this.mAdapter.createViewHolder((ViewGroup)this.mRecyclerView, this.mAdapter.getItemViewType(position));
            holder.setIsRecyclable(false);
            this.mAdapter.bindViewHolder(holder, position);
            holder.setIsRecyclable(true);
            if (this.mAdapter.getFlexibleLayoutManager().getOrientation() == 1) {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getWidth(), (int)0x40000000);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getHeight(), (int)0);
            } else {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getWidth(), (int)0);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mRecyclerView.getHeight(), (int)0x40000000);
            }
            View headerView = holder.getContentView();
            int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(this.mRecyclerView.getPaddingLeft() + this.mRecyclerView.getPaddingRight()), (int)headerView.getLayoutParams().width);
            int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.mRecyclerView.getPaddingTop() + this.mRecyclerView.getPaddingBottom()), (int)headerView.getLayoutParams().height);
            headerView.measure(childWidth, childHeight);
            headerView.layout(0, 0, headerView.getMeasuredWidth(), headerView.getMeasuredHeight());
        }
        holder.setBackupPosition(position);
        return holder;
    }
}

