/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.graphics.Canvas;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import eu.davidea.flexibleadapter.utils.LayoutUtils;

public class ItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    protected static final float ALPHA_FULL = 1.0f;
    protected AdapterCallback mAdapterCallback;
    protected boolean longPressDragEnabled = false;
    protected boolean handleDragEnabled = false;
    protected boolean swipeEnabled = false;
    protected long mSwipeAnimationDuration = 300L;
    protected long mDragAnimationDuration = 400L;
    protected float mSwipeThreshold = 0.5f;
    protected float mMoveThreshold = 0.5f;
    protected int mSwipeFlags = -1;

    public ItemTouchHelperCallback(AdapterCallback adapterCallback) {
        this.mAdapterCallback = adapterCallback;
    }

    public void setLongPressDragEnabled(boolean isLongPressDragEnabled) {
        this.longPressDragEnabled = isLongPressDragEnabled;
    }

    public boolean isLongPressDragEnabled() {
        return this.longPressDragEnabled;
    }

    public boolean isHandleDragEnabled() {
        return this.handleDragEnabled;
    }

    public void setHandleDragEnabled(boolean handleDragEnabled) {
        this.handleDragEnabled = handleDragEnabled;
    }

    public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
        return true;
    }

    public void setMoveThreshold(float moveThreshold) {
        this.mMoveThreshold = moveThreshold;
    }

    public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
        return this.mMoveThreshold;
    }

    public void setSwipeEnabled(boolean isSwipeEnabled) {
        this.swipeEnabled = isSwipeEnabled;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.swipeEnabled;
    }

    public void setSwipeThreshold(@FloatRange(from=0.0, to=1.0) float threshold) {
        this.mSwipeThreshold = threshold;
    }

    public void setSwipeFlags(int swipeFlags) {
        this.mSwipeFlags = swipeFlags;
    }

    public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
        return this.mSwipeThreshold;
    }

    public void setDragAnimationDuration(long animationDuration) {
        this.mDragAnimationDuration = animationDuration;
    }

    public void setSwipeAnimationDuration(long animationDuration) {
        this.mSwipeAnimationDuration = animationDuration;
    }

    public long getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
        return animationType == 8 ? this.mDragAnimationDuration : this.mSwipeAnimationDuration;
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        if (!this.mAdapterCallback.shouldMove(viewHolder.getAdapterPosition(), target.getAdapterPosition())) {
            return false;
        }
        this.mAdapterCallback.onItemMove(viewHolder.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        ViewHolderCallback viewHolderCallback;
        if (viewHolder instanceof ViewHolderCallback && (viewHolderCallback = (ViewHolderCallback)viewHolder).getFrontView().getTranslationX() != 0.0f) {
            this.mAdapterCallback.onItemSwiped(viewHolder.getAdapterPosition(), direction);
        }
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        int swipeFlags;
        int dragFlags;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager || layoutManager instanceof StaggeredGridLayoutManager) {
            dragFlags = 15;
            swipeFlags = 0;
        } else if (LayoutUtils.getOrientation(recyclerView) == 0) {
            dragFlags = 12;
            swipeFlags = this.mSwipeFlags > 0 ? this.mSwipeFlags : 3;
        } else {
            dragFlags = 3;
            int n = swipeFlags = this.mSwipeFlags > 0 ? this.mSwipeFlags : 12;
        }
        if (viewHolder instanceof ViewHolderCallback) {
            ViewHolderCallback viewHolderCallback = (ViewHolderCallback)viewHolder;
            if (!viewHolderCallback.isDraggable()) {
                dragFlags = 0;
            }
            if (!viewHolderCallback.isSwipeable()) {
                swipeFlags = 0;
            }
        }
        return ItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        this.mAdapterCallback.onActionStateChanged(viewHolder, actionState);
        if (actionState != 0) {
            if (viewHolder instanceof ViewHolderCallback) {
                ViewHolderCallback viewHolderCallback = (ViewHolderCallback)viewHolder;
                viewHolderCallback.onActionStateChanged(viewHolder.getAdapterPosition(), actionState);
                if (actionState == 1) {
                    ItemTouchHelperCallback.getDefaultUIUtil().onSelected(viewHolderCallback.getFrontView());
                }
            }
        } else {
            super.onSelectedChanged(viewHolder, actionState);
        }
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        viewHolder.itemView.setAlpha(1.0f);
        if (viewHolder instanceof ViewHolderCallback) {
            ViewHolderCallback viewHolderCallback = (ViewHolderCallback)viewHolder;
            ItemTouchHelperCallback.getDefaultUIUtil().clearView(viewHolderCallback.getFrontView());
            ItemTouchHelperCallback.setLayoutVisibility(viewHolderCallback, 0);
            viewHolderCallback.onItemReleased(viewHolder.getAdapterPosition());
        }
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1 && viewHolder instanceof ViewHolderCallback) {
            ViewHolderCallback viewHolderCallback = (ViewHolderCallback)viewHolder;
            View frontView = viewHolderCallback.getFrontView();
            float dragAmount = dX;
            if (dY != 0.0f) {
                dragAmount = dY;
            }
            int swipingDirection = 0;
            if (dragAmount > 0.0f) {
                swipingDirection = 8;
            } else if (dragAmount < 0.0f) {
                swipingDirection = 4;
            }
            ItemTouchHelperCallback.setLayoutVisibility(viewHolderCallback, swipingDirection);
            ItemTouchHelperCallback.getDefaultUIUtil().onDraw(c, recyclerView, frontView, dX, dY, actionState, isCurrentlyActive);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    private static void setLayoutVisibility(ViewHolderCallback viewHolderCallback, int swipeDirection) {
        if (viewHolderCallback.getRearRightView() != null) {
            viewHolderCallback.getRearRightView().setVisibility(swipeDirection == 4 ? 0 : 8);
        }
        if (viewHolderCallback.getRearLeftView() != null) {
            viewHolderCallback.getRearLeftView().setVisibility(swipeDirection == 8 ? 0 : 8);
        }
    }

    public static interface ViewHolderCallback {
        public void onActionStateChanged(int var1, int var2);

        public void onItemReleased(int var1);

        public boolean isDraggable();

        public boolean isSwipeable();

        public View getFrontView();

        public View getRearLeftView();

        public View getRearRightView();
    }

    public static interface AdapterCallback {
        public void onActionStateChanged(RecyclerView.ViewHolder var1, int var2);

        public boolean shouldMove(int var1, int var2);

        public boolean onItemMove(int var1, int var2);

        public void onItemSwiped(int var1, int var2);
    }
}

