/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.SparseArray;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import eu.davidea.flexibleadapter.SelectableAdapter;
import eu.davidea.flexibleadapter.utils.LayoutUtils;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.util.ArrayList;
import java.util.EnumSet;

public abstract class AnimatorAdapter
extends SelectableAdapter {
    private Interpolator mInterpolator = new LinearInterpolator();
    private AnimatorAdapterDataObserver mAnimatorNotifierObserver;
    private boolean mEntryStep = true;
    private final SparseArray<Animator> mAnimators = new SparseArray();
    private int mLastAnimatedPosition = -1;
    private int mMaxChildViews = -1;
    private EnumSet<AnimatorEnum> animatorsUsed = EnumSet.noneOf(AnimatorEnum.class);
    private boolean isReverseEnabled = false;
    private boolean isForwardEnabled = false;
    private boolean onlyEntryAnimation = false;
    private boolean animateFromObserver = false;
    private static long DEFAULT_DURATION = 300L;
    private long mInitialDelay = 0L;
    private long mStepDelay = 100L;
    private long mDuration = DEFAULT_DURATION;

    AnimatorAdapter(boolean stableIds) {
        this.setHasStableIds(stableIds);
        this.log.i("Initialized with StableIds=" + stableIds, new Object[0]);
        this.mAnimatorNotifierObserver = new AnimatorAdapterDataObserver();
        this.registerAdapterDataObserver(this.mAnimatorNotifierObserver);
    }

    void setScrollAnimate(boolean animate) {
        this.animateFromObserver = animate;
    }

    public AnimatorAdapter setAnimationInitialDelay(long initialDelay) {
        this.log.i("Set animationInitialDelay=%s", initialDelay);
        this.mInitialDelay = initialDelay;
        return this;
    }

    public AnimatorAdapter setAnimationDelay(@IntRange(from=0L) long delay) {
        this.log.i("Set animationDelay=%s", delay);
        this.mStepDelay = delay;
        return this;
    }

    public AnimatorAdapter setAnimationEntryStep(boolean entryStep) {
        this.log.i("Set animationEntryStep=%s", entryStep);
        this.mEntryStep = entryStep;
        return this;
    }

    public AnimatorAdapter setAnimationDuration(@IntRange(from=1L) long duration) {
        this.log.i("Set animationDuration=%s", duration);
        this.mDuration = duration;
        return this;
    }

    public AnimatorAdapter setAnimationInterpolator(@NonNull Interpolator interpolator) {
        this.log.i("Set animationInterpolator=%s", LayoutUtils.getClassName(interpolator));
        this.mInterpolator = interpolator;
        return this;
    }

    public AnimatorAdapter setAnimationOnForwardScrolling(boolean enabled) {
        this.log.i("Set animationOnForwardScrolling=%s", enabled);
        if (enabled) {
            this.onlyEntryAnimation = false;
        }
        this.isForwardEnabled = enabled;
        return this;
    }

    public boolean isAnimationOnForwardScrollingEnabled() {
        return this.isForwardEnabled;
    }

    public AnimatorAdapter setAnimationOnReverseScrolling(boolean enabled) {
        this.log.i("Set animationOnReverseScrolling=%s", enabled);
        this.isReverseEnabled = enabled;
        return this;
    }

    public boolean isAnimationOnReverseScrollingEnabled() {
        return this.isReverseEnabled;
    }

    public AnimatorAdapter setOnlyEntryAnimation(boolean enabled) {
        this.log.i("Set onlyEntryAnimation=%s", enabled);
        if (enabled) {
            this.isForwardEnabled = true;
        }
        this.onlyEntryAnimation = enabled;
        return this;
    }

    public boolean isOnlyEntryAnimation() {
        return this.onlyEntryAnimation;
    }

    private void cancelExistingAnimation(int hashCode) {
        Animator animator = (Animator)this.mAnimators.get(hashCode);
        if (animator != null) {
            animator.end();
        }
    }

    public abstract boolean isScrollableHeaderOrFooter(int var1);

    protected final void animateView(RecyclerView.ViewHolder holder, int position) {
        if (this.mRecyclerView == null) {
            return;
        }
        if (this.mMaxChildViews < this.mRecyclerView.getChildCount()) {
            this.mMaxChildViews = this.mRecyclerView.getChildCount();
        }
        if (this.onlyEntryAnimation && this.mLastAnimatedPosition >= this.mMaxChildViews) {
            this.isForwardEnabled = false;
        }
        int lastVisiblePosition = this.getFlexibleLayoutManager().findLastVisibleItemPosition();
        if ((this.isForwardEnabled || this.isReverseEnabled) && !this.isFastScroll && holder instanceof FlexibleViewHolder && (!this.mAnimatorNotifierObserver.isPositionNotified() || this.isScrollableHeaderOrFooter(position)) && (this.isScrollableHeaderOrFooter(position) || this.isForwardEnabled && position > lastVisiblePosition || this.isReverseEnabled && position < lastVisiblePosition || position == 0 && this.mMaxChildViews == 0)) {
            int hashCode = holder.itemView.hashCode();
            this.cancelExistingAnimation(hashCode);
            ArrayList<Animator> animators = new ArrayList<Animator>();
            FlexibleViewHolder flexibleViewHolder = (FlexibleViewHolder)holder;
            flexibleViewHolder.scrollAnimators(animators, position, position >= lastVisiblePosition);
            AnimatorSet set = new AnimatorSet();
            set.playTogether(animators);
            set.setInterpolator((TimeInterpolator)this.mInterpolator);
            long duration = this.mDuration;
            for (Animator animator : animators) {
                if (animator.getDuration() == DEFAULT_DURATION) continue;
                duration = animator.getDuration();
            }
            set.setDuration(duration);
            set.addListener((Animator.AnimatorListener)new HelperAnimatorListener(hashCode));
            if (this.mEntryStep) {
                set.setStartDelay(this.calculateAnimationDelay(holder, position));
            }
            set.start();
            this.mAnimators.put(hashCode, (Object)set);
        }
        this.mAnimatorNotifierObserver.clearNotified();
        this.mLastAnimatedPosition = position;
    }

    private long calculateAnimationDelay(RecyclerView.ViewHolder holder, int position) {
        long delay;
        int firstVisiblePosition = this.getFlexibleLayoutManager().findFirstCompletelyVisibleItemPosition();
        int lastVisiblePosition = this.getFlexibleLayoutManager().findLastCompletelyVisibleItemPosition();
        if (firstVisiblePosition < 0 && position >= 0) {
            firstVisiblePosition = position - 1;
        }
        if (position - 1 > lastVisiblePosition) {
            lastVisiblePosition = position - 1;
        }
        int visibleItems = lastVisiblePosition - firstVisiblePosition;
        int numberOfAnimatedItems = position - 1;
        if (this.mMaxChildViews == 0 || visibleItems < numberOfAnimatedItems || firstVisiblePosition > 1 && firstVisiblePosition <= this.mMaxChildViews || position > this.mMaxChildViews && firstVisiblePosition == -1 && this.mRecyclerView.getChildCount() == 0) {
            delay = this.mStepDelay;
            if (visibleItems <= 1) {
                delay += this.mInitialDelay;
            } else {
                this.mInitialDelay = 0L;
            }
            int numColumns = this.getFlexibleLayoutManager().getSpanCount();
            if (numColumns > 1) {
                delay = this.mInitialDelay + this.mStepDelay * (long)(position % numColumns);
            }
        } else {
            delay = this.mInitialDelay + (long)position * this.mStepDelay;
        }
        return delay;
    }

    private class HelperAnimatorListener
    implements Animator.AnimatorListener {
        int key;

        HelperAnimatorListener(int key) {
            this.key = key;
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimatorAdapter.this.mAnimators.remove(this.key);
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private class AnimatorAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private boolean notified;
        private Handler mAnimatorHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                AnimatorAdapterDataObserver.this.notified = false;
                return true;
            }
        });

        private AnimatorAdapterDataObserver() {
        }

        public boolean isPositionNotified() {
            return this.notified;
        }

        public void clearNotified() {
            if (this.notified) {
                this.mAnimatorHandler.removeCallbacksAndMessages(null);
                this.mAnimatorHandler.sendMessageDelayed(Message.obtain((Handler)this.mAnimatorHandler), 200L);
            }
        }

        private void markNotified() {
            this.notified = true;
        }

        public void onChanged() {
            this.markNotified();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.markNotified();
        }
    }

    private static enum AnimatorEnum {
        ALPHA,
        SLIDE_IN_LEFT,
        SLIDE_IN_RIGHT,
        SLIDE_IN_BOTTOM,
        SLIDE_IN_TOP,
        SCALE;

    }
}

