/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.fastscroller;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import eu.davidea.fastscroller.BubbleAnimator;
import eu.davidea.fastscroller.ScrollbarAnimator;
import eu.davidea.flexibleadapter.R;
import eu.davidea.flexibleadapter.utils.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class FastScroller
extends FrameLayout {
    protected static final int TRACK_SNAP_RANGE = 5;
    protected static final int BUBBLE_ANIMATION_DURATION = 300;
    protected static final int AUTOHIDE_ANIMATION_DURATION = 300;
    protected static final int DEFAULT_AUTOHIDE_DELAY_IN_MILLIS = 1000;
    protected static final float DEFAULT_HANDLE_OPACITY = 1.0f;
    protected static final boolean DEFAULT_AUTOHIDE_ENABLED = true;
    private static final int DEFAULT_BUBBLE_POSITION = 0;
    protected TextView bubble;
    protected ImageView handle;
    protected View bar;
    protected int height;
    protected int width;
    protected int minimumScrollThreshold;
    protected RecyclerView recyclerView;
    protected RecyclerView.LayoutManager layoutManager;
    protected BubbleTextCreator bubbleTextCreator;
    protected List<OnScrollStateChangeListener> scrollStateChangeListeners = new ArrayList<OnScrollStateChangeListener>();
    protected int bubbleAndHandleColor = 0;
    protected long autoHideDelayInMillis;
    protected boolean isInitialized;
    protected boolean autoHideEnabled;
    protected boolean bubbleEnabled;
    protected boolean ignoreTouchesOutsideHandle;
    protected boolean handleAlwaysVisible;
    protected int bubblePosition;
    protected BubbleAnimator bubbleAnimator;
    protected ScrollbarAnimator scrollbarAnimator;
    protected RecyclerView.OnScrollListener onScrollListener;

    public FastScroller(Context context) {
        super(context);
        this.init();
    }

    public FastScroller(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScroller(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FastScroller, 0, 0);
        try {
            this.autoHideEnabled = a.getBoolean(R.styleable.FastScroller_fastScrollerAutoHideEnabled, true);
            this.autoHideDelayInMillis = a.getInteger(R.styleable.FastScroller_fastScrollerAutoHideDelayInMillis, 1000);
            this.bubbleEnabled = a.getBoolean(R.styleable.FastScroller_fastScrollerBubbleEnabled, true);
            this.bubblePosition = a.getInteger(R.styleable.FastScroller_fastScrollerBubblePosition, 0);
            this.ignoreTouchesOutsideHandle = a.getBoolean(R.styleable.FastScroller_fastScrollerIgnoreTouchesOutsideHandle, false);
            this.handleAlwaysVisible = a.getBoolean(R.styleable.FastScroller_fastScrollerHandleAlwaysVisible, false);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    protected void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setClipChildren(false);
        this.onScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (!FastScroller.this.isEnabled() || FastScroller.this.bubble == null || FastScroller.this.handle.isSelected()) {
                    return;
                }
                int verticalScrollOffset = recyclerView.computeVerticalScrollOffset();
                int verticalScrollRange = recyclerView.computeVerticalScrollRange();
                float proportion = (float)verticalScrollOffset / (float)(verticalScrollRange - FastScroller.this.height);
                FastScroller.this.setBubbleAndHandlePosition((float)FastScroller.this.height * proportion);
                if (FastScroller.this.minimumScrollThreshold == 0 || dy == 0 || Math.abs(dy) > FastScroller.this.minimumScrollThreshold || FastScroller.this.scrollbarAnimator.isAnimating()) {
                    FastScroller.this.showScrollbar();
                    FastScroller.this.autoHideScrollbar();
                }
            }
        };
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        if (this.onScrollListener != null) {
            this.recyclerView.removeOnScrollListener(this.onScrollListener);
        }
        this.recyclerView.addOnScrollListener(this.onScrollListener);
        this.recyclerView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                FastScroller.this.layoutManager = FastScroller.this.recyclerView.getLayoutManager();
            }
        });
        if (recyclerView.getAdapter() instanceof BubbleTextCreator) {
            this.setBubbleTextCreator((BubbleTextCreator)recyclerView.getAdapter());
        }
        if (recyclerView.getAdapter() instanceof OnScrollStateChangeListener) {
            this.addOnScrollStateChangeListener((OnScrollStateChangeListener)recyclerView.getAdapter());
        }
        this.recyclerView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                FastScroller.this.recyclerView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                if (FastScroller.this.bubble == null || FastScroller.this.handle.isSelected()) {
                    return true;
                }
                int verticalScrollOffset = FastScroller.this.recyclerView.computeVerticalScrollOffset();
                int verticalScrollRange = FastScroller.this.computeVerticalScrollRange();
                float proportion = (float)verticalScrollOffset / (float)(verticalScrollRange - FastScroller.this.height);
                FastScroller.this.setBubbleAndHandlePosition((float)FastScroller.this.height * proportion);
                return true;
            }
        });
    }

    public void setBubbleTextCreator(BubbleTextCreator bubbleTextCreator) {
        this.bubbleTextCreator = bubbleTextCreator;
    }

    public void addOnScrollStateChangeListener(OnScrollStateChangeListener stateChangeListener) {
        if (stateChangeListener != null && !this.scrollStateChangeListeners.contains(stateChangeListener)) {
            this.scrollStateChangeListeners.add(stateChangeListener);
        }
    }

    public void removeOnScrollStateChangeListener(OnScrollStateChangeListener stateChangeListener) {
        this.scrollStateChangeListeners.remove(stateChangeListener);
    }

    protected void notifyScrollStateChange(boolean scrolling) {
        for (OnScrollStateChangeListener stateChangeListener : this.scrollStateChangeListeners) {
            stateChangeListener.onFastScrollerStateChange(scrolling);
        }
    }

    public void setViewsToUse(@LayoutRes int layoutResId, @IdRes int bubbleResId, @IdRes int handleResId) {
        if (this.bubble != null) {
            return;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        inflater.inflate(layoutResId, (ViewGroup)this, true);
        this.bubble = (TextView)this.findViewById(bubbleResId);
        if (this.bubble != null) {
            this.bubble.setVisibility(4);
        }
        this.handle = (ImageView)this.findViewById(handleResId);
        this.bar = this.findViewById(R.id.fast_scroller_bar);
        this.bubbleAnimator = new BubbleAnimator((View)this.bubble, 300L);
        this.scrollbarAnimator = new ScrollbarAnimator(this.bar, (View)this.handle, this.handleAlwaysVisible, this.autoHideDelayInMillis, 300L);
        if (this.bubbleAndHandleColor != 0) {
            this.setBubbleAndHandleColor(this.bubbleAndHandleColor);
        }
    }

    public void setBubbleAndHandleColor(@ColorInt int color) {
        this.bubbleAndHandleColor = color;
        if (this.bubble != null) {
            GradientDrawable bubbleDrawable = Build.VERSION.SDK_INT >= 21 ? (GradientDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_bubble, null) : (GradientDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_bubble);
            bubbleDrawable.setColor(color);
            if (Build.VERSION.SDK_INT >= 16) {
                this.bubble.setBackground((Drawable)bubbleDrawable);
            } else {
                this.bubble.setBackgroundDrawable((Drawable)bubbleDrawable);
            }
        }
        if (this.handle != null) {
            try {
                StateListDrawable stateListDrawable = Build.VERSION.SDK_INT >= 21 ? (StateListDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_handle, null) : (StateListDrawable)this.getResources().getDrawable(R.drawable.fast_scroller_handle);
                Method getStateDrawable = StateListDrawable.class.getMethod("getStateDrawable", Integer.TYPE);
                GradientDrawable handleDrawable = (GradientDrawable)getStateDrawable.invoke((Object)stateListDrawable, 0);
                handleDrawable.setColor(color);
                this.handle.setImageDrawable((Drawable)stateListDrawable);
            }
            catch (Exception e) {
                Log.wtf(e, "Exception while setting Bubble and Handle Color", new Object[0]);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = h;
        this.width = w;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.recyclerView.computeVerticalScrollRange() <= this.recyclerView.computeVerticalScrollExtent()) {
            return super.onTouchEvent(event);
        }
        int action = event.getAction();
        switch (action) {
            case 0: {
                if (event.getX() < this.handle.getX() - (float)ViewCompat.getPaddingStart((View)this.handle)) {
                    return false;
                }
                if (this.ignoreTouchesOutsideHandle && (event.getY() < this.handle.getY() || event.getY() > this.handle.getY() + (float)this.handle.getHeight())) {
                    return false;
                }
                this.handle.setSelected(true);
                this.notifyScrollStateChange(true);
                this.showBubble();
                this.showScrollbar();
            }
            case 2: {
                float y = event.getY();
                this.setBubbleAndHandlePosition(y);
                this.setRecyclerViewPosition(y);
                return true;
            }
            case 1: 
            case 3: {
                this.handle.setSelected(false);
                this.notifyScrollStateChange(false);
                this.hideBubble();
                this.autoHideScrollbar();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.recyclerView != null) {
            this.recyclerView.addOnScrollListener(this.onScrollListener);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.recyclerView != null) {
            this.recyclerView.removeOnScrollListener(this.onScrollListener);
        }
    }

    protected void setRecyclerViewPosition(float y) {
        if (this.recyclerView != null) {
            int targetPos = this.getTargetPos(y);
            if (this.layoutManager instanceof StaggeredGridLayoutManager) {
                ((StaggeredGridLayoutManager)this.layoutManager).scrollToPositionWithOffset(targetPos, 0);
            } else {
                ((LinearLayoutManager)this.layoutManager).scrollToPositionWithOffset(targetPos, 0);
            }
            this.updateBubbleText(targetPos);
        }
    }

    protected int getTargetPos(float currY) {
        int itemCount = this.recyclerView.getAdapter().getItemCount();
        float proportion = this.handle.getY() == 0.0f ? 0.0f : (this.handle.getY() + (float)this.handle.getHeight() >= (float)(this.height - 5) ? 1.0f : currY / (float)this.height);
        return FastScroller.getValueInRange(0, itemCount - 1, (int)(proportion * (float)itemCount));
    }

    protected void updateBubbleText(int position) {
        if (this.bubble != null && this.bubbleEnabled) {
            String bubbleText = this.bubbleTextCreator.onCreateBubbleText(position);
            if (bubbleText != null) {
                this.bubble.setVisibility(0);
                this.bubble.setText((CharSequence)bubbleText);
            } else {
                this.bubble.setVisibility(8);
            }
        }
    }

    protected static int getValueInRange(int min, int max, int value) {
        int minimum = Math.max(min, value);
        return Math.min(minimum, max);
    }

    protected void setBubbleAndHandlePosition(float y) {
        if (this.height == 0) {
            return;
        }
        int handleHeight = this.handle.getHeight();
        y -= y * (float)handleHeight / (float)this.height;
        this.handle.setY((float)FastScroller.getValueInRange(0, this.height - handleHeight, (int)y));
        if (this.bubble != null) {
            int bubbleHeight = this.bubble.getHeight();
            if (this.bubblePosition == 0) {
                this.bubble.setY((float)FastScroller.getValueInRange(0, this.height - bubbleHeight - handleHeight / 2, (int)(y - (float)bubbleHeight / 1.5f)));
            } else {
                this.bubble.setY((float)Math.max(0, (this.height - this.bubble.getHeight()) / 2));
                this.bubble.setX((float)Math.max(0, (this.width - this.bubble.getWidth()) / 2));
            }
        }
    }

    protected void showBubble() {
        if (this.bubbleEnabled) {
            this.bubbleAnimator.showBubble();
        }
    }

    protected void hideBubble() {
        this.bubbleAnimator.hideBubble();
    }

    public boolean isHidden() {
        return this.bar == null || this.handle == null || this.bar.getVisibility() == 4 || this.handle.getVisibility() == 4;
    }

    public boolean isAutoHideEnabled() {
        return this.autoHideEnabled;
    }

    public void setAutoHideEnabled(boolean autoHideEnabled) {
        this.autoHideEnabled = autoHideEnabled;
    }

    public long getAutoHideDelayInMillis() {
        return this.autoHideDelayInMillis;
    }

    public void setAutoHideDelayInMillis(@IntRange(from=0L) long autoHideDelayInMillis) {
        this.autoHideDelayInMillis = autoHideDelayInMillis;
        if (this.scrollbarAnimator != null) {
            this.scrollbarAnimator.setDelayInMillis(autoHideDelayInMillis);
        }
    }

    public void setIgnoreTouchesOutsideHandle(boolean ignoreFlag) {
        this.ignoreTouchesOutsideHandle = ignoreFlag;
    }

    public void setHandleAlwaysVisible(boolean enabled) {
        this.ignoreTouchesOutsideHandle = enabled;
    }

    public void setMinimumScrollThreshold(@IntRange(from=0L) int dy) {
        this.minimumScrollThreshold = dy;
    }

    public void showScrollbar() {
        if (this.scrollbarAnimator != null) {
            this.scrollbarAnimator.showScrollbar();
        }
    }

    public void hideScrollbar() {
        if (this.scrollbarAnimator != null) {
            this.scrollbarAnimator.hideScrollbar();
        }
    }

    private void autoHideScrollbar() {
        if (this.autoHideEnabled) {
            this.hideScrollbar();
        }
    }

    public void toggleFastScroller() {
        this.setEnabled(!this.isEnabled());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.showScrollbar();
            this.autoHideScrollbar();
        } else {
            this.hideScrollbar();
        }
    }

    public static class Delegate {
        private static final String TAG = Delegate.class.getSimpleName();
        private static final boolean DEBUG = false;
        private RecyclerView mRecyclerView;
        private FastScroller mFastScroller;

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
            this.mRecyclerView = recyclerView;
        }

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
            this.mFastScroller = null;
            this.mRecyclerView = null;
        }

        public void toggleFastScroller() {
            if (this.mFastScroller != null) {
                this.mFastScroller.toggleFastScroller();
            }
        }

        public boolean isFastScrollerEnabled() {
            return this.mFastScroller != null && this.mFastScroller.isEnabled();
        }

        @Nullable
        public FastScroller getFastScroller() {
            return this.mFastScroller;
        }

        public void setFastScroller(@Nullable FastScroller fastScroller) {
            if (this.mRecyclerView == null) {
                throw new IllegalStateException("RecyclerView cannot be null. Setup FastScroller after the Adapter has been added to the RecyclerView.");
            }
            if (fastScroller != null) {
                this.mFastScroller = fastScroller;
                this.mFastScroller.setRecyclerView(this.mRecyclerView);
                this.mFastScroller.setEnabled(true);
                this.mFastScroller.setViewsToUse(R.layout.library_fast_scroller_layout, R.id.fast_scroller_bubble, R.id.fast_scroller_handle);
            } else if (this.mFastScroller != null) {
                this.mFastScroller.setEnabled(false);
                this.mFastScroller = null;
            }
        }
    }

    public static interface AdapterInterface {
        public void setFastScroller(@NonNull FastScroller var1);
    }

    public static interface OnScrollStateChangeListener {
        public void onFastScrollerStateChange(boolean var1);
    }

    public static interface BubbleTextCreator {
        public String onCreateBubbleText(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FastScrollerBubblePosition {
        public static final int ADJACENT = 0;
        public static final int CENTER = 1;
    }
}

