/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.animation.Animator;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.MotionEvent;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.flexibleadapter.utils.LayoutUtils;
import eu.davidea.flexibleadapter.utils.Log;
import eu.davidea.viewholders.ContentViewHolder;
import java.util.List;

public abstract class FlexibleViewHolder
extends ContentViewHolder
implements View.OnClickListener,
View.OnLongClickListener,
View.OnTouchListener,
ItemTouchHelperCallback.ViewHolderCallback {
    protected final FlexibleAdapter mAdapter;
    private boolean mLongClickSkipped = false;
    private boolean alreadySelected = false;
    protected int mActionState = 0;

    public FlexibleViewHolder(View view, FlexibleAdapter adapter) {
        this(view, adapter, false);
    }

    public FlexibleViewHolder(View view, FlexibleAdapter adapter, boolean stickyHeader) {
        super(view, adapter, stickyHeader);
        this.mAdapter = adapter;
        if (this.mAdapter.mItemClickListener != null) {
            this.getContentView().setOnClickListener((View.OnClickListener)this);
        }
        if (this.mAdapter.mItemLongClickListener != null) {
            this.getContentView().setOnLongClickListener((View.OnLongClickListener)this);
        }
    }

    @CallSuper
    public void onClick(View view) {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isEnabled(position)) {
            return;
        }
        if (this.mAdapter.mItemClickListener != null && this.mActionState == 0) {
            Log.v("onClick on position %s mode=%s", position, LayoutUtils.getModeName(this.mAdapter.getMode()));
            if (this.mAdapter.mItemClickListener.onItemClick(view, position)) {
                this.toggleActivation();
            }
        }
    }

    @CallSuper
    public boolean onLongClick(View view) {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isEnabled(position)) {
            return false;
        }
        if (this.mAdapter.mItemLongClickListener != null && !this.mAdapter.isLongPressDragEnabled()) {
            Log.v("onLongClick on position %s mode=%s", position, LayoutUtils.getModeName(this.mAdapter.getMode()));
            this.mAdapter.mItemLongClickListener.onItemLongClick(position);
            this.toggleActivation();
            return true;
        }
        this.mLongClickSkipped = true;
        return false;
    }

    public boolean onTouch(View view, MotionEvent event) {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isEnabled(position) || !this.isDraggable()) {
            Log.w("Can't start drag: Item is not enabled or draggable!", new Object[0]);
            return false;
        }
        Log.v("onTouch with DragHandleView on position %s mode=%s", position, LayoutUtils.getModeName(this.mAdapter.getMode()));
        if (event.getActionMasked() == 0 && this.mAdapter.isHandleDragEnabled()) {
            this.mAdapter.getItemTouchHelper().startDrag((RecyclerView.ViewHolder)this);
        }
        return false;
    }

    public void setFullSpan(boolean enabled) {
        if (this.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            ((StaggeredGridLayoutManager.LayoutParams)this.itemView.getLayoutParams()).setFullSpan(enabled);
        }
    }

    @CallSuper
    protected void setDragHandleView(@NonNull View view) {
        if (view != null) {
            view.setOnTouchListener((View.OnTouchListener)this);
        }
    }

    @CallSuper
    public void toggleActivation() {
        int position = this.getFlexibleAdapterPosition();
        if (!this.mAdapter.isSelectable(position)) {
            return;
        }
        boolean selected = this.mAdapter.isSelected(position);
        if (this.getContentView().isActivated() && !selected || !this.getContentView().isActivated() && selected) {
            this.getContentView().setActivated(selected);
            if (this.mAdapter.getStickyPosition() == position) {
                this.mAdapter.ensureHeaderParent();
            }
            if (this.getContentView().isActivated() && this.getActivationElevation() > 0.0f) {
                ViewCompat.setElevation((View)this.itemView, (float)this.getActivationElevation());
            } else if (this.getActivationElevation() > 0.0f) {
                ViewCompat.setElevation((View)this.itemView, (float)0.0f);
            }
        }
    }

    public float getActivationElevation() {
        return 0.0f;
    }

    protected boolean shouldActivateViewWhileSwiping() {
        return false;
    }

    protected boolean shouldAddSelectionInActionMode() {
        return false;
    }

    public void scrollAnimators(@NonNull List<Animator> animators, int position, boolean isForward) {
    }

    @Override
    @CallSuper
    public void onActionStateChanged(int position, int actionState) {
        this.mActionState = actionState;
        this.alreadySelected = this.mAdapter.isSelected(position);
        Log.v("onActionStateChanged position=%s mode=%s actionState=%s", position, LayoutUtils.getModeName(this.mAdapter.getMode()), actionState == 1 ? "Swipe(1)" : "Drag(2)");
        if (actionState == 2) {
            if (!this.alreadySelected) {
                if ((this.mLongClickSkipped || this.mAdapter.getMode() == 2) && (this.shouldAddSelectionInActionMode() || this.mAdapter.getMode() != 2) && this.mAdapter.mItemLongClickListener != null && this.mAdapter.isSelectable(position)) {
                    Log.v("onLongClick on position %s mode=%s", position, this.mAdapter.getMode());
                    this.mAdapter.mItemLongClickListener.onItemLongClick(position);
                    this.alreadySelected = true;
                }
                if (!this.alreadySelected) {
                    this.mAdapter.toggleSelection(position);
                }
            }
            if (!this.getContentView().isActivated()) {
                this.toggleActivation();
            }
        } else if (actionState == 1 && this.shouldActivateViewWhileSwiping() && !this.alreadySelected) {
            this.mAdapter.toggleSelection(position);
            this.toggleActivation();
        }
    }

    @Override
    @CallSuper
    public void onItemReleased(int position) {
        Log.v("onItemReleased position=%s mode=%s actionState=%s", position, LayoutUtils.getModeName(this.mAdapter.getMode()), this.mActionState == 1 ? "Swipe(1)" : "Drag(2)");
        if (!this.alreadySelected) {
            if (this.shouldAddSelectionInActionMode() && this.mAdapter.getMode() == 2) {
                Log.v("onLongClick for ActionMode on position %s mode=%s", position, this.mAdapter.getMode());
                if (this.mAdapter.mItemLongClickListener != null) {
                    this.mAdapter.mItemLongClickListener.onItemLongClick(position);
                }
                if (this.mAdapter.isSelected(position)) {
                    this.toggleActivation();
                }
            } else if (this.shouldActivateViewWhileSwiping() && this.getContentView().isActivated()) {
                this.mAdapter.toggleSelection(position);
                this.toggleActivation();
            } else if (this.mActionState == 2) {
                this.mAdapter.toggleSelection(position);
                if (this.getContentView().isActivated()) {
                    this.toggleActivation();
                }
            }
        }
        this.mLongClickSkipped = false;
        this.mActionState = 0;
    }

    @Override
    public final boolean isDraggable() {
        Object item = this.mAdapter.getItem(this.getFlexibleAdapterPosition());
        return item != null && item.isDraggable();
    }

    @Override
    public final boolean isSwipeable() {
        Object item = this.mAdapter.getItem(this.getFlexibleAdapterPosition());
        return item != null && item.isSwipeable();
    }

    @Override
    public View getFrontView() {
        return this.itemView;
    }

    @Override
    public View getRearLeftView() {
        return null;
    }

    @Override
    public View getRearRightView() {
        return null;
    }
}

