/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import eu.davidea.fastscroller.FastScroller;
import eu.davidea.flexibleadapter.Payload;
import eu.davidea.flexibleadapter.common.FlexibleLayoutManager;
import eu.davidea.flexibleadapter.common.IFlexibleLayoutManager;
import eu.davidea.flexibleadapter.utils.LayoutUtils;
import eu.davidea.flexibleadapter.utils.Log;
import eu.davidea.flexibleadapter.utils.Logger;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class SelectableAdapter
extends RecyclerView.Adapter
implements FastScroller.BubbleTextCreator,
FastScroller.OnScrollStateChangeListener,
FastScroller.AdapterInterface {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    Logger log;
    private final Set<Integer> mSelectedPositions;
    private final Set<FlexibleViewHolder> mBoundViewHolders;
    private int mMode;
    private IFlexibleLayoutManager mFlexibleLayoutManager;
    protected RecyclerView mRecyclerView;
    protected FastScroller.Delegate mFastScrollerDelegate;
    protected boolean isFastScroll = false;
    protected boolean mSelectAll = false;
    protected boolean mLastItemInActionMode = false;

    public SelectableAdapter() {
        if (Log.customTag == null) {
            Log.useTag("FlexibleAdapter");
        }
        this.log = new Logger(Log.customTag);
        this.log.i("Running version %s", "5.0.0");
        this.mSelectedPositions = Collections.synchronizedSet(new TreeSet());
        this.mBoundViewHolders = new HashSet<FlexibleViewHolder>();
        this.mMode = 0;
        this.mFastScrollerDelegate = new FastScroller.Delegate();
    }

    public static void enableLogs(int level) {
        Log.setLevel(level);
    }

    public static void useTag(String tag) {
        Log.useTag(tag);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.mFastScrollerDelegate != null) {
            this.mFastScrollerDelegate.onAttachedToRecyclerView(recyclerView);
        }
        this.mRecyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (this.mFastScrollerDelegate != null) {
            this.mFastScrollerDelegate.onDetachedFromRecyclerView(recyclerView);
        }
        this.mRecyclerView = null;
        this.mFlexibleLayoutManager = null;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public IFlexibleLayoutManager getFlexibleLayoutManager() {
        if (this.mFlexibleLayoutManager == null) {
            RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
            if (layoutManager instanceof IFlexibleLayoutManager) {
                this.mFlexibleLayoutManager = (IFlexibleLayoutManager)layoutManager;
            } else if (layoutManager != null) {
                this.mFlexibleLayoutManager = new FlexibleLayoutManager(this.mRecyclerView);
            }
        }
        return this.mFlexibleLayoutManager;
    }

    public void setFlexibleLayoutManager(IFlexibleLayoutManager flexibleLayoutManager) {
        this.mFlexibleLayoutManager = flexibleLayoutManager;
    }

    public void setMode(int mode) {
        this.log.i("Mode %s enabled", LayoutUtils.getModeName(mode));
        if (this.mMode == 1 && mode == 0) {
            this.clearSelection();
        }
        this.mMode = mode;
        this.mLastItemInActionMode = mode != 2;
    }

    public int getMode() {
        return this.mMode;
    }

    public boolean isSelectAll() {
        this.resetActionModeFlags();
        return this.mSelectAll;
    }

    public boolean isLastItemInActionMode() {
        this.resetActionModeFlags();
        return this.mLastItemInActionMode;
    }

    private void resetActionModeFlags() {
        if (this.mSelectAll || this.mLastItemInActionMode) {
            this.mRecyclerView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SelectableAdapter.this.mSelectAll = false;
                    SelectableAdapter.this.mLastItemInActionMode = false;
                }
            }, 200L);
        }
    }

    public boolean isSelected(int position) {
        return this.mSelectedPositions.contains(position);
    }

    public abstract boolean isSelectable(int var1);

    public void toggleSelection(int position) {
        boolean contains;
        if (position < 0) {
            return;
        }
        if (this.mMode == 1) {
            this.clearSelection();
        }
        if (contains = this.mSelectedPositions.contains(position)) {
            this.removeSelection(position);
        } else {
            this.addSelection(position);
        }
        this.log.v("toggleSelection %s on position %s, current %s", contains ? "removed" : "added", position, this.mSelectedPositions);
    }

    public final boolean addSelection(int position) {
        return this.isSelectable(position) && this.mSelectedPositions.add(position);
    }

    final boolean addAdjustedSelection(int position) {
        return this.mSelectedPositions.add(position);
    }

    public final boolean removeSelection(int position) {
        return this.mSelectedPositions.remove(position);
    }

    protected void swapSelection(int fromPosition, int toPosition) {
        if (this.isSelected(fromPosition) && !this.isSelected(toPosition)) {
            this.removeSelection(fromPosition);
            this.addSelection(toPosition);
        } else if (!this.isSelected(fromPosition) && this.isSelected(toPosition)) {
            this.removeSelection(toPosition);
            this.addSelection(fromPosition);
        }
    }

    public void selectAll(Integer ... viewTypes) {
        this.mSelectAll = true;
        List<Integer> viewTypesToSelect = Arrays.asList(viewTypes);
        this.log.v("selectAll ViewTypes to include %s", viewTypesToSelect);
        int positionStart = 0;
        int itemCount = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.isSelectable(i) && (viewTypesToSelect.isEmpty() || viewTypesToSelect.contains(this.getItemViewType(i)))) {
                this.mSelectedPositions.add(i);
                ++itemCount;
                continue;
            }
            if (positionStart + itemCount != i) continue;
            this.notifySelectionChanged(positionStart, itemCount);
            itemCount = 0;
            positionStart = i;
        }
        this.log.d("selectAll notifyItemRangeChanged from positionStart=%s itemCount=%s", positionStart, this.getItemCount());
        this.notifySelectionChanged(positionStart, this.getItemCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        Set<Integer> set = this.mSelectedPositions;
        synchronized (set) {
            this.log.d("clearSelection %s", this.mSelectedPositions);
            Iterator<Integer> iterator = this.mSelectedPositions.iterator();
            int positionStart = 0;
            int itemCount = 0;
            while (iterator.hasNext()) {
                int position = iterator.next();
                iterator.remove();
                if (positionStart + itemCount == position) {
                    ++itemCount;
                    continue;
                }
                this.notifySelectionChanged(positionStart, itemCount);
                positionStart = position;
                itemCount = 1;
            }
            this.notifySelectionChanged(positionStart, itemCount);
        }
    }

    private void notifySelectionChanged(int positionStart, int itemCount) {
        if (itemCount > 0) {
            for (FlexibleViewHolder flexHolder : this.mBoundViewHolders) {
                flexHolder.toggleActivation();
            }
            if (this.mBoundViewHolders.isEmpty()) {
                this.notifyItemRangeChanged(positionStart, itemCount, (Object)Payload.SELECTION);
            }
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List payloads) {
        if (holder instanceof FlexibleViewHolder) {
            FlexibleViewHolder flexHolder = (FlexibleViewHolder)holder;
            flexHolder.getContentView().setActivated(this.isSelected(position));
            if (flexHolder.getContentView().isActivated() && flexHolder.getActivationElevation() > 0.0f) {
                ViewCompat.setElevation((View)flexHolder.getContentView(), (float)flexHolder.getActivationElevation());
            } else if (flexHolder.getActivationElevation() > 0.0f) {
                ViewCompat.setElevation((View)flexHolder.getContentView(), (float)0.0f);
            }
            this.mBoundViewHolders.add(flexHolder);
        } else {
            holder.itemView.setActivated(this.isSelected(position));
        }
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        if (holder instanceof FlexibleViewHolder) {
            this.mBoundViewHolders.remove(holder);
        }
    }

    public Set<FlexibleViewHolder> getAllBoundViewHolders() {
        return Collections.unmodifiableSet(this.mBoundViewHolders);
    }

    public int getSelectedItemCount() {
        return this.mSelectedPositions.size();
    }

    public List<Integer> getSelectedPositions() {
        return new ArrayList<Integer>(this.mSelectedPositions);
    }

    public Set<Integer> getSelectedPositionsAsSet() {
        return this.mSelectedPositions;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putIntegerArrayList(TAG, new ArrayList<Integer>(this.mSelectedPositions));
        if (this.getSelectedItemCount() > 0) {
            this.log.d("Saving selection %s", this.mSelectedPositions);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        this.mSelectedPositions.addAll(savedInstanceState.getIntegerArrayList(TAG));
        if (this.getSelectedItemCount() > 0) {
            this.log.d("Restore selection %s", this.mSelectedPositions);
        }
    }

    public void toggleFastScroller() {
        this.mFastScrollerDelegate.toggleFastScroller();
    }

    public boolean isFastScrollerEnabled() {
        return this.mFastScrollerDelegate.isFastScrollerEnabled();
    }

    @Nullable
    public FastScroller getFastScroller() {
        return this.mFastScrollerDelegate.getFastScroller();
    }

    @Override
    public void setFastScroller(@Nullable FastScroller fastScroller) {
        this.mFastScrollerDelegate.setFastScroller(fastScroller);
    }

    @Override
    public String onCreateBubbleText(int position) {
        return String.valueOf(position + 1);
    }

    @Override
    public void onFastScrollerStateChange(boolean scrolling) {
        this.isFastScroll = scrolling;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @SuppressLint(value={"UniqueConstants"})
    public static @interface Mode {
        public static final int IDLE = 0;
        public static final int SINGLE = 1;
        public static final int MULTI = 2;
    }
}

