/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.items;

import eu.davidea.flexibleadapter.items.AbstractFlexibleItem;
import eu.davidea.flexibleadapter.items.IExpandable;
import eu.davidea.flexibleadapter.items.IFlexible;
import eu.davidea.viewholders.ExpandableViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExpandableItem<VH extends ExpandableViewHolder, S extends IFlexible>
extends AbstractFlexibleItem<VH>
implements IExpandable<VH, S> {
    protected boolean mExpanded = false;
    protected List<S> mSubItems;

    @Override
    public boolean isExpanded() {
        return this.mExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
    }

    @Override
    public int getExpansionLevel() {
        return 0;
    }

    @Override
    public final List<S> getSubItems() {
        return this.mSubItems;
    }

    public final boolean hasSubItems() {
        return this.mSubItems != null && this.mSubItems.size() > 0;
    }

    public IFlexible setSubItems(List<S> subItem) {
        this.mSubItems = subItem;
        return this;
    }

    public final int getSubItemsCount() {
        return this.mSubItems != null ? this.mSubItems.size() : 0;
    }

    public S getSubItem(int position) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            return (S)((IFlexible)this.mSubItems.get(position));
        }
        return null;
    }

    public final int getSubItemPosition(S subItem) {
        return this.mSubItems != null ? this.mSubItems.indexOf(subItem) : -1;
    }

    public void addSubItem(S subItem) {
        if (this.mSubItems == null) {
            this.mSubItems = new ArrayList<S>();
        }
        this.mSubItems.add(subItem);
    }

    public void addSubItem(int position, S subItem) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            this.mSubItems.add(position, subItem);
        } else {
            this.addSubItem(subItem);
        }
    }

    public boolean contains(S subItem) {
        return this.mSubItems != null && this.mSubItems.contains(subItem);
    }

    public boolean removeSubItem(S item) {
        return item != null && this.mSubItems.remove(item);
    }

    public boolean removeSubItem(int position) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            this.mSubItems.remove(position);
            return true;
        }
        return false;
    }
}

