/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import eu.davidea.fastscroller.FastScroller;
import eu.davidea.flexibleadapter.R;
import eu.davidea.flexibleadapter.utils.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class SelectableAdapter
extends RecyclerView.Adapter
implements FastScroller.BubbleTextCreator,
FastScroller.OnScrollStateChangeListener {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    public static boolean DEBUG = false;
    public static final int MODE_IDLE = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_MULTI = 2;
    private Set<Integer> mSelectedPositions = new TreeSet<Integer>();
    private int mMode = 0;
    protected RecyclerView mRecyclerView;
    protected FastScroller mFastScroller;
    protected boolean mSelectAll = false;
    protected boolean mLastItemInActionMode = false;

    public static void enableLogs(boolean enable) {
        DEBUG = enable;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRecyclerView = null;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public static int getSpanCount(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return 1;
    }

    public void setMode(int mode) {
        if (this.mMode == 1 && mode == 0) {
            this.clearSelection();
        }
        this.mMode = mode;
        this.mLastItemInActionMode = mode == 0;
    }

    public int getMode() {
        return this.mMode;
    }

    public boolean isSelectAll() {
        return this.mSelectAll;
    }

    public boolean isLastItemInActionMode() {
        return this.mLastItemInActionMode;
    }

    public void resetActionModeFlags() {
        this.mSelectAll = false;
        this.mLastItemInActionMode = false;
    }

    public boolean isSelected(int position) {
        return this.mSelectedPositions.contains(position);
    }

    public abstract boolean isSelectable(int var1);

    public void toggleSelection(int position) {
        boolean contains;
        if (position < 0) {
            return;
        }
        if (this.mMode == 1) {
            this.clearSelection();
        }
        if (contains = this.mSelectedPositions.contains(position)) {
            this.removeSelection(position);
        } else {
            this.addSelection(position);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("toggleSelection " + (contains ? "removed" : "added") + " on position " + position + ", current " + this.mSelectedPositions));
        }
    }

    public boolean addSelection(int position) {
        return this.isSelectable(position) && this.mSelectedPositions.add(position);
    }

    public boolean removeSelection(int position) {
        return this.mSelectedPositions.remove(position);
    }

    public void selectAll(Integer ... viewTypes) {
        this.mSelectAll = true;
        List<Integer> viewTypesToSelect = Arrays.asList(viewTypes);
        if (DEBUG) {
            Log.v((String)TAG, (String)("selectAll ViewTypes to include " + viewTypesToSelect));
        }
        int positionStart = 0;
        int itemCount = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.isSelectable(i) && (viewTypesToSelect.isEmpty() || viewTypesToSelect.contains(this.getItemViewType(i)))) {
                this.mSelectedPositions.add(i);
                ++itemCount;
                continue;
            }
            if (positionStart + itemCount != i) continue;
            this.notifySelectionChanged(positionStart, itemCount);
            itemCount = 0;
            positionStart = i;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("selectAll notifyItemRangeChanged from positionStart=" + positionStart + " itemCount=" + this.getItemCount()));
        }
        this.notifySelectionChanged(positionStart, this.getItemCount());
    }

    public void clearSelection() {
        if (DEBUG) {
            Log.v((String)TAG, (String)("clearSelection " + this.mSelectedPositions));
        }
        Iterator<Integer> iterator = this.mSelectedPositions.iterator();
        int positionStart = 0;
        int itemCount = 0;
        while (iterator.hasNext()) {
            int position = iterator.next();
            iterator.remove();
            if (positionStart + itemCount == position) {
                ++itemCount;
                continue;
            }
            this.notifySelectionChanged(positionStart, itemCount);
            positionStart = position;
            itemCount = 1;
        }
        this.notifySelectionChanged(positionStart, itemCount);
    }

    private void notifySelectionChanged(int positionStart, int itemCount) {
        if (itemCount > 0) {
            this.notifyItemRangeChanged(positionStart, itemCount);
        }
    }

    public int getSelectedItemCount() {
        return this.mSelectedPositions.size();
    }

    public List<Integer> getSelectedPositions() {
        return new ArrayList<Integer>(this.mSelectedPositions);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putIntegerArrayList(TAG, new ArrayList<Integer>(this.mSelectedPositions));
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        this.mSelectedPositions.addAll(savedInstanceState.getIntegerArrayList(TAG));
        Log.d((String)TAG, (String)("restore selection " + this.mSelectedPositions));
    }

    public void toggleFastScroller() {
        if (this.mFastScroller != null) {
            if (this.mFastScroller.getVisibility() != 0) {
                this.mFastScroller.setVisibility(0);
            } else {
                this.mFastScroller.setVisibility(8);
            }
        }
    }

    public boolean isFastScrollerEnabled() {
        return this.mFastScroller != null && this.mFastScroller.getVisibility() == 0;
    }

    public FastScroller getFastScroller() {
        return this.mFastScroller;
    }

    public void setFastScroller(@NonNull FastScroller fastScroller, int accentColor) {
        this.setFastScroller(fastScroller, accentColor, null);
    }

    public void setFastScroller(@NonNull FastScroller fastScroller, int accentColor, FastScroller.OnScrollStateChangeListener stateChangeListener) {
        if (this.mRecyclerView == null) {
            throw new IllegalStateException("RecyclerView cannot be null. Setup FastScroller after the Adapter has been added to the RecyclerView.");
        }
        if (fastScroller == null) {
            throw new IllegalArgumentException("FastScroller cannot be null. Review the widget ID of the FastScroller.");
        }
        this.mFastScroller = fastScroller;
        this.mFastScroller.setRecyclerView(this.mRecyclerView);
        this.mFastScroller.addOnScrollStateChangeListener(stateChangeListener);
        accentColor = Utils.fetchAccentColor(fastScroller.getContext(), accentColor);
        this.mFastScroller.setViewsToUse(R.layout.library_fast_scroller_layout, R.id.fast_scroller_bubble, R.id.fast_scroller_handle, accentColor);
    }

    @Override
    public String onCreateBubbleText(int position) {
        return String.valueOf(position + 1);
    }

    @Override
    public void onFastScrollerStateChange(boolean scrolling) {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

