/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.AnimatorAdapter;
import eu.davidea.flexibleadapter.R;
import eu.davidea.flexibleadapter.SelectableAdapter;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.flexibleadapter.helpers.StickyHeaderHelper;
import eu.davidea.flexibleadapter.items.IExpandable;
import eu.davidea.flexibleadapter.items.IFilterable;
import eu.davidea.flexibleadapter.items.IFlexible;
import eu.davidea.flexibleadapter.items.IHeader;
import eu.davidea.flexibleadapter.items.ISectionable;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FlexibleAdapter<T extends IFlexible>
extends AnimatorAdapter
implements ItemTouchHelperCallback.AdapterCallback {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    private static final String EXTRA_PARENT = TAG + "_parentSelected";
    private static final String EXTRA_CHILD = TAG + "_childSelected";
    private static final String EXTRA_HEADERS = TAG + "_headersShown";
    private static final String EXTRA_LEVEL = TAG + "_selectedLevel";
    private static final String EXTRA_SEARCH = TAG + "_searchText";
    public static final int EXPANDABLE_VIEW_TYPE = -1;
    public static final int SECTION_VIEW_TYPE = -2;
    public static final long UNDO_TIMEOUT = 5000L;
    private List<T> mItems;
    private List<IHeader> mOrphanHeaders;
    private boolean headersShown = false;
    private boolean headersSticky = false;
    private boolean recursive = false;
    private StickyHeaderHelper mStickyHeaderHelper;
    protected Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    FlexibleAdapter.this.filterItems((List)message.obj);
                    return true;
                }
                case 1: {
                    OnDeleteCompleteListener listener = (OnDeleteCompleteListener)message.obj;
                    if (listener != null) {
                        listener.onDeleteConfirmed();
                    }
                    FlexibleAdapter.this.emptyBin();
                    return true;
                }
                case 2: {
                    FlexibleAdapter.this.resetOnLoadMore();
                    return true;
                }
            }
            return false;
        }
    });
    private List<RestoreInfo> mRestoreList;
    private boolean restoreSelection = false;
    private boolean multiRange = false;
    private boolean unlinkOnRemoveHeader = false;
    private boolean removeOrphanHeaders = false;
    private boolean permanentDelete = false;
    private boolean adjustSelected = true;
    protected LayoutInflater mInflater;
    @SuppressLint(value={"UseSparseArrays"})
    private HashMap<Integer, T> mTypeInstances = new HashMap();
    private boolean autoMap = false;
    private String mSearchText = "";
    private String mOldSearchText = "";
    private List<IExpandable> mExpandedFilterFlags;
    private boolean mNotifyChangeOfUnfilteredItems = false;
    private boolean filtering = false;
    private int minCollapsibleLevel = 0;
    private int selectedLevel = -1;
    private boolean scrollOnExpand = false;
    private boolean collapseOnExpand = false;
    private boolean childSelected = false;
    private boolean parentSelected = false;
    private boolean handleDragEnabled = false;
    private ItemTouchHelperCallback mItemTouchHelperCallback;
    private ItemTouchHelper mItemTouchHelper;
    private int mEndlessScrollThreshold = 1;
    private boolean mLoading = false;
    private T mProgressItem;
    protected OnUpdateListener mUpdateListener;
    public OnItemClickListener mItemClickListener;
    public OnItemLongClickListener mItemLongClickListener;
    protected OnItemMoveListener mItemMoveListener;
    protected OnItemSwipeListener mItemSwipeListener;
    protected OnStickyHeaderChangeListener mStickyHeaderChangeListener;
    protected EndlessScrollListener mEndlessScrollListener;

    public FlexibleAdapter(@NonNull List<T> items) {
        this(items, null);
    }

    public FlexibleAdapter(@NonNull List<T> items, @Nullable Object listeners) {
        this.mItems = Collections.synchronizedList(items);
        this.mRestoreList = new ArrayList<RestoreInfo>();
        this.mOrphanHeaders = new ArrayList<IHeader>();
        this.initializeListeners(listeners);
        this.registerAdapterDataObserver(new AdapterDataObserver());
    }

    public FlexibleAdapter initializeListeners(@Nullable Object listeners) {
        if (listeners instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listeners;
            this.mUpdateListener.onUpdateEmptyView(this.mItems.size());
        }
        if (listeners instanceof OnItemClickListener) {
            this.mItemClickListener = (OnItemClickListener)listeners;
        }
        if (listeners instanceof OnItemLongClickListener) {
            this.mItemLongClickListener = (OnItemLongClickListener)listeners;
        }
        if (listeners instanceof OnItemMoveListener) {
            this.mItemMoveListener = (OnItemMoveListener)listeners;
        }
        if (listeners instanceof OnItemSwipeListener) {
            this.mItemSwipeListener = (OnItemSwipeListener)listeners;
        }
        if (listeners instanceof OnStickyHeaderChangeListener) {
            this.mStickyHeaderChangeListener = (OnStickyHeaderChangeListener)listeners;
        }
        return this;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.mStickyHeaderHelper != null && this.headersShown) {
            this.mStickyHeaderHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    @Override
    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mStickyHeaderHelper != null) {
            this.mStickyHeaderHelper.detachFromRecyclerView(this.mRecyclerView);
            this.mStickyHeaderHelper = null;
        }
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public FlexibleAdapter expandItemsAtStartUp() {
        this.setInitialize(true);
        this.multiRange = true;
        for (int position = 0; position < this.mItems.size(); ++position) {
            T item = this.getItem(position);
            if (!this.isExpanded(item)) continue;
            position += this.expand(position, false, true);
            if (this.headersShown || !this.isHeader(item) || item.isHidden()) continue;
            this.headersShown = true;
        }
        this.multiRange = false;
        this.setInitialize(false);
        return this;
    }

    public boolean isEnabled(int position) {
        T item = this.getItem(position);
        return item != null && item.isEnabled();
    }

    @Override
    public boolean isSelectable(int position) {
        T item = this.getItem(position);
        return item != null && item.isSelectable();
    }

    @Override
    public void toggleSelection(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (item != null && item.isSelectable()) {
            boolean hasParent;
            IExpandable parent = this.getExpandableOf(item);
            boolean bl = hasParent = parent != null;
            if (!(!this.isExpandable(item) && hasParent || this.childSelected)) {
                this.parentSelected = true;
                if (hasParent) {
                    this.selectedLevel = parent.getExpansionLevel();
                }
                super.toggleSelection(position);
            } else if (!this.parentSelected && hasParent && parent.getExpansionLevel() + 1 == this.selectedLevel || this.selectedLevel == -1) {
                this.childSelected = true;
                this.selectedLevel = parent.getExpansionLevel() + 1;
                super.toggleSelection(position);
            }
        }
        if (this.getSelectedItemCount() == 0) {
            this.selectedLevel = -1;
            this.childSelected = false;
            this.parentSelected = false;
        }
    }

    @Override
    public void selectAll(Integer ... viewTypes) {
        if (this.getSelectedItemCount() > 0 && viewTypes.length == 0) {
            super.selectAll(this.getItemViewType(this.getSelectedPositions().get(0)));
        } else {
            super.selectAll(viewTypes);
        }
    }

    @Override
    @CallSuper
    public void clearSelection() {
        this.childSelected = false;
        this.parentSelected = false;
        super.clearSelection();
    }

    public boolean isAnyParentSelected() {
        return this.parentSelected;
    }

    public boolean isAnyChildSelected() {
        return this.childSelected;
    }

    @CallSuper
    public void updateDataSet(List<T> items) {
        this.updateDataSet(items, false);
    }

    @CallSuper
    public void updateDataSet(@Nullable List<T> items, boolean animate) {
        if (animate) {
            this.animateTo(items);
        } else {
            this.mItems = items == null ? new ArrayList<T>() : new ArrayList<T>(items);
            this.notifyDataSetChanged();
        }
        if (this.mUpdateListener != null && this.getItemCount() == 0) {
            this.mUpdateListener.onUpdateEmptyView(0);
        } else {
            this.expandItemsAtStartUp();
            if (this.headersShown) {
                this.showAllHeaders();
            }
        }
    }

    public final T getItem(@IntRange(from=0L) int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return (T)((IFlexible)this.mItems.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public final int getItemCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    public int getItemCountOfTypes(Integer ... viewTypes) {
        return this.getItemCountOfTypesUntil(this.getItemCount(), viewTypes);
    }

    public int getItemCountOfTypesUntil(@IntRange(from=0L) int position, Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        int count = 0;
        for (int i = 0; i < position; ++i) {
            if ((!this.autoMap || !viewTypeList.contains(((IFlexible)this.mItems.get(i)).getLayoutRes())) && !viewTypeList.contains(this.getItemViewType(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public int getGlobalPositionOf(@NonNull IFlexible item) {
        return item != null && this.mItems != null && !this.mItems.isEmpty() ? this.mItems.indexOf(item) : -1;
    }

    public boolean contains(@NonNull T item) {
        return item != null && this.mItems != null && this.mItems.contains(item);
    }

    public int calculatePositionFor(@NonNull Object item, @Nullable Comparator comparator) {
        Object header;
        if (comparator == null) {
            return 0;
        }
        if (item instanceof ISectionable && (header = ((ISectionable)item).getHeader()) != null && !header.isHidden()) {
            List<ISectionable> sortedList = this.getSectionItems((IHeader)header);
            sortedList.add((ISectionable)item);
            Collections.sort(sortedList, comparator);
            int fix = this.mItems.indexOf(item) < this.getGlobalPositionOf((IFlexible)header) ? 0 : 1;
            int result = this.getGlobalPositionOf((IFlexible)header) + sortedList.indexOf(item) + fix;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Calculated finalPosition=" + result + " sectionPosition=" + this.getGlobalPositionOf((IFlexible)header) + " relativePosition=" + sortedList.indexOf(item) + " fix=" + fix));
            }
            return result;
        }
        ArrayList<T> sortedList = new ArrayList<T>(this.mItems);
        if (!sortedList.contains(item)) {
            sortedList.add(item);
        }
        Collections.sort(sortedList, comparator);
        if (DEBUG) {
            Log.v((String)TAG, (String)("Calculated position " + Math.max(0, sortedList.indexOf(item)) + " for item=" + item));
        }
        return Math.max(0, sortedList.indexOf(item));
    }

    public boolean areHeadersShown() {
        return this.headersShown;
    }

    public FlexibleAdapter setDisplayHeadersAtStartUp(boolean displayHeaders) {
        this.setInitialize(true);
        this.headersShown = displayHeaders;
        if (displayHeaders) {
            this.showAllHeaders();
        }
        this.setInitialize(false);
        return this;
    }

    public boolean isRemoveOrphanHeaders() {
        return this.removeOrphanHeaders;
    }

    public FlexibleAdapter setRemoveOrphanHeaders(boolean removeOrphanHeaders) {
        this.removeOrphanHeaders = removeOrphanHeaders;
        return this;
    }

    public FlexibleAdapter setUnlinkAllItemsOnRemoveHeaders(boolean unlinkOnRemoveHeader) {
        this.unlinkOnRemoveHeader = unlinkOnRemoveHeader;
        return this;
    }

    @NonNull
    public List<IHeader> getOrphanHeaders() {
        return this.mOrphanHeaders;
    }

    public FlexibleAdapter linkHeaderTo(@NonNull T item, @NonNull IHeader header) {
        this.linkHeaderTo(item, header, null);
        if (header.isHidden() && this.headersShown) {
            this.showHeaderOf(this.getGlobalPositionOf((IFlexible)item), item);
        }
        return this;
    }

    public IHeader unlinkHeaderFrom(@NonNull T item) {
        IHeader header = this.unlinkHeaderFrom(item, null);
        if (header != null && !header.isHidden()) {
            this.hideHeaderOf(item);
        }
        return header;
    }

    @NonNull
    public List<IHeader> getHeaderItems() {
        ArrayList<IHeader> headers = new ArrayList<IHeader>();
        for (IFlexible item : this.mItems) {
            if (!this.isHeader(item)) continue;
            headers.add((IHeader)item);
        }
        return headers;
    }

    public boolean isHeader(T item) {
        return item != null && item instanceof IHeader;
    }

    public boolean areHeadersSticky() {
        return this.headersSticky;
    }

    public FlexibleAdapter enableStickyHeaders() {
        return this.setStickyHeaders(true);
    }

    public void disableStickyHeaders() {
        this.setStickyHeaders(false);
    }

    private FlexibleAdapter setStickyHeaders(boolean headersSticky) {
        if (this.headersShown && headersSticky) {
            this.headersSticky = true;
            if (this.mStickyHeaderHelper == null) {
                this.mStickyHeaderHelper = new StickyHeaderHelper(this, this.mStickyHeaderChangeListener);
            }
            if (!this.mStickyHeaderHelper.isAttachedToRecyclerView()) {
                this.mStickyHeaderHelper.attachToRecyclerView(this.mRecyclerView);
            }
        } else if (this.mStickyHeaderHelper != null) {
            this.headersSticky = false;
            this.mStickyHeaderHelper.detachFromRecyclerView(this.mRecyclerView);
            this.mStickyHeaderHelper = null;
        }
        return this;
    }

    public ViewGroup getStickySectionHeadersHolder() {
        return (ViewGroup)((Activity)this.mRecyclerView.getContext()).findViewById(R.id.sticky_header_container);
    }

    public boolean hasHeader(@NonNull T item) {
        return this.getHeaderOf(item) != null;
    }

    public boolean hasSameHeader(@NonNull T item, @NonNull IHeader header) {
        IHeader current = this.getHeaderOf(item);
        return current != null && header != null && current.equals(header);
    }

    public IHeader getHeaderOf(@NonNull T item) {
        if (item != null && item instanceof ISectionable) {
            return ((ISectionable)item).getHeader();
        }
        return null;
    }

    public IHeader getSectionHeader(@IntRange(from=0L) int position) {
        if (!this.headersShown) {
            return null;
        }
        for (int i = position; i >= 0; --i) {
            T item = this.getItem(i);
            if (!this.isHeader(item)) continue;
            return (IHeader)item;
        }
        return null;
    }

    public int getSectionIndex(@NonNull IHeader header) {
        int position = this.getGlobalPositionOf(header);
        return this.getSectionIndex(position);
    }

    public int getSectionIndex(@IntRange(from=0L) int position) {
        int sectionIndex = 0;
        for (int i = 0; i <= position; ++i) {
            if (!this.isHeader(this.getItem(i))) continue;
            ++sectionIndex;
        }
        return sectionIndex;
    }

    @NonNull
    public List<ISectionable> getSectionItems(@NonNull IHeader header) {
        ArrayList<ISectionable> sectionItems = new ArrayList<ISectionable>();
        int startPosition = this.getGlobalPositionOf(header);
        T item = this.getItem(++startPosition);
        while (this.hasSameHeader(item, header)) {
            sectionItems.add((ISectionable)item);
            item = this.getItem(++startPosition);
        }
        return sectionItems;
    }

    public void showAllHeaders() {
        this.multiRange = true;
        this.resetHiddenStatus();
        for (int position = 0; position < this.mItems.size(); ++position) {
            if (!this.showHeaderOf(position, (IFlexible)this.mItems.get(position))) continue;
            ++position;
        }
        this.headersShown = true;
        this.multiRange = false;
    }

    public void hideAllHeaders() {
        this.multiRange = true;
        for (IHeader header : this.getOrphanHeaders()) {
            this.hideHeader(this.getGlobalPositionOf(header), header);
        }
        for (int position = this.mItems.size() - 1; position >= 0; --position) {
            if (!this.hideHeaderOf((IFlexible)this.mItems.get(position))) continue;
            --position;
        }
        this.headersShown = false;
        this.setStickyHeaders(false);
        this.multiRange = false;
    }

    private void resetHiddenStatus() {
        for (IFlexible item : this.mItems) {
            IHeader header = this.getHeaderOf(item);
            if (header == null || this.isExpandable(header)) continue;
            header.setHidden(true);
        }
    }

    private boolean showHeaderOf(int position, @NonNull T item) {
        IHeader header = this.getHeaderOf(item);
        if (header == null || this.getPendingRemovedItem(item) != null) {
            return false;
        }
        if (header.isHidden()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Showing header at position " + position + " header=" + header));
            }
            header.setHidden(false);
            return this.addItem(position, header);
        }
        return false;
    }

    private boolean hideHeaderOf(@NonNull T item) {
        IHeader header = this.getHeaderOf(item);
        return header != null && !header.isHidden() && this.hideHeader(this.getGlobalPositionOf(header), header);
    }

    private boolean hideHeader(int position, IHeader header) {
        if (position >= 0) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Hiding header at position " + position + " header=" + header));
            }
            header.setHidden(true);
            this.mItems.remove(position);
            this.notifyItemRemoved(position);
            return true;
        }
        return false;
    }

    private boolean linkHeaderTo(@NonNull T item, @NonNull IHeader header, @Nullable Object payload) {
        boolean linked = false;
        if (item != null && item instanceof ISectionable) {
            ISectionable sectionable = (ISectionable)item;
            if (sectionable.getHeader() != null && !sectionable.getHeader().equals(header)) {
                this.unlinkHeaderFrom(sectionable, payload);
            }
            if (sectionable.getHeader() == null && header != null) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Link header " + header + " to " + sectionable));
                }
                sectionable.setHeader(header);
                linked = true;
                this.removeFromOrphanList(header);
                if (payload != null) {
                    if (!header.isHidden()) {
                        this.notifyItemChanged(this.getGlobalPositionOf(header), payload);
                    }
                    if (!item.isHidden()) {
                        this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)item), payload);
                    }
                }
            }
        } else {
            this.addToOrphanListIfNeeded(header, this.getGlobalPositionOf((IFlexible)item), 1);
            this.notifyItemChanged(this.getGlobalPositionOf(header), payload);
        }
        return linked;
    }

    private IHeader unlinkHeaderFrom(@NonNull T item, @Nullable Object payload) {
        if (this.hasHeader(item)) {
            ISectionable sectionable = (ISectionable)item;
            Object header = sectionable.getHeader();
            if (DEBUG) {
                Log.v((String)TAG, (String)("Unlink header " + header + " from " + sectionable));
            }
            sectionable.setHeader(null);
            this.addToOrphanListIfNeeded((IHeader)header, this.getGlobalPositionOf((IFlexible)item), 1);
            if (payload != null) {
                if (!header.isHidden()) {
                    this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)header), payload);
                }
                if (!item.isHidden()) {
                    this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)item), payload);
                }
            }
            return header;
        }
        return null;
    }

    private void addToOrphanListIfNeeded(IHeader header, int positionStart, int itemCount) {
        if (!this.mOrphanHeaders.contains(header) && !this.isHeaderShared(header, positionStart, itemCount)) {
            this.mOrphanHeaders.add(header);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Added to orphan list [" + this.mOrphanHeaders.size() + "] Header " + header));
            }
        }
    }

    private void removeFromOrphanList(IHeader header) {
        if (this.mOrphanHeaders.remove(header) && DEBUG) {
            Log.v((String)TAG, (String)("Removed from orphan list [" + this.mOrphanHeaders.size() + "] Header " + header));
        }
    }

    private boolean isHeaderShared(IHeader header, int positionStart, int itemCount) {
        int firstElementWithHeader;
        T item;
        for (int i = firstElementWithHeader = this.getGlobalPositionOf(header) + 1; i < this.mItems.size() && !((item = this.getItem(i)) instanceof IHeader); ++i) {
            if (i >= positionStart && i < positionStart + itemCount || !this.hasSameHeader(item, header)) continue;
            return true;
        }
        return false;
    }

    public int getItemViewType(int position) {
        T item = this.getItem(position);
        this.mapViewTypeFrom(item);
        this.autoMap = true;
        return item.getLayoutRes();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        T item;
        if (this.mInflater == null) {
            this.mInflater = LayoutInflater.from((Context)parent.getContext());
        }
        if ((item = this.getViewTypeInstance(viewType)) == null) {
            Log.wtf((String)TAG, (String)("ViewType instance has not been correctly mapped for viewType " + viewType));
            throw new IllegalStateException("ViewType instance has not been correctly mapped for viewType " + viewType);
        }
        return item.createViewHolder(this, this.mInflater, parent);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, Collections.unmodifiableList(new ArrayList()));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List payloads) {
        holder.itemView.setActivated(this.isSelected(position));
        if (holder instanceof FlexibleViewHolder) {
            FlexibleViewHolder flexHolder = (FlexibleViewHolder)holder;
            if (holder.itemView.isActivated() && flexHolder.getActivationElevation() > 0.0f) {
                ViewCompat.setElevation((View)flexHolder.itemView, (float)flexHolder.getActivationElevation());
            } else if (flexHolder.getActivationElevation() > 0.0f) {
                ViewCompat.setElevation((View)flexHolder.itemView, (float)0.0f);
            }
        }
        if (!this.autoMap) {
            super.onBindViewHolder(holder, position, payloads);
        } else {
            T item = this.getItem(position);
            if (item != null) {
                holder.itemView.setEnabled(item.isEnabled());
                item.bindViewHolder(this, (RecyclerView.ViewHolder)holder, position, payloads);
            }
        }
        this.onLoadMore(position);
    }

    public FlexibleAdapter setEndlessScrollListener(@NonNull EndlessScrollListener endlessScrollListener, @NonNull T progressItem) {
        if (endlessScrollListener != null && progressItem != null) {
            this.mEndlessScrollListener = endlessScrollListener;
            this.setEndlessScrollThreshold(this.mEndlessScrollThreshold);
            progressItem.setEnabled(false);
            this.mProgressItem = progressItem;
        }
        return this;
    }

    public FlexibleAdapter setEndlessScrollThreshold(@IntRange(from=1L) int thresholdItems) {
        if (this.mRecyclerView != null) {
            int spanCount = FlexibleAdapter.getSpanCount(this.mRecyclerView.getLayoutManager());
            thresholdItems *= spanCount;
        }
        this.mEndlessScrollThreshold = thresholdItems;
        return this;
    }

    private void onLoadMore(int position) {
        if (this.mEndlessScrollListener != null && this.getGlobalPositionOf((IFlexible)this.mProgressItem) < 0 && position >= this.getItemCount() - this.mEndlessScrollThreshold && !this.mLoading) {
            this.mLoading = true;
            this.mRecyclerView.post(new Runnable(){

                @Override
                public void run() {
                    FlexibleAdapter.this.mItems.add(FlexibleAdapter.this.mProgressItem);
                    FlexibleAdapter.this.notifyItemInserted(FlexibleAdapter.this.getItemCount());
                    FlexibleAdapter.this.mEndlessScrollListener.onLoadMore();
                }
            });
        }
    }

    public void onLoadMoreComplete(@Nullable List<T> newItems) {
        int progressPosition = this.getGlobalPositionOf((IFlexible)this.mProgressItem);
        if (progressPosition >= 0) {
            this.mItems.remove(this.mProgressItem);
            this.notifyItemRemoved(progressPosition);
        }
        if (newItems != null && newItems.size() > 0) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("onLoadMore performing adding " + newItems.size() + " new Items!"));
            }
            this.addItems(this.getItemCount(), newItems);
            this.mHandler.sendEmptyMessageDelayed(2, 200L);
        } else {
            this.noMoreLoad();
        }
    }

    private void noMoreLoad() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"onLoadMore noMoreLoad!");
        }
        this.notifyItemChanged(this.getItemCount() - 1, true);
        this.mHandler.sendEmptyMessageDelayed(2, 200L);
    }

    private void resetOnLoadMore() {
        this.mLoading = false;
    }

    public FlexibleAdapter setAutoCollapseOnExpand(boolean collapseOnExpand) {
        this.collapseOnExpand = collapseOnExpand;
        return this;
    }

    public FlexibleAdapter setAutoScrollOnExpand(boolean scrollOnExpand) {
        this.scrollOnExpand = scrollOnExpand;
        return this;
    }

    public boolean isExpanded(@IntRange(from=0L) int position) {
        return this.isExpanded(this.getItem(position));
    }

    public boolean isExpanded(@NonNull T item) {
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            return expandable.isExpanded();
        }
        return false;
    }

    public boolean isExpandable(@NonNull T item) {
        return item != null && item instanceof IExpandable;
    }

    public int getMinCollapsibleLevel() {
        return this.minCollapsibleLevel;
    }

    public FlexibleAdapter setMinCollapsibleLevel(int minCollapsibleLevel) {
        this.minCollapsibleLevel = minCollapsibleLevel;
        return this;
    }

    public boolean hasSubItems(@NonNull IExpandable expandable) {
        return expandable != null && expandable.getSubItems() != null && expandable.getSubItems().size() > 0;
    }

    public IExpandable getExpandableOf(@IntRange(from=0L) int position) {
        return this.getExpandableOf(this.getItem(position));
    }

    public IExpandable getExpandableOf(@NonNull T child) {
        for (IFlexible parent : this.mItems) {
            IExpandable expandable;
            if (!this.isExpandable(parent) || !(expandable = (IExpandable)parent).isExpanded() || !this.hasSubItems(expandable)) continue;
            List list = expandable.getSubItems();
            for (IFlexible subItem : list) {
                if (subItem.isHidden() || !subItem.equals(child)) continue;
                return expandable;
            }
        }
        return null;
    }

    public int getExpandablePositionOf(@NonNull T child) {
        return this.getGlobalPositionOf(this.getExpandableOf(child));
    }

    @NonNull
    public List<T> getSiblingsOf(@NonNull T child) {
        IExpandable expandable = this.getExpandableOf(child);
        return expandable != null ? expandable.getSubItems() : new ArrayList();
    }

    public int getRelativePositionOf(@NonNull T child) {
        return this.getSiblingsOf(child).indexOf(child);
    }

    @NonNull
    public List<T> getExpandedItems() {
        ArrayList<IFlexible> expandedItems = new ArrayList<IFlexible>();
        for (IFlexible item : this.mItems) {
            if (!this.isExpanded(item)) continue;
            expandedItems.add(item);
        }
        return expandedItems;
    }

    @NonNull
    public List<Integer> getExpandedPositions() {
        ArrayList<Integer> expandedPositions = new ArrayList<Integer>();
        for (int i = 0; i < this.mItems.size() - 1; ++i) {
            if (!this.isExpanded((IFlexible)this.mItems.get(i))) continue;
            expandedPositions.add(i);
        }
        return expandedPositions;
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, false, false);
    }

    public int expand(T item) {
        return this.expand(this.getGlobalPositionOf((IFlexible)item), false, false);
    }

    public int expand(T item, boolean init) {
        return this.expand(this.getGlobalPositionOf((IFlexible)item), false, init);
    }

    private int expand(int position, boolean expandAll, boolean init) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (!this.hasSubItems(expandable)) {
            expandable.setExpanded(false);
            if (DEBUG) {
                Log.w((String)TAG, (String)("No subItems to Expand on position " + position + " expanded " + expandable.isExpanded()));
            }
            return 0;
        }
        if (DEBUG && !init) {
            Log.v((String)TAG, (String)("Request to Expand on position=" + position + " expanded=" + expandable.isExpanded() + " anyParentSelected=" + this.parentSelected + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        if (init || !expandable.isExpanded() && (!this.parentSelected || expandable.getExpansionLevel() <= this.selectedLevel)) {
            if (this.collapseOnExpand && !expandAll && this.collapseAll(this.minCollapsibleLevel) > 0) {
                position = this.getGlobalPositionOf((IFlexible)item);
            }
            List<T> subItems = this.getExpandableList(expandable);
            this.mItems.addAll(position + 1, subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(true);
            if (!init && this.scrollOnExpand && !expandAll) {
                this.autoScrollWithDelay(position, subItemsCount, 150L);
            }
            this.notifyItemRangeInserted(position + 1, subItemsCount);
            if (!init && this.headersShown) {
                int count = 0;
                for (IFlexible subItem : subItems) {
                    if (!this.showHeaderOf(position + ++count, subItem)) continue;
                    ++count;
                }
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)((init ? "Initially expanded " : "Expanded ") + subItemsCount + " subItems on position=" + position + (init ? "" : " ExpandedItems=" + this.getExpandedPositions())));
            }
        }
        return subItemsCount;
    }

    public int expandAll() {
        return this.expandAll(this.minCollapsibleLevel);
    }

    public int expandAll(int level) {
        int expanded = 0;
        for (int i = 0; i < this.mItems.size(); ++i) {
            IExpandable expandable;
            T item = this.getItem(i);
            if (!this.isExpandable(item) || (expandable = (IExpandable)item).getExpansionLevel() > level || this.expand(i, true, false) <= 0) continue;
            ++expanded;
        }
        return expanded;
    }

    public int collapse(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (DEBUG) {
            Log.v((String)TAG, (String)("Request to Collapse on position=" + position + " expanded=" + expandable.isExpanded() + " hasSubItemsSelected=" + this.hasSubItemsSelected(expandable) + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        int recursiveCount = 0;
        if (expandable.isExpanded() && (!this.hasSubItemsSelected(expandable) || this.getPendingRemovedItem(item) != null)) {
            List<T> subItems = this.getExpandableList(expandable);
            recursiveCount = this.recursiveCollapse(subItems, expandable.getExpansionLevel());
            this.mItems.removeAll(subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(false);
            this.notifyItemRangeRemoved(position + 1, subItemsCount);
            if (this.headersShown && !this.isHeader(item)) {
                for (IFlexible subItem : subItems) {
                    this.hideHeaderOf(subItem);
                }
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Collapsed " + subItemsCount + " subItems on position " + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount + recursiveCount;
    }

    private int recursiveCollapse(List<T> subItems, int level) {
        int collapsed = 0;
        for (int i = subItems.size() - 1; i >= 0; --i) {
            IExpandable expandable;
            IFlexible subItem = (IFlexible)subItems.get(i);
            if (!this.isExpanded(subItem) || (expandable = (IExpandable)subItem).getExpansionLevel() < level || this.collapse(this.getGlobalPositionOf(subItem)) <= 0) continue;
            ++collapsed;
        }
        return collapsed;
    }

    public int collapseAll() {
        return this.collapseAll(this.minCollapsibleLevel);
    }

    public int collapseAll(int level) {
        return this.recursiveCollapse(this.mItems, level);
    }

    public void updateItem(@NonNull T item, @Nullable Object payload) {
        this.updateItem(this.getGlobalPositionOf((IFlexible)item), item, payload);
    }

    public void updateItem(@IntRange(from=0L) int position, @NonNull T item, @Nullable Object payload) {
        if (position < 0 || position >= this.mItems.size()) {
            Log.e((String)TAG, (String)"Cannot updateItem on position out of OutOfBounds!");
            return;
        }
        this.mItems.set(position, item);
        if (DEBUG) {
            Log.v((String)TAG, (String)("updateItem notifyItemChanged on position " + position));
        }
        this.notifyItemChanged(position, payload);
    }

    public void addItemWithDelay(final @IntRange(from=0L) int position, @NonNull T item, @IntRange(from=0L) long delay, boolean scrollToPosition) {
        this.mHandler.postDelayed(new Runnable((IFlexible)item, scrollToPosition){
            final /* synthetic */ IFlexible val$item;
            final /* synthetic */ boolean val$scrollToPosition;
            {
                this.val$item = iFlexible;
                this.val$scrollToPosition = bl;
            }

            @Override
            public void run() {
                if (FlexibleAdapter.this.addItem(position, this.val$item) && this.val$scrollToPosition && FlexibleAdapter.this.mRecyclerView != null) {
                    FlexibleAdapter.this.mRecyclerView.smoothScrollToPosition(Math.min(Math.max(0, position), FlexibleAdapter.this.getItemCount() - 1));
                }
            }
        }, delay);
    }

    public boolean addItem(@IntRange(from=0L) int position, @NonNull T item) {
        if (item == null) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"addItem delegates addition to addItems!");
        }
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item);
        return this.addItems(position, items);
    }

    public boolean addItems(@IntRange(from=0L) int position, @NonNull List<T> items) {
        if (position < 0) {
            Log.e((String)TAG, (String)"Cannot addItems on negative position!");
            return false;
        }
        if (items == null || items.isEmpty()) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("addItems on position=" + position + " itemCount=" + items.size()));
        }
        int initialCount = this.getItemCount();
        if (position < this.mItems.size()) {
            this.mItems.addAll(position, items);
        } else {
            this.mItems.addAll(items);
        }
        this.notifyItemRangeInserted(position, items.size());
        if (this.headersShown && !this.recursive) {
            this.recursive = true;
            for (IFlexible item : items) {
                this.showHeaderOf(this.getGlobalPositionOf(item), item);
            }
            this.recursive = false;
        }
        if (!this.recursive && this.mUpdateListener != null && !this.multiRange && initialCount == 0 && this.getItemCount() > 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        return true;
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item) {
        return this.addSubItem(parentPosition, subPosition, item, false, null);
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item, boolean expandParent, @Nullable Object payload) {
        if (item == null) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        ArrayList<T> subItems = new ArrayList<T>(1);
        subItems.add(item);
        return this.addSubItems(parentPosition, subPosition, subItems, expandParent, payload);
    }

    public int addAllSubItemsFrom(@IntRange(from=0L) int parentPosition, @NonNull IExpandable parent, boolean expandParent, @Nullable Object payload) {
        List<T> subItems = this.getCurrentChildren(parent);
        this.addSubItems(parentPosition, 0, parent, subItems, expandParent, payload);
        return subItems.size();
    }

    public boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull List<T> items, boolean expandParent, @Nullable Object payload) {
        T parent = this.getItem(parentPosition);
        if (this.isExpandable(parent)) {
            IExpandable expandable = (IExpandable)parent;
            return this.addSubItems(parentPosition, subPosition, expandable, items, expandParent, payload);
        }
        Log.e((String)TAG, (String)"Passed parentPosition doesn't belong to an Expandable item!");
        return false;
    }

    private boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull IExpandable parent, @NonNull List<T> items, boolean expandParent, @Nullable Object payload) {
        boolean added = false;
        if (expandParent && !parent.isExpanded()) {
            this.expand(parentPosition);
        }
        if (parent.isExpanded()) {
            added = this.addItems(parentPosition + 1 + Math.max(0, subPosition), items);
        }
        if (payload != null) {
            this.notifyItemChanged(parentPosition, payload);
        }
        return added;
    }

    public int addSection(@NonNull IHeader header) {
        return this.addSection(header, (Comparator)null);
    }

    @Deprecated
    public void addSection(@NonNull IHeader header, @Nullable IHeader refHeader) {
        int position = 0;
        if (refHeader != null) {
            position = this.getGlobalPositionOf(refHeader) + 1;
            List<ISectionable> refSectionItems = this.getSectionItems(refHeader);
            if (!refSectionItems.isEmpty()) {
                position += refSectionItems.size();
            }
        }
        this.addItem(position, header);
    }

    public int addSection(@NonNull IHeader header, @Nullable Comparator comparator) {
        int position = this.calculatePositionFor(header, comparator);
        this.addItem(position, header);
        return position;
    }

    public int addItemToSection(@NonNull ISectionable sectionable, @NonNull IHeader header, @NonNull Comparator comparator) {
        int index;
        if (header != null && !header.isHidden()) {
            List<ISectionable> sectionItems = this.getSectionItems(header);
            sectionItems.add(sectionable);
            Collections.sort(sectionItems, comparator);
            index = sectionItems.indexOf(sectionable);
        } else {
            index = this.calculatePositionFor(sectionable, comparator);
        }
        return this.addItemToSection(sectionable, header, index);
    }

    public int addItemToSection(@NonNull ISectionable item, @NonNull IHeader header, @IntRange(from=0L) int index) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("addItemToSection relativePosition=" + index));
        }
        int headerPosition = this.getGlobalPositionOf(header);
        if (index >= 0) {
            item.setHeader(header);
            if (headerPosition >= 0 && this.isExpandable(header)) {
                this.addSubItem(headerPosition, index, item, false, true);
            } else {
                this.addItem(headerPosition + 1 + index, item);
            }
        }
        return this.getGlobalPositionOf(item);
    }

    public void removeItemWithDelay(@NonNull T item, @IntRange(from=0L) long delay, final boolean permanent, boolean resetLayoutAnimation) {
        if (resetLayoutAnimation) {
            this.setInitialize(true);
        }
        this.mHandler.postDelayed(new Runnable((IFlexible)item){
            final /* synthetic */ IFlexible val$item;
            {
                this.val$item = iFlexible;
            }

            @Override
            public void run() {
                boolean tempPermanent = FlexibleAdapter.this.permanentDelete;
                if (permanent) {
                    FlexibleAdapter.this.permanentDelete = true;
                }
                FlexibleAdapter.this.removeItem(FlexibleAdapter.this.getGlobalPositionOf(this.val$item));
                FlexibleAdapter.this.permanentDelete = tempPermanent;
                FlexibleAdapter.this.setInitialize(false);
            }
        }, delay);
    }

    public void removeItem(@IntRange(from=0L) int position) {
        this.removeItem(position, null);
    }

    public void removeItem(@IntRange(from=0L) int position, @Nullable Object payload) {
        this.collapse(position);
        if (DEBUG) {
            Log.v((String)TAG, (String)"removeItem delegates removal to removeRange");
        }
        this.removeRange(position, 1, payload);
    }

    public void removeItems(@NonNull List<Integer> selectedPositions) {
        this.removeItems(selectedPositions, null);
    }

    public void removeItems(@NonNull List<Integer> selectedPositions, @Nullable Object payload) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems selectedPositions=" + selectedPositions + " payload=" + payload));
        }
        if (selectedPositions == null || selectedPositions.isEmpty()) {
            return;
        }
        Collections.sort(selectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return rhs - lhs;
            }
        });
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems after reverse sort selectedPositions=" + selectedPositions));
        }
        int positionStart = 0;
        int itemCount = 0;
        int lastPosition = selectedPositions.get(0);
        this.multiRange = true;
        for (Integer position : selectedPositions) {
            if (lastPosition - itemCount == position) {
                ++itemCount;
                positionStart = position;
            } else {
                if (itemCount > 0) {
                    this.removeRange(positionStart, itemCount, payload);
                }
                positionStart = lastPosition = position.intValue();
                itemCount = 1;
            }
            this.collapse(position);
        }
        this.multiRange = false;
        if (itemCount > 0) {
            this.removeRange(positionStart, itemCount, payload);
        }
    }

    public void removeItemsOfType(Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        ArrayList<Integer> itemsToRemove = new ArrayList<Integer>();
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            if ((!this.autoMap || !viewTypeList.contains(((IFlexible)this.mItems.get(i)).getLayoutRes())) && !viewTypeList.contains(this.getItemViewType(i))) continue;
            itemsToRemove.add(i);
        }
        this.removeItems(itemsToRemove);
    }

    public void removeRange(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        this.removeRange(positionStart, itemCount, null);
    }

    public void removeRange(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount, @Nullable Object payload) {
        int initialCount = this.getItemCount();
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeRange positionStart=" + positionStart + " itemCount=" + itemCount));
        }
        if (positionStart < 0 || positionStart + itemCount > initialCount) {
            Log.e((String)TAG, (String)"Cannot removeRange with positionStart out of OutOfBounds!");
            return;
        }
        IHeader header = this.getHeaderOf(this.getItem(positionStart));
        int headerPosition = this.getGlobalPositionOf(header);
        if (header != null && headerPosition >= 0) {
            this.addToOrphanListIfNeeded(header, positionStart, itemCount);
            this.notifyItemChanged(headerPosition, payload);
        }
        int parentPosition = -1;
        IExpandable parent = null;
        for (int position = positionStart; position < positionStart + itemCount; ++position) {
            T item = this.getItem(positionStart);
            if (!this.permanentDelete) {
                if (parent == null) {
                    parent = this.getExpandableOf(item);
                }
                if (parent == null) {
                    this.createRestoreItemInfo(positionStart, item, payload);
                } else {
                    parentPosition = this.createRestoreSubItemInfo(parent, item, payload);
                }
            }
            if (this.isHeader(item)) {
                header = (IHeader)item;
                header.setHidden(true);
            }
            if (this.unlinkOnRemoveHeader && this.isHeader(item)) {
                List<ISectionable> sectionableList = this.getSectionItems(header);
                for (ISectionable sectionable : sectionableList) {
                    sectionable.setHeader(null);
                    if (payload == null) continue;
                    this.notifyItemChanged(this.getGlobalPositionOf(sectionable), payload);
                }
            }
            this.mItems.remove(positionStart);
            this.removeSelection(position);
        }
        if (parentPosition >= 0) {
            this.notifyItemRangeRemoved(positionStart, itemCount);
            if (payload != null) {
                this.notifyItemChanged(parentPosition, payload);
            }
        } else {
            this.notifyItemRangeRemoved(positionStart, itemCount);
        }
        if (this.removeOrphanHeaders) {
            for (IHeader orphanHeader : this.mOrphanHeaders) {
                headerPosition = this.getGlobalPositionOf(orphanHeader);
                if (headerPosition < 0) continue;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Removing orphan header " + orphanHeader));
                }
                if (!this.permanentDelete) {
                    this.createRestoreItemInfo(headerPosition, orphanHeader, payload);
                }
                this.mItems.remove(headerPosition);
                this.notifyItemRemoved(headerPosition);
            }
            this.mOrphanHeaders.clear();
        }
        if (this.mUpdateListener != null && !this.multiRange && initialCount > 0 && this.getItemCount() == 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    public void removeAllSelectedItems() {
        this.removeAllSelectedItems(null);
    }

    public void removeAllSelectedItems(@Nullable Object payload) {
        this.removeItems(this.getSelectedPositions(), payload);
    }

    public boolean isPermanentDelete() {
        return this.permanentDelete;
    }

    public FlexibleAdapter setPermanentDelete(boolean permanentDelete) {
        this.permanentDelete = permanentDelete;
        return this;
    }

    public boolean isRestoreWithSelection() {
        return this.restoreSelection;
    }

    public FlexibleAdapter setRestoreSelectionOnUndo(boolean restoreSelection) {
        this.restoreSelection = restoreSelection;
        return this;
    }

    public void restoreDeletedItems() {
        this.stopUndoTimer();
        this.multiRange = true;
        int initialCount = this.getItemCount();
        this.clearSelection();
        for (int i = this.mRestoreList.size() - 1; i >= 0; --i) {
            this.adjustSelected = false;
            RestoreInfo restoreInfo = this.mRestoreList.get(i);
            IHeader header = this.getHeaderOf(restoreInfo.item);
            if (header != null) {
                this.notifyItemChanged(this.getGlobalPositionOf(header), restoreInfo.payload);
            }
            if (restoreInfo.relativePosition >= 0) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Child " + restoreInfo));
                }
                if (this.hasSearchText() && !this.filterObject(restoreInfo.item, this.getSearchText())) continue;
                if (this.hasSearchText() && this.getGlobalPositionOf(this.getHeaderOf(restoreInfo.item)) == -1) {
                    restoreInfo.refItem.setHidden(false);
                    this.addItem(restoreInfo.getRestorePosition(false), restoreInfo.refItem);
                    this.addSubItem(restoreInfo.getRestorePosition(true), 0, restoreInfo.item, true, null);
                } else {
                    this.addSubItem(restoreInfo.getRestorePosition(true), restoreInfo.relativePosition, restoreInfo.item, false, restoreInfo.payload);
                }
            } else {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Parent " + restoreInfo));
                }
                if (this.hasSearchText() && !this.filterExpandableObject(restoreInfo.item)) continue;
                if (this.hasSearchText() && this.hasHeader(restoreInfo.item) && this.getGlobalPositionOf(this.getHeaderOf(restoreInfo.item)) == -1) {
                    this.getHeaderOf(restoreInfo.item).setHidden(true);
                }
                this.addItem(restoreInfo.getRestorePosition(false), restoreInfo.item);
            }
            restoreInfo.item.setHidden(false);
            if (!this.unlinkOnRemoveHeader || !this.isHeader(restoreInfo.item)) continue;
            header = (IHeader)restoreInfo.item;
            List<ISectionable> items = this.getSectionItems(header);
            for (ISectionable sectionable : items) {
                this.linkHeaderTo(sectionable, header, restoreInfo.payload);
            }
        }
        if (this.restoreSelection && !this.mRestoreList.isEmpty()) {
            if (this.isExpandable(this.mRestoreList.get((int)0).item) || this.getExpandableOf(this.mRestoreList.get((int)0).item) == null) {
                this.parentSelected = true;
            } else {
                this.childSelected = true;
            }
            for (RestoreInfo restoreInfo : this.mRestoreList) {
                if (!restoreInfo.item.isSelectable()) continue;
                this.addSelection(this.getGlobalPositionOf((IFlexible)restoreInfo.item));
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Selected positions after restore " + this.getSelectedPositions()));
            }
        }
        this.multiRange = false;
        if (this.mUpdateListener != null && initialCount == 0 && this.getItemCount() > 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        this.emptyBin();
    }

    public synchronized void emptyBin() {
        if (DEBUG) {
            Log.v((String)TAG, (String)"emptyBin!");
        }
        this.mRestoreList.clear();
    }

    public void startUndoTimer(OnDeleteCompleteListener listener) {
        this.startUndoTimer(0L, listener);
    }

    public void startUndoTimer(long timeout, OnDeleteCompleteListener listener) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)1, (Object)listener), timeout > 0L ? timeout : 5000L);
    }

    protected void stopUndoTimer() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public boolean isRestoreInTime() {
        return this.mRestoreList != null && !this.mRestoreList.isEmpty();
    }

    @NonNull
    public List<T> getDeletedItems() {
        ArrayList deletedItems = new ArrayList();
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            deletedItems.add(restoreInfo.item);
        }
        return deletedItems;
    }

    public IExpandable getExpandableOfDeletedChild(T child) {
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (!restoreInfo.item.equals(child) || !this.isExpandable(restoreInfo.refItem)) continue;
            return (IExpandable)restoreInfo.refItem;
        }
        return null;
    }

    @NonNull
    public List<T> getDeletedChildren(IExpandable expandable) {
        ArrayList deletedChild = new ArrayList();
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (restoreInfo.refItem == null || !restoreInfo.refItem.equals(expandable) || restoreInfo.relativePosition < 0) continue;
            deletedChild.add(restoreInfo.item);
        }
        return deletedChild;
    }

    @NonNull
    public List<T> getCurrentChildren(@NonNull IExpandable expandable) {
        if (expandable == null || !this.hasSubItems(expandable)) {
            return new ArrayList();
        }
        ArrayList subItems = new ArrayList(expandable.getSubItems());
        if (!this.mRestoreList.isEmpty()) {
            subItems.removeAll(this.getDeletedChildren(expandable));
        }
        return subItems;
    }

    public boolean hasSearchText() {
        return this.mSearchText != null && !this.mSearchText.isEmpty();
    }

    public boolean hasNewSearchText(String newText) {
        return !this.mOldSearchText.equalsIgnoreCase(newText);
    }

    public String getSearchText() {
        return this.mSearchText;
    }

    public void setSearchText(String searchText) {
        this.mSearchText = searchText != null ? searchText.trim().toLowerCase(Locale.getDefault()) : "";
    }

    public final FlexibleAdapter setNotifyChangeOfUnfilteredItems(boolean notifyChange) {
        this.mNotifyChangeOfUnfilteredItems = notifyChange;
        return this;
    }

    public void filterItems(@NonNull List<T> unfilteredItems, @IntRange(from=0L) long delay) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)0, unfilteredItems), delay > 0L ? delay : 0L);
    }

    public synchronized void filterItems(@NonNull List<T> unfilteredItems) {
        List<Object> values = new ArrayList();
        this.filtering = true;
        int initialCount = this.getItemCount();
        if (this.hasSearchText()) {
            int newOriginalPosition = -1;
            for (IFlexible item : unfilteredItems) {
                IHeader header = this.getHeaderOf(item);
                if (header != null && this.filterObject(header, this.getSearchText()) && !values.contains(this.getHeaderOf(item))) {
                    values.add(header);
                }
                if (this.filterExpandableObject(item)) {
                    RestoreInfo restoreInfo = this.getPendingRemovedItem(item);
                    if (restoreInfo != null) {
                        restoreInfo.filterRefItem = ++newOriginalPosition < values.size() ? (IFlexible)values.get(newOriginalPosition) : null;
                        continue;
                    }
                    if (this.hasHeader(item) && !values.contains(this.getHeaderOf(item))) {
                        values.add(this.getHeaderOf(item));
                    }
                    values.add(item);
                    newOriginalPosition += 1 + this.addFilteredSubItems(values, item);
                    continue;
                }
                item.setHidden(true);
            }
        } else if (this.hasNewSearchText(this.mSearchText)) {
            values = unfilteredItems;
            if (!this.mRestoreList.isEmpty()) {
                for (RestoreInfo restoreInfo : this.mRestoreList) {
                    restoreInfo.clearFilterRef();
                    restoreInfo.refItem = (IFlexible)values.get(Math.max(0, values.indexOf(restoreInfo.item) - 1));
                }
                values.removeAll(this.getDeletedItems());
            }
            this.resetFilterFlags(values);
        }
        if (this.hasNewSearchText(this.mSearchText)) {
            this.mOldSearchText = this.mSearchText;
            this.animateTo(values);
            if (!this.hasSearchText()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FlexibleAdapter.this.showAllHeaders();
                    }
                });
            }
        }
        this.filtering = false;
        if (this.mUpdateListener != null && initialCount == 0 && this.getItemCount() > 0 || initialCount > 0 && this.getItemCount() == 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    private boolean filterExpandableObject(T item) {
        boolean filtered = false;
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            if (expandable.isExpanded()) {
                if (this.mExpandedFilterFlags == null) {
                    this.mExpandedFilterFlags = new ArrayList<IExpandable>();
                }
                this.mExpandedFilterFlags.add(expandable);
            }
            expandable.setExpanded(false);
            Iterator<T> iterator = this.getCurrentChildren(expandable).iterator();
            while (iterator.hasNext()) {
                IFlexible subItem;
                subItem.setHidden(!this.filterObject(subItem = (IFlexible)iterator.next(), this.getSearchText()));
                if (filtered || subItem.isHidden()) continue;
                filtered = true;
            }
            expandable.setExpanded(filtered);
        }
        return filtered || this.filterObject(item, this.getSearchText());
    }

    protected boolean filterObject(T item, String constraint) {
        if (item instanceof IFilterable) {
            IFilterable filterable = (IFilterable)item;
            return filterable.filter(constraint);
        }
        return false;
    }

    private int addFilteredSubItems(List<T> values, T item) {
        IExpandable expandable;
        if (this.isExpandable(item) && this.hasSubItems(expandable = (IExpandable)item)) {
            ArrayList<IFlexible> filteredSubItems = new ArrayList<IFlexible>();
            List subItems = expandable.getSubItems();
            for (IFlexible subItem : subItems) {
                if (subItem.isHidden()) continue;
                filteredSubItems.add(subItem);
            }
            values.addAll(filteredSubItems);
            return filteredSubItems.size();
        }
        return 0;
    }

    private void resetFilterFlags(List<T> items) {
        for (int i = 0; i < items.size(); ++i) {
            IFlexible item = (IFlexible)items.get(i);
            item.setHidden(false);
            if (!this.isExpandable(item)) continue;
            IExpandable expandable = (IExpandable)item;
            expandable.setExpanded(this.mExpandedFilterFlags.contains(expandable));
            if (!this.hasSubItems(expandable)) continue;
            List subItems = expandable.getSubItems();
            for (int k = 0; k < subItems.size(); ++k) {
                IFlexible subItem = (IFlexible)subItems.get(k);
                subItem.setHidden(false);
                if (!expandable.isExpanded()) continue;
                int position = items.indexOf(item) + (k + 1);
                if (position < items.size()) {
                    items.add(position, subItem);
                } else {
                    items.add(subItem);
                }
                ++i;
            }
        }
        this.mExpandedFilterFlags = null;
    }

    public List<T> animateTo(@Nullable List<T> models) {
        if (models == null) {
            models = new ArrayList<T>();
        }
        this.applyAndAnimateRemovals(this.mItems, models);
        this.applyAndAnimateAdditions(this.mItems, models);
        this.applyAndAnimateMovedItems(this.mItems, models);
        return this.mItems;
    }

    protected void applyAndAnimateRemovals(List<T> from, List<T> newItems) {
        int out = 0;
        for (int i = from.size() - 1; i >= 0; --i) {
            IFlexible item = (IFlexible)from.get(i);
            if (!newItems.contains(item) && (!this.isHeader(item) || this.isHeader(item) && this.headersShown)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateRemovals remove position=" + i + " item=" + item));
                }
                from.remove(i);
                this.notifyItemRemoved(i);
                ++out;
                continue;
            }
            if (!this.mNotifyChangeOfUnfilteredItems) continue;
            from.set(i, item);
            this.notifyItemChanged(i, this.mNotifyChangeOfUnfilteredItems);
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateRemovals   keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateRemovals total out=" + out + " size=" + newItems.size()));
        }
    }

    protected void applyAndAnimateAdditions(List<T> from, List<T> newItems) {
        int in = 0;
        for (int i = 0; i < newItems.size(); ++i) {
            IFlexible item = (IFlexible)newItems.get(i);
            if (from.contains(item)) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("animateAdditions    add position=" + i + " item=" + item));
            }
            from.add(item);
            this.notifyItemInserted(from.size());
            ++in;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateAdditions total new=" + in + " size=" + newItems.size()));
        }
    }

    protected void applyAndAnimateMovedItems(List<T> from, List<T> newItems) {
        for (int toPosition = newItems.size() - 1; toPosition >= 0; --toPosition) {
            IFlexible item = (IFlexible)newItems.get(toPosition);
            int fromPosition = from.indexOf(item);
            if (fromPosition < 0 || fromPosition == toPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("animateMoved fromPosition=" + fromPosition + " toPosition=" + toPosition));
            }
            IFlexible movedItem = (IFlexible)from.remove(fromPosition);
            if (toPosition < from.size()) {
                from.add(toPosition, movedItem);
            } else {
                from.add(movedItem);
            }
            this.notifyItemMoved(fromPosition, toPosition);
        }
    }

    public final ItemTouchHelper getItemTouchHelper() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper;
    }

    public final ItemTouchHelperCallback getItemTouchHelperCallback() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelperCallback;
    }

    public boolean isLongPressDragEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isLongPressDragEnabled();
    }

    public final FlexibleAdapter setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelperCallback.setLongPressDragEnabled(longPressDragEnabled);
        return this;
    }

    public boolean isHandleDragEnabled() {
        return this.handleDragEnabled;
    }

    public FlexibleAdapter setHandleDragEnabled(boolean handleDragEnabled) {
        this.handleDragEnabled = handleDragEnabled;
        return this;
    }

    public final boolean isSwipeEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isItemViewSwipeEnabled();
    }

    public final FlexibleAdapter setSwipeEnabled(boolean swipeEnabled) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelperCallback.setSwipeEnabled(swipeEnabled);
        return this;
    }

    public void moveItem(int fromPosition, int toPosition) {
        this.moveItem(fromPosition, toPosition, null);
    }

    public void moveItem(int fromPosition, int toPosition, @Nullable Object payload) {
        IFlexible item;
        boolean expanded;
        if (DEBUG) {
            Log.v((String)TAG, (String)("moveItem fromPosition=" + fromPosition + " toPosition=" + toPosition));
        }
        if (this.isSelected(fromPosition)) {
            this.removeSelection(fromPosition);
            this.addSelection(toPosition);
        }
        if (expanded = this.isExpanded(item = (IFlexible)this.mItems.get(fromPosition))) {
            this.collapse(toPosition);
        }
        this.mItems.remove(fromPosition);
        if (toPosition < this.getItemCount()) {
            this.mItems.add(toPosition, item);
        } else {
            this.mItems.add(item);
        }
        this.notifyItemMoved(fromPosition, toPosition);
        if (payload != null) {
            this.notifyItemChanged(toPosition, payload);
        }
        if (this.headersShown) {
            this.showHeaderOf(toPosition, item);
        }
        if (expanded) {
            this.expand(toPosition);
        }
    }

    public void swapItems(int fromPosition, int toPosition) {
        if (fromPosition < 0 || fromPosition >= this.getItemCount() || toPosition < 0 || toPosition >= this.getItemCount()) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("swapItems from=" + fromPosition + "[" + (this.isSelected(fromPosition) ? "selected" : "unselected") + "] to=" + toPosition + "[" + (this.isSelected(toPosition) ? "selected" : "unselected") + "]"));
            Log.v((String)TAG, (String)("swapItems beforeSwap fromItem=" + this.getItem(fromPosition) + " toItem=" + this.getItem(toPosition)));
        }
        if (this.isExpanded(toPosition)) {
            this.collapse(toPosition);
        }
        Collections.swap(this.mItems, fromPosition, toPosition);
        if (this.isSelected(fromPosition) && !this.isSelected(toPosition) || !this.isSelected(fromPosition) && this.isSelected(toPosition)) {
            super.toggleSelection(fromPosition);
            super.toggleSelection(toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
        if (DEBUG) {
            Log.v((String)TAG, (String)("swapItems afterSwap fromItem=" + this.getItem(fromPosition) + " toItem=" + this.getItem(toPosition)));
        }
        if (this.headersShown) {
            T fromItem = this.getItem(toPosition);
            T toItem = this.getItem(fromPosition);
            if (toItem instanceof IHeader && fromItem instanceof IHeader) {
                if (fromPosition < toPosition) {
                    IHeader header = (IHeader)fromItem;
                    List<ISectionable> items = this.getSectionItems(header);
                    for (ISectionable sectionable : items) {
                        this.linkHeaderTo(sectionable, header, true);
                    }
                } else {
                    IHeader header = (IHeader)toItem;
                    List<ISectionable> items = this.getSectionItems(header);
                    for (ISectionable sectionable : items) {
                        this.linkHeaderTo(sectionable, header, true);
                    }
                }
            } else if (toItem instanceof IHeader) {
                int oldPosition = fromPosition < toPosition ? toPosition + 1 : toPosition;
                int newPosition = fromPosition < toPosition ? toPosition : fromPosition + 1;
                this.linkHeaderTo(this.getItem(oldPosition), this.getSectionHeader(oldPosition), true);
                this.linkHeaderTo(this.getItem(newPosition), (IHeader)toItem, true);
            } else if (fromItem instanceof IHeader) {
                int oldPosition = fromPosition < toPosition ? fromPosition : fromPosition + 1;
                int newPosition = fromPosition < toPosition ? toPosition + 1 : fromPosition;
                this.linkHeaderTo(this.getItem(oldPosition), this.getSectionHeader(oldPosition), true);
                this.linkHeaderTo(this.getItem(newPosition), (IHeader)fromItem, true);
            } else {
                int oldPosition = fromPosition < toPosition ? toPosition : fromPosition;
                int newPosition = fromPosition < toPosition ? fromPosition : toPosition;
                IHeader header = this.getHeaderOf(this.getItem(oldPosition));
                if (header != null) {
                    this.linkHeaderTo(this.getItem(newPosition), header, true);
                }
            }
        }
    }

    @Override
    public void onActionStateChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onActionStateChanged(viewHolder, actionState);
        } else if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onActionStateChanged(viewHolder, actionState);
        }
    }

    @Override
    public boolean shouldMove(int fromPosition, int toPosition) {
        return true;
    }

    @Override
    @CallSuper
    public boolean onItemMove(int fromPosition, int toPosition) {
        this.swapItems(fromPosition, toPosition);
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onItemMove(fromPosition, toPosition);
        }
        return true;
    }

    @Override
    @CallSuper
    public void onItemSwiped(int position, int direction) {
        if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onItemSwipe(position, direction);
        }
    }

    private void initializeItemTouchHelper() {
        if (this.mItemTouchHelper == null) {
            if (this.mRecyclerView == null) {
                throw new IllegalStateException("RecyclerView cannot be null. Enabling LongPressDrag or Swipe must be done after the Adapter is added to the RecyclerView.");
            }
            this.mItemTouchHelperCallback = new ItemTouchHelperCallback(this);
            this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.mItemTouchHelperCallback);
            this.mItemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    private void mapViewTypeFrom(T item) {
        if (item != null && !this.mTypeInstances.containsKey(item.getLayoutRes())) {
            this.mTypeInstances.put(item.getLayoutRes(), item);
            if (DEBUG) {
                Log.i((String)TAG, (String)("Mapped viewType " + item.getLayoutRes() + " from " + item.getClass().getSimpleName()));
            }
        }
    }

    private T getViewTypeInstance(int viewType) {
        return (T)((IFlexible)this.mTypeInstances.get(viewType));
    }

    private RestoreInfo getPendingRemovedItem(T item) {
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (!restoreInfo.item.equals(item) || restoreInfo.refPosition >= 0) continue;
            return restoreInfo;
        }
        return null;
    }

    private int createRestoreSubItemInfo(IExpandable expandable, T item, @Nullable Object payload) {
        int parentPosition = this.getGlobalPositionOf(expandable);
        List<T> siblings = this.getExpandableList(expandable);
        int childPosition = siblings.indexOf(item);
        item.setHidden(true);
        this.mRestoreList.add(new RestoreInfo(this, (IFlexible)expandable, item, childPosition, payload));
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled Child " + this.mRestoreList.get(this.mRestoreList.size() - 1) + " with Parent position=" + parentPosition));
        }
        return parentPosition;
    }

    private void createRestoreItemInfo(int position, T item, @Nullable Object payload) {
        IExpandable expandable;
        if (this.isExpanded(item)) {
            this.collapse(position);
        }
        item.setHidden(true);
        Object refItem = this.getItem(position - 1);
        if (refItem != null && (expandable = this.getExpandableOf(refItem)) != null) {
            refItem = expandable;
        }
        this.mRestoreList.add(new RestoreInfo(this, refItem, item, payload));
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled Parent " + this.mRestoreList.get(this.mRestoreList.size() - 1) + " on position=" + position));
        }
    }

    @NonNull
    private List<T> getExpandableList(IExpandable expandable) {
        ArrayList<IFlexible> subItems = new ArrayList<IFlexible>();
        if (expandable != null && this.hasSubItems(expandable)) {
            List allSubItems = expandable.getSubItems();
            for (IFlexible subItem : allSubItems) {
                if (subItem.isHidden()) continue;
                subItems.add(subItem);
            }
        }
        return subItems;
    }

    private boolean hasSubItemsSelected(IExpandable expandable) {
        for (IFlexible subItem : this.getExpandableList(expandable)) {
            if (!this.isSelected(this.getGlobalPositionOf(subItem)) && (!this.isExpandable(subItem) || !this.hasSubItemsSelected((IExpandable)subItem))) continue;
            return true;
        }
        return false;
    }

    private void autoScrollWithDelay(final int position, final int subItemsCount, long delay) {
        new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                int lastVisibleItem;
                int firstVisibleItem;
                if (FlexibleAdapter.this.mRecyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
                    firstVisibleItem = ((StaggeredGridLayoutManager)FlexibleAdapter.this.mRecyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPositions(null)[0];
                    lastVisibleItem = ((StaggeredGridLayoutManager)FlexibleAdapter.this.mRecyclerView.getLayoutManager()).findLastCompletelyVisibleItemPositions(null)[0];
                } else {
                    firstVisibleItem = ((LinearLayoutManager)FlexibleAdapter.this.mRecyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition();
                    lastVisibleItem = ((LinearLayoutManager)FlexibleAdapter.this.mRecyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
                }
                int itemsToShow = position + subItemsCount - lastVisibleItem;
                if (SelectableAdapter.DEBUG) {
                    Log.v((String)TAG, (String)("autoScroll itemsToShow=" + itemsToShow + " firstVisibleItem=" + firstVisibleItem + " lastVisibleItem=" + lastVisibleItem + " RvChildCount=" + FlexibleAdapter.this.mRecyclerView.getChildCount()));
                }
                if (itemsToShow > 0) {
                    int scrollMax = position - firstVisibleItem;
                    int scrollMin = Math.max(0, position + subItemsCount - lastVisibleItem);
                    int scrollBy = Math.min(scrollMax, scrollMin);
                    int spanCount = SelectableAdapter.getSpanCount(FlexibleAdapter.this.mRecyclerView.getLayoutManager());
                    if (spanCount > 1) {
                        scrollBy = scrollBy % spanCount + spanCount;
                    }
                    int scrollTo = firstVisibleItem + scrollBy;
                    if (SelectableAdapter.DEBUG) {
                        Log.v((String)TAG, (String)("autoScroll scrollMin=" + scrollMin + " scrollMax=" + scrollMax + " scrollBy=" + scrollBy + " scrollTo=" + scrollTo));
                    }
                    FlexibleAdapter.this.mRecyclerView.smoothScrollToPosition(scrollTo);
                } else if (position < firstVisibleItem) {
                    FlexibleAdapter.this.mRecyclerView.smoothScrollToPosition(position);
                }
                return true;
            }
        }).sendMessageDelayed(Message.obtain((Handler)this.mHandler), delay);
    }

    private void adjustSelected(int startPosition, int itemCount) {
        List<Integer> selectedPositions = this.getSelectedPositions();
        boolean adjusted = false;
        for (Integer position : selectedPositions) {
            if (position < startPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adjust Selected position " + position + " to " + Math.max(position + itemCount, startPosition)));
            }
            this.removeSelection(position);
            this.addSelection(Math.max(position + itemCount, startPosition));
            adjusted = true;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedSelected=" + this.getSelectedPositions()));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            super.onSaveInstanceState(outState);
            outState.putBoolean(EXTRA_CHILD, this.childSelected);
            outState.putBoolean(EXTRA_PARENT, this.parentSelected);
            outState.putInt(EXTRA_LEVEL, this.selectedLevel);
            outState.putString(EXTRA_SEARCH, this.mSearchText);
            outState.putBoolean(EXTRA_HEADERS, this.headersShown);
        }
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            boolean headersShown = savedInstanceState.getBoolean(EXTRA_HEADERS);
            if (!headersShown) {
                this.hideAllHeaders();
            } else if (headersShown && !this.headersShown) {
                this.showAllHeaders();
            }
            this.headersShown = headersShown;
            super.onRestoreInstanceState(savedInstanceState);
            this.parentSelected = savedInstanceState.getBoolean(EXTRA_PARENT);
            this.childSelected = savedInstanceState.getBoolean(EXTRA_CHILD);
            this.selectedLevel = savedInstanceState.getInt(EXTRA_LEVEL);
            this.mSearchText = savedInstanceState.getString(EXTRA_SEARCH);
        }
    }

    private static class RestoreInfo {
        int refPosition = -1;
        int relativePosition = -1;
        T refItem = null;
        T filterRefItem = null;
        T item = null;
        Object payload = false;
        final /* synthetic */ FlexibleAdapter this$0;

        public RestoreInfo(T refItem, T item, Object payload) {
            this(var1_1, (IFlexible)refItem, (IFlexible)item, -1, payload);
        }

        public RestoreInfo(T refItem, T item, int relativePosition, Object payload) {
            this.this$0 = var1_1;
            this.refItem = refItem;
            this.item = item;
            this.relativePosition = relativePosition;
            this.payload = payload;
        }

        public int getRestorePosition(boolean isChild) {
            if (this.refPosition < 0) {
                this.refPosition = this.this$0.getGlobalPositionOf((IFlexible)(this.filterRefItem != null ? this.filterRefItem : this.refItem));
            }
            Object item = this.this$0.getItem(this.refPosition);
            if (isChild && this.this$0.isExpandable(item)) {
                this.this$0.recursiveCollapse(this.this$0.getCurrentChildren((IExpandable)item), 0);
            } else {
                this.refPosition = this.this$0.isExpanded(item) && !isChild ? (this.refPosition += this.this$0.getExpandableList((IExpandable)item).size() + 1) : ++this.refPosition;
            }
            return this.refPosition;
        }

        public void clearFilterRef() {
            this.filterRefItem = null;
            this.refPosition = -1;
        }

        public String toString() {
            return "RestoreInfo[item=" + this.item + ", refItem=" + this.refItem + ", filterRefItem=" + this.filterRefItem + "]";
        }
    }

    private class AdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private AdapterDataObserver() {
        }

        private void adjustPositions(int positionStart, int itemCount) {
            if (!FlexibleAdapter.this.filtering) {
                if (FlexibleAdapter.this.adjustSelected) {
                    FlexibleAdapter.this.adjustSelected(positionStart, itemCount);
                }
                FlexibleAdapter.this.adjustSelected = true;
            }
        }

        private void updateOrClearHeader() {
            if (FlexibleAdapter.this.mStickyHeaderHelper != null && !FlexibleAdapter.this.multiRange && !FlexibleAdapter.this.filtering) {
                FlexibleAdapter.this.mStickyHeaderHelper.updateOrClearHeader(true);
            }
        }

        public void onChanged() {
            this.updateOrClearHeader();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, itemCount);
            this.updateOrClearHeader();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, -itemCount);
            this.updateOrClearHeader();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.updateOrClearHeader();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.updateOrClearHeader();
        }
    }

    public static interface EndlessScrollListener {
        public void onLoadMore();
    }

    public static interface OnStickyHeaderChangeListener {
        public void onStickyHeaderChange(int var1);
    }

    public static interface OnItemSwipeListener
    extends OnActionStateListener {
        public void onItemSwipe(int var1, int var2);
    }

    public static interface OnItemMoveListener
    extends OnActionStateListener {
        public void onItemMove(int var1, int var2);
    }

    public static interface OnActionStateListener {
        public void onActionStateChanged(RecyclerView.ViewHolder var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(int var1);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(int var1);
    }

    public static interface OnDeleteCompleteListener {
        public void onDeleteConfirmed();
    }

    public static interface OnUpdateListener {
        public void onUpdateEmptyView(int var1);
    }
}

