/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import eu.davidea.flexibleadapter.SelectableAdapter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public abstract class AnimatorAdapter
extends SelectableAdapter {
    protected static final String TAG = AnimatorAdapter.class.getSimpleName();
    private Interpolator mInterpolator = new LinearInterpolator();
    private AnimatorAdapterDataObserver mAnimatorNotifierObserver;
    private final SparseArray<Animator> mAnimators = new SparseArray();
    private int mLastAnimatedPosition = -1;
    private int mMaxChildViews = -1;
    private EnumSet<AnimatorEnum> animatorsUsed = EnumSet.noneOf(AnimatorEnum.class);
    private boolean isReverseEnabled = false;
    private boolean shouldAnimate = true;
    private boolean isFastScroll = false;
    private boolean isInitialize = false;
    private long mInitialDelay = 0L;
    private long mStepDelay = 100L;
    private long mDuration = 300L;

    public AnimatorAdapter() {
        this.mAnimatorNotifierObserver = new AnimatorAdapterDataObserver();
        this.registerAdapterDataObserver(this.mAnimatorNotifierObserver);
    }

    void setInitialize(boolean initialize) {
        this.isInitialize = initialize;
    }

    public AnimatorAdapter setAnimationInitialDelay(long initialDelay) {
        this.mInitialDelay = initialDelay;
        return this;
    }

    public AnimatorAdapter setAnimationDelay(@IntRange(from=0L) long delay) {
        this.mStepDelay = delay;
        return this;
    }

    public AnimatorAdapter setAnimationDuration(@IntRange(from=1L) long duration) {
        this.mDuration = duration;
        return this;
    }

    public AnimatorAdapter setAnimationInterpolator(@NonNull Interpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public void setAnimationStartPosition(@IntRange(from=0L) int start) {
        this.mLastAnimatedPosition = start;
    }

    public AnimatorAdapter setAnimationOnScrolling(boolean enabled) {
        this.shouldAnimate = enabled;
        return this;
    }

    public boolean isAnimationOnScrollingEnabled() {
        return this.shouldAnimate;
    }

    public AnimatorAdapter setAnimationOnReverseScrolling(boolean enabled) {
        this.isReverseEnabled = enabled;
        return this;
    }

    public boolean isAnimationOnReverseScrolling() {
        return this.isReverseEnabled;
    }

    @Override
    public void onFastScrollerStateChange(boolean scrolling) {
        super.onFastScrollerStateChange(scrolling);
        this.isFastScroll = scrolling;
    }

    public List<Animator> getAnimators(View itemView, int position, boolean isSelected) {
        return new ArrayList<Animator>();
    }

    private void cancelExistingAnimation(@NonNull View itemView) {
        int hashCode = itemView.hashCode();
        Animator animator = (Animator)this.mAnimators.get(hashCode);
        if (animator != null) {
            animator.end();
        }
    }

    public final void animateView(View itemView, int position, boolean isSelected) {
        if (this.shouldAnimate && !this.isFastScroll && !this.mAnimatorNotifierObserver.isPositionNotified() && (this.isReverseEnabled || position > this.mLastAnimatedPosition || position == 0 && this.mRecyclerView.getChildCount() == 0)) {
            this.cancelExistingAnimation(itemView);
            List<Animator> animators = this.getAnimators(itemView, position, isSelected);
            ViewCompat.setAlpha((View)itemView, (float)0.0f);
            if (!this.animatorsUsed.contains((Object)AnimatorEnum.ALPHA)) {
                this.addAlphaAnimator(animators, itemView, 0.0f);
            }
            this.animatorsUsed.clear();
            AnimatorSet set = new AnimatorSet();
            set.playTogether(animators);
            set.setStartDelay(this.calculateAnimationDelay2(position));
            set.setInterpolator((TimeInterpolator)this.mInterpolator);
            set.setDuration(this.mDuration);
            set.addListener((Animator.AnimatorListener)new HelperAnimatorListener(itemView.hashCode()));
            set.start();
            this.mAnimators.put(itemView.hashCode(), (Object)set);
        }
        if (this.mAnimatorNotifierObserver.isPositionNotified()) {
            this.mAnimatorNotifierObserver.clearNotified();
        }
        this.mLastAnimatedPosition = position;
    }

    private long calculateAnimationDelay1(int position) {
        int visibleItems;
        int firstVisiblePosition;
        int lastVisiblePosition;
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayout = (LinearLayoutManager)layoutManager;
            lastVisiblePosition = linearLayout.findLastCompletelyVisibleItemPosition();
            firstVisiblePosition = linearLayout.findFirstCompletelyVisibleItemPosition();
        } else {
            StaggeredGridLayoutManager staggeredGridLayout = (StaggeredGridLayoutManager)layoutManager;
            lastVisiblePosition = staggeredGridLayout.findLastCompletelyVisibleItemPositions(null)[0];
            firstVisiblePosition = staggeredGridLayout.findFirstCompletelyVisibleItemPositions(null)[0];
        }
        if (this.mMaxChildViews < this.mRecyclerView.getChildCount()) {
            this.mMaxChildViews = this.mRecyclerView.getChildCount();
        }
        if (this.mLastAnimatedPosition > lastVisiblePosition) {
            lastVisiblePosition = this.mLastAnimatedPosition;
        }
        if (this.mLastAnimatedPosition > (visibleItems = lastVisiblePosition - firstVisiblePosition) || firstVisiblePosition > 1 && firstVisiblePosition <= this.mMaxChildViews) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Reset AnimationDelay on position " + position));
            }
            this.mInitialDelay = 0L;
        }
        return this.mInitialDelay += this.mStepDelay;
    }

    private long calculateAnimationDelay2(int position) {
        long delay;
        int firstVisiblePosition;
        int lastVisiblePosition;
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayout = (LinearLayoutManager)layoutManager;
            lastVisiblePosition = linearLayout.findLastCompletelyVisibleItemPosition();
            firstVisiblePosition = linearLayout.findFirstCompletelyVisibleItemPosition();
        } else {
            StaggeredGridLayoutManager staggeredGridLayout = (StaggeredGridLayoutManager)layoutManager;
            lastVisiblePosition = staggeredGridLayout.findLastCompletelyVisibleItemPositions(null)[0];
            firstVisiblePosition = staggeredGridLayout.findFirstCompletelyVisibleItemPositions(null)[0];
        }
        if (this.mLastAnimatedPosition > lastVisiblePosition) {
            lastVisiblePosition = this.mLastAnimatedPosition;
        }
        int numberOfItemsOnScreen = lastVisiblePosition - firstVisiblePosition;
        int numberOfAnimatedItems = position - 1;
        if (this.mMaxChildViews < this.mRecyclerView.getChildCount()) {
            this.mMaxChildViews = this.mRecyclerView.getChildCount();
        }
        if (numberOfItemsOnScreen == 0 || numberOfItemsOnScreen < numberOfAnimatedItems || firstVisiblePosition > 1 && firstVisiblePosition <= this.mMaxChildViews || position > this.mMaxChildViews && firstVisiblePosition == -1 && this.mRecyclerView.getChildCount() == 0) {
            delay = this.mStepDelay;
            if (numberOfItemsOnScreen <= 1) {
                delay += this.mInitialDelay;
            } else {
                this.mInitialDelay = 0L;
            }
            if (this.mRecyclerView.getLayoutManager() instanceof GridLayoutManager) {
                int numColumns = ((GridLayoutManager)this.mRecyclerView.getLayoutManager()).getSpanCount();
                delay = this.mInitialDelay + this.mStepDelay * (long)(position % numColumns);
            }
        } else {
            delay = this.mInitialDelay + (long)position * this.mStepDelay;
        }
        return delay;
    }

    private void addAlphaAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float alphaFrom) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.ALPHA)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaFrom, 1.0f}));
        this.animatorsUsed.add(AnimatorEnum.ALPHA);
    }

    public void addSlideInFromLeftAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float percent) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)(-this.mRecyclerView.getLayoutManager().getWidth()) * percent, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_LEFT);
    }

    public void addSlideInFromRightAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float percent) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)this.mRecyclerView.getLayoutManager().getWidth() * percent, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_RIGHT);
    }

    public void addSlideInFromTopAnimator(@NonNull List<Animator> animators, @NonNull View view) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{-this.mRecyclerView.getMeasuredHeight() >> 1, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_TOP);
    }

    public void addSlideInFromBottomAnimator(@NonNull List<Animator> animators, @NonNull View view) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_LEFT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_RIGHT) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_TOP) || this.animatorsUsed.contains((Object)AnimatorEnum.SLIDE_IN_BOTTOM)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{this.mRecyclerView.getMeasuredHeight() >> 1, 0.0f}));
        this.animatorsUsed.add(AnimatorEnum.SLIDE_IN_BOTTOM);
    }

    public void addScaleInAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float scaleFrom) {
        if (this.animatorsUsed.contains((Object)AnimatorEnum.SCALE)) {
            return;
        }
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scaleFrom, 1.0f}));
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scaleFrom, 1.0f}));
        this.animatorsUsed.add(AnimatorEnum.SCALE);
    }

    private class HelperAnimatorListener
    implements Animator.AnimatorListener {
        int key;

        HelperAnimatorListener(int key) {
            this.key = key;
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimatorAdapter.this.mAnimators.remove(this.key);
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private class AnimatorAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private boolean isNotified;
        private Handler mAnimatorHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (SelectableAdapter.DEBUG) {
                    Log.v((String)TAG, (String)"Clear notified for binding Animations");
                }
                AnimatorAdapterDataObserver.this.isNotified = false;
                return true;
            }
        });

        private AnimatorAdapterDataObserver() {
        }

        public boolean isPositionNotified() {
            return this.isNotified;
        }

        public void clearNotified() {
            this.mAnimatorHandler.removeCallbacksAndMessages(null);
            this.mAnimatorHandler.sendMessageDelayed(Message.obtain((Handler)this.mAnimatorHandler), 200L);
        }

        private void markNotified() {
            this.isNotified = !AnimatorAdapter.this.isInitialize;
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.markNotified();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.markNotified();
        }
    }

    private static enum AnimatorEnum {
        ALPHA,
        SLIDE_IN_LEFT,
        SLIDE_IN_RIGHT,
        SLIDE_IN_BOTTOM,
        SLIDE_IN_TOP,
        SCALE;

    }
}

