/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.widget.TextView;
import java.util.Locale;

public final class Utils {
    public static int INVALID_COLOR;
    private static int colorAccent;

    public static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static void setHighlightText(Context context, TextView textView, String originalText, String constraint, int defColor) {
        Spannable spanText = Spannable.Factory.getInstance().newSpannable((CharSequence)originalText);
        int i = originalText.toLowerCase(Locale.getDefault()).indexOf(constraint);
        if (i != -1) {
            spanText.setSpan((Object)new ForegroundColorSpan(Utils.fetchAccentColor(context, defColor)), i, i + constraint.length(), 33);
            spanText.setSpan((Object)new StyleSpan(1), i, i + constraint.length(), 33);
            textView.setText((CharSequence)spanText, TextView.BufferType.SPANNABLE);
        } else {
            textView.setText((CharSequence)originalText, TextView.BufferType.NORMAL);
        }
    }

    public static void resetAccentColor() {
        colorAccent = INVALID_COLOR;
    }

    @TargetApi(value=21)
    public static int fetchAccentColor(Context context, int defColor) {
        if (colorAccent == INVALID_COLOR) {
            if (Utils.hasLollipop()) {
                TypedArray androidAttr = context.getTheme().obtainStyledAttributes(new int[]{16843829});
                colorAccent = androidAttr.getColor(0, defColor);
                androidAttr.recycle();
            } else {
                colorAccent = defColor;
            }
        }
        return colorAccent;
    }

    public static int dpToPx(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return Math.round(dp * scale);
    }

    static {
        colorAccent = INVALID_COLOR = -1;
    }
}

