/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.graphics.Canvas;
import android.support.annotation.FloatRange;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;

public class ItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    private static final float ALPHA_FULL = 1.0f;
    private AdapterCallback mItemTouchCallback;
    private boolean mIsLongPressDragEnabled = false;
    private boolean mIsSwipeEnabled = false;
    private float mSwipeThreshold = 1.0f;
    private int mSwipeFlags = 48;

    public ItemTouchHelperCallback(AdapterCallback itemTouchCallback) {
        this.mItemTouchCallback = itemTouchCallback;
    }

    public void setLongPressDragEnabled(boolean isLongPressDragEnabled) {
        this.mIsLongPressDragEnabled = isLongPressDragEnabled;
    }

    public boolean isLongPressDragEnabled() {
        return this.mIsLongPressDragEnabled;
    }

    public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
        return super.canDropOver(recyclerView, current, target);
    }

    public void setSwipeEnabled(boolean isSwipeEnabled) {
        this.mIsSwipeEnabled = isSwipeEnabled;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.mIsSwipeEnabled;
    }

    public void setSwipeThreshold(@FloatRange(from=0.0, to=1.0) float threshold) {
        this.mSwipeThreshold = threshold;
    }

    public void setSwipeFlags(int swipeFlags) {
        this.mSwipeFlags = swipeFlags;
    }

    public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
        return this.mSwipeThreshold;
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        if (!this.mItemTouchCallback.shouldMove(viewHolder.getAdapterPosition(), target.getAdapterPosition())) {
            return false;
        }
        this.mItemTouchCallback.onItemMove(viewHolder.getAdapterPosition(), target.getAdapterPosition());
        return true;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        this.mItemTouchCallback.onItemSwiped(viewHolder.getAdapterPosition(), direction);
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            int dragFlags = 15;
            boolean swipeFlags = false;
            return ItemTouchHelperCallback.makeMovementFlags((int)15, (int)0);
        }
        int dragFlags = 3;
        int swipeFlags = this.mSwipeFlags;
        return ItemTouchHelperCallback.makeMovementFlags((int)3, (int)swipeFlags);
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != 0 && viewHolder instanceof ViewHolderCallback) {
            ViewHolderCallback viewHolderCallback = (ViewHolderCallback)viewHolder;
            viewHolderCallback.onActionStateChanged(viewHolder.getAdapterPosition(), actionState);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        viewHolder.itemView.setAlpha(1.0f);
        if (viewHolder instanceof ViewHolderCallback) {
            ViewHolderCallback viewHolderCallback = (ViewHolderCallback)viewHolder;
            viewHolderCallback.onItemReleased(viewHolder.getAdapterPosition());
        }
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    public void onChildDrawOver(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDrawOver(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    public static interface ViewHolderCallback {
        public void onActionStateChanged(int var1, int var2);

        public void onItemReleased(int var1);
    }

    public static interface AdapterCallback {
        public boolean shouldMove(int var1, int var2);

        public boolean onItemMove(int var1, int var2);

        public void onItemSwiped(int var1, int var2);
    }
}

