/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.content.Context;
import android.graphics.PointF;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;

public class SmoothScrollLinearLayoutManager
extends LinearLayoutManager {
    private static final float MILLISECONDS_PER_INCH = 100.0f;

    public SmoothScrollLinearLayoutManager(Context context) {
        this(context, 1, false);
    }

    public SmoothScrollLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        TopSnappedSmoothScroller smoothScroller = new TopSnappedSmoothScroller(recyclerView.getContext()){

            @Override
            public PointF computeScrollVectorForPosition(int targetPosition) {
                return new PointF(0.0f, 1.0f);
            }

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return 100.0f / (float)displayMetrics.densityDpi;
            }
        };
        smoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
    }

    private class TopSnappedSmoothScroller
    extends LinearSmoothScroller {
        public TopSnappedSmoothScroller(Context context) {
            super(context);
        }

        public PointF computeScrollVectorForPosition(int targetPosition) {
            return SmoothScrollLinearLayoutManager.this.computeScrollVectorForPosition(targetPosition);
        }

        protected int getVerticalSnapPreference() {
            return -1;
        }
    }
}

