/*
 * Decompiled with CFR 0.152.
 */
package eu.chargetime.ocpp;

import eu.chargetime.ocpp.Communicator;
import eu.chargetime.ocpp.model.Confirmation;
import java.util.function.BiConsumer;

class ConfirmationHandler
implements BiConsumer<Confirmation, Throwable> {
    private String id;
    private String action;
    private Communicator communicator;

    public ConfirmationHandler(String id, String action, Communicator communicator) {
        this.id = id;
        this.action = action;
        this.communicator = communicator;
    }

    @Override
    public void accept(Confirmation confirmation, Throwable throwable) {
        if (throwable != null) {
            this.communicator.sendCallError(this.id, this.action, "InternalError", "An internal error occurred and the receiver was not able to process the requested Action successfully");
        } else if (confirmation == null) {
            this.communicator.sendCallError(this.id, this.action, "NotSupported", "Requested Action is recognized but not supported by the receiver");
        } else {
            this.communicator.sendCallResult(this.id, this.action, confirmation);
        }
    }
}

