/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.wicket.breadcrumb;

import eu.cedarsoft.commons.struct.Node;
import eu.cedarsoft.commons.struct.Path;
import eu.cedarsoft.commons.struct.Route;
import eu.cedarsoft.wicket.breadcrumb.BreadCrumbElement;
import eu.cedarsoft.wicket.breadcrumb.PageStructureProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadCrumbElementProvider
implements IDataProvider {
    private static final long serialVersionUID = 4683740027859662761L;
    private final PageStructureProvider pageStructureProvider;
    @NotNull
    private final IModel pathModel;
    private transient Route route;

    public BreadCrumbElementProvider(@NotNull PageStructureProvider pageStructureProvider, @NotNull IModel pathModel) {
        this.pageStructureProvider = pageStructureProvider;
        this.pathModel = pathModel;
    }

    @NotNull
    public Path getPath() {
        return (Path)this.pathModel.getObject();
    }

    @NotNull
    public synchronized Route getRoute() {
        if (this.route == null) {
            try {
                this.route = this.pageStructureProvider.getPageStructure().getRoute(this.getPath());
            }
            catch (Exception ignore) {
                this.route = new Route(Collections.singletonList(this.pageStructureProvider.getPageStructure().getRootNode()));
            }
        }
        return this.route;
    }

    @NotNull
    public Iterator<?> iterator(int first, int count) {
        return this.getRoute().getNodes().subList(first, first + count).iterator();
    }

    public int size() {
        return this.getRoute().getNodes().size();
    }

    public IModel model(Object object) {
        Node node = (Node)object;
        Class pageClass = (Class)node.getLookup().lookup(Class.class);
        if (pageClass == null) {
            throw new IllegalStateException("No page class found");
        }
        return new Model((Serializable)new BreadCrumbElement(node.getName(), pageClass));
    }

    public synchronized void detach() {
        this.route = null;
    }
}

