package eu.cedarsoft.wicket.contact;

import org.apache.wicket.markup.html.panel.Panel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/**
 * This component shows a formular which can be used to send an email
 */
public abstract class ContactComponent extends Panel {
  protected ContactComponent( @NotNull @NonNls String id, @NotNull @NonNls final String mail ) {
    super( id );
    add( new ContactForm( "contactForm" ) {
      @Override
      protected void onSubmit() {
        super.onSubmit();

        FormData formData = getFormData();
        sendMail( formData, mail );
        clearInput();
      }
    } );
  }

  protected abstract void sendMail( @NotNull ContactForm.FormData formData, @NotNull @NonNls String mail );
}
