package eu.cedarsoft.wicket.buttons;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.StyleSheetReference;
import eu.cedarsoft.wicket.WicketConstants;

/**
 * <p/>
 * Date: May 24, 2007<br>
 * Time: 9:05:17 PM<br>
 */
public class SexyButton extends Panel {
  /**
   * Creates a new sexy button
   *
   * @param id    the id
   * @param link  the link (with ID "link")
   * @param label the label of the button
   */
  public SexyButton( @NotNull @NonNls String id, @NotNull String label, @NotNull Link link ) {
    super( id );

    if ( !link.getId().equals( "link" ) ) {
      throw new IllegalArgumentException( "Link must have ID \"link\"" );
    }

    add( new StyleSheetReference( WicketConstants.ID_STYLE_SHEET, SexyButton.class, "SexyButton.css" ) );
    add( link );
    link.add( new Label( "label", label ) );
  }
}
