package eu.cedarsoft.utils;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.util.zip.ZipEntry;

/**
 * <p/>
 * Date: Jun 22, 2007<br>
 * Time: 11:04:05 AM<br>
 */
public class PathBasedClassFielCondition implements ZipExtractor.Condition {
  @NotNull
  @NonNls
  private String pathPrefix;

  public PathBasedClassFielCondition( @NotNull @NonNls String pathPrefix ) {
    this.pathPrefix = pathPrefix;
  }

  public boolean shallExtract( @NotNull ZipEntry zipEntry ) {
    return zipEntry.getName().startsWith( pathPrefix ) && zipEntry.getName().endsWith( ".class" );
  }
}
