/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.subscaleview.decoder;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import es.voghdev.pdfviewpager.library.subscaleview.SubsamplingScaleImageView;
import es.voghdev.pdfviewpager.library.subscaleview.decoder.ImageRegionDecoder;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public class SkiaPooledImageRegionDecoder
implements ImageRegionDecoder {
    private static final String TAG = SkiaPooledImageRegionDecoder.class.getSimpleName();
    private static boolean debug = false;
    private DecoderPool decoderPool = new DecoderPool();
    private final ReadWriteLock decoderLock = new ReentrantReadWriteLock(true);
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private final Bitmap.Config bitmapConfig;
    private Context context;
    private Uri uri;
    private long fileLength = Long.MAX_VALUE;
    private final Point imageDimensions = new Point(0, 0);
    private final AtomicBoolean lazyInited = new AtomicBoolean(false);

    @Keep
    public SkiaPooledImageRegionDecoder() {
        this(null);
    }

    public SkiaPooledImageRegionDecoder(@Nullable Bitmap.Config bitmapConfig) {
        Bitmap.Config globalBitmapConfig = SubsamplingScaleImageView.getPreferredBitmapConfig();
        this.bitmapConfig = bitmapConfig != null ? bitmapConfig : (globalBitmapConfig != null ? globalBitmapConfig : Bitmap.Config.RGB_565);
    }

    @Keep
    public static void setDebug(boolean debug) {
        SkiaPooledImageRegionDecoder.debug = debug;
    }

    @Override
    @NonNull
    public Point init(Context context, @NonNull Uri uri) throws Exception {
        this.context = context;
        this.uri = uri;
        this.initialiseDecoder();
        return this.imageDimensions;
    }

    private void lazyInit() {
        if (this.lazyInited.compareAndSet(false, true) && this.fileLength < Long.MAX_VALUE) {
            this.debug("Starting lazy init of additional decoders");
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (SkiaPooledImageRegionDecoder.this.decoderPool != null && SkiaPooledImageRegionDecoder.this.allowAdditionalDecoder(SkiaPooledImageRegionDecoder.this.decoderPool.size(), SkiaPooledImageRegionDecoder.this.fileLength)) {
                        try {
                            if (SkiaPooledImageRegionDecoder.this.decoderPool == null) continue;
                            long start = System.currentTimeMillis();
                            SkiaPooledImageRegionDecoder.this.debug("Starting decoder");
                            SkiaPooledImageRegionDecoder.this.initialiseDecoder();
                            long end = System.currentTimeMillis();
                            SkiaPooledImageRegionDecoder.this.debug("Started decoder, took " + (end - start) + "ms");
                        }
                        catch (Exception e) {
                            SkiaPooledImageRegionDecoder.this.debug("Failed to start decoder: " + e.getMessage());
                        }
                    }
                }
            };
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseDecoder() throws Exception {
        BitmapRegionDecoder decoder;
        String uriString = this.uri.toString();
        long fileLength = Long.MAX_VALUE;
        if (uriString.startsWith(RESOURCE_PREFIX)) {
            Resources res;
            String packageName = this.uri.getAuthority();
            if (this.context.getPackageName().equals(packageName)) {
                res = this.context.getResources();
            } else {
                PackageManager pm = this.context.getPackageManager();
                res = pm.getResourcesForApplication(packageName);
            }
            int id2 = 0;
            List segments = this.uri.getPathSegments();
            int size = segments.size();
            if (size == 2 && ((String)segments.get(0)).equals("drawable")) {
                String resName = (String)segments.get(1);
                id2 = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id2 = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException resName) {
                    // empty catch block
                }
            }
            try {
                AssetFileDescriptor descriptor = this.context.getResources().openRawResourceFd(id2);
                fileLength = descriptor.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
            decoder = BitmapRegionDecoder.newInstance((InputStream)this.context.getResources().openRawResource(id2), (boolean)false);
        } else if (uriString.startsWith(ASSET_PREFIX)) {
            String assetName = uriString.substring(ASSET_PREFIX.length());
            try {
                AssetFileDescriptor descriptor = this.context.getAssets().openFd(assetName);
                fileLength = descriptor.getLength();
            }
            catch (Exception descriptor) {
                // empty catch block
            }
            decoder = BitmapRegionDecoder.newInstance((InputStream)this.context.getAssets().open(assetName, 1), (boolean)false);
        } else if (uriString.startsWith(FILE_PREFIX)) {
            decoder = BitmapRegionDecoder.newInstance((String)uriString.substring(FILE_PREFIX.length()), (boolean)false);
            try {
                File file = new File(uriString);
                if (file.exists()) {
                    fileLength = file.length();
                }
            }
            catch (Exception file) {}
        } else {
            InputStream inputStream = null;
            try {
                ContentResolver contentResolver = this.context.getContentResolver();
                inputStream = contentResolver.openInputStream(this.uri);
                decoder = BitmapRegionDecoder.newInstance((InputStream)inputStream, (boolean)false);
                try {
                    AssetFileDescriptor descriptor = contentResolver.openAssetFileDescriptor(this.uri, "r");
                    if (descriptor != null) {
                        fileLength = descriptor.getLength();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.fileLength = fileLength;
        this.imageDimensions.set(decoder.getWidth(), decoder.getHeight());
        this.decoderLock.writeLock().lock();
        try {
            if (this.decoderPool != null) {
                this.decoderPool.add(decoder);
            }
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Bitmap decodeRegion(@NonNull Rect sRect, int sampleSize) {
        this.debug("Decode region " + sRect + " on thread " + Thread.currentThread().getName());
        if (sRect.width() < this.imageDimensions.x || sRect.height() < this.imageDimensions.y) {
            this.lazyInit();
        }
        this.decoderLock.readLock().lock();
        try {
            if (this.decoderPool != null) {
                BitmapRegionDecoder decoder = this.decoderPool.acquire();
                try {
                    if (decoder != null && !decoder.isRecycled()) {
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inSampleSize = sampleSize;
                        options.inPreferredConfig = this.bitmapConfig;
                        Bitmap bitmap = decoder.decodeRegion(sRect, options);
                        if (bitmap == null) {
                            throw new RuntimeException("null bitmap - image format may not be supported");
                        }
                        Bitmap bitmap2 = bitmap;
                        return bitmap2;
                    }
                }
                finally {
                    if (decoder != null) {
                        this.decoderPool.release(decoder);
                    }
                }
            }
            throw new IllegalStateException("Cannot decode region after decoder has been recycled");
        }
        finally {
            this.decoderLock.readLock().unlock();
        }
    }

    @Override
    public synchronized boolean isReady() {
        return this.decoderPool != null && !this.decoderPool.isEmpty();
    }

    @Override
    public synchronized void recycle() {
        this.decoderLock.writeLock().lock();
        try {
            if (this.decoderPool != null) {
                this.decoderPool.recycle();
                this.decoderPool = null;
                this.context = null;
                this.uri = null;
            }
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    protected boolean allowAdditionalDecoder(int numberOfDecoders, long fileLength) {
        if (numberOfDecoders >= 4) {
            this.debug("No additional decoders allowed, reached hard limit (4)");
            return false;
        }
        if ((long)numberOfDecoders * fileLength > 0x1400000L) {
            this.debug("No additional encoders allowed, reached hard memory limit (20Mb)");
            return false;
        }
        if (numberOfDecoders >= this.getNumberOfCores()) {
            this.debug("No additional encoders allowed, limited by CPU cores (" + this.getNumberOfCores() + ")");
            return false;
        }
        if (this.isLowMemory()) {
            this.debug("No additional encoders allowed, memory is low");
            return false;
        }
        this.debug("Additional decoder allowed, current count is " + numberOfDecoders + ", estimated native memory " + fileLength * (long)numberOfDecoders / 0x100000L + "Mb");
        return true;
    }

    private int getNumberOfCores() {
        if (Build.VERSION.SDK_INT >= 17) {
            return Runtime.getRuntime().availableProcessors();
        }
        return this.getNumCoresOldPhones();
    }

    private int getNumCoresOldPhones() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]+", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            return files.length;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private boolean isLowMemory() {
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        if (activityManager != null) {
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            return memoryInfo.lowMemory;
        }
        return true;
    }

    private void debug(String message) {
        if (debug) {
            Log.d((String)TAG, (String)message);
        }
    }

    private static class DecoderPool {
        private final Semaphore available = new Semaphore(0, true);
        private final Map<BitmapRegionDecoder, Boolean> decoders = new ConcurrentHashMap<BitmapRegionDecoder, Boolean>();

        private DecoderPool() {
        }

        private synchronized boolean isEmpty() {
            return this.decoders.isEmpty();
        }

        private synchronized int size() {
            return this.decoders.size();
        }

        private BitmapRegionDecoder acquire() {
            this.available.acquireUninterruptibly();
            return this.getNextAvailable();
        }

        private void release(BitmapRegionDecoder decoder) {
            if (this.markAsUnused(decoder)) {
                this.available.release();
            }
        }

        private synchronized void add(BitmapRegionDecoder decoder) {
            this.decoders.put(decoder, false);
            this.available.release();
        }

        private synchronized void recycle() {
            while (!this.decoders.isEmpty()) {
                BitmapRegionDecoder decoder = this.acquire();
                decoder.recycle();
                this.decoders.remove(decoder);
            }
        }

        private synchronized BitmapRegionDecoder getNextAvailable() {
            for (Map.Entry<BitmapRegionDecoder, Boolean> entry : this.decoders.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }

        private synchronized boolean markAsUnused(BitmapRegionDecoder decoder) {
            for (Map.Entry<BitmapRegionDecoder, Boolean> entry : this.decoders.entrySet()) {
                if (decoder != entry.getKey()) continue;
                if (entry.getValue().booleanValue()) {
                    entry.setValue(false);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

