/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.subscaleview.decoder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import es.voghdev.pdfviewpager.library.subscaleview.SubsamplingScaleImageView;
import es.voghdev.pdfviewpager.library.subscaleview.decoder.ImageRegionDecoder;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SkiaImageRegionDecoder
implements ImageRegionDecoder {
    private BitmapRegionDecoder decoder;
    private final ReadWriteLock decoderLock = new ReentrantReadWriteLock(true);
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private final Bitmap.Config bitmapConfig;

    @Keep
    public SkiaImageRegionDecoder() {
        this(null);
    }

    public SkiaImageRegionDecoder(@Nullable Bitmap.Config bitmapConfig) {
        Bitmap.Config globalBitmapConfig = SubsamplingScaleImageView.getPreferredBitmapConfig();
        this.bitmapConfig = bitmapConfig != null ? bitmapConfig : (globalBitmapConfig != null ? globalBitmapConfig : Bitmap.Config.RGB_565);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Point init(Context context, @NonNull Uri uri) throws Exception {
        String uriString = uri.toString();
        if (uriString.startsWith(RESOURCE_PREFIX)) {
            Resources res;
            String packageName = uri.getAuthority();
            if (context.getPackageName().equals(packageName)) {
                res = context.getResources();
            } else {
                PackageManager pm = context.getPackageManager();
                res = pm.getResourcesForApplication(packageName);
            }
            int id2 = 0;
            List segments = uri.getPathSegments();
            int size = segments.size();
            if (size == 2 && ((String)segments.get(0)).equals("drawable")) {
                String resName = (String)segments.get(1);
                id2 = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id2 = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)context.getResources().openRawResource(id2), (boolean)false);
        } else if (uriString.startsWith(ASSET_PREFIX)) {
            String assetName = uriString.substring(ASSET_PREFIX.length());
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)context.getAssets().open(assetName, 1), (boolean)false);
        } else if (uriString.startsWith(FILE_PREFIX)) {
            this.decoder = BitmapRegionDecoder.newInstance((String)uriString.substring(FILE_PREFIX.length()), (boolean)false);
        } else {
            InputStream inputStream = null;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                inputStream = contentResolver.openInputStream(uri);
                this.decoder = BitmapRegionDecoder.newInstance((InputStream)inputStream, (boolean)false);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return new Point(this.decoder.getWidth(), this.decoder.getHeight());
    }

    @Override
    @NonNull
    public Bitmap decodeRegion(@NonNull Rect sRect, int sampleSize) {
        this.getDecodeLock().lock();
        try {
            if (this.decoder != null && !this.decoder.isRecycled()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = sampleSize;
                options.inPreferredConfig = this.bitmapConfig;
                Bitmap bitmap = this.decoder.decodeRegion(sRect, options);
                if (bitmap == null) {
                    throw new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
                }
                Bitmap bitmap2 = bitmap;
                return bitmap2;
            }
            throw new IllegalStateException("Cannot decode region after decoder has been recycled");
        }
        finally {
            this.getDecodeLock().unlock();
        }
    }

    @Override
    public synchronized boolean isReady() {
        return this.decoder != null && !this.decoder.isRecycled();
    }

    @Override
    public synchronized void recycle() {
        this.decoderLock.writeLock().lock();
        try {
            this.decoder.recycle();
            this.decoder = null;
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    private Lock getDecodeLock() {
        if (Build.VERSION.SDK_INT < 21) {
            return this.decoderLock.writeLock();
        }
        return this.decoderLock.readLock();
    }
}

