/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import es.voghdev.pdfviewpager.library.R;
import es.voghdev.pdfviewpager.library.adapter.BitmapContainer;
import es.voghdev.pdfviewpager.library.adapter.PdfRendererParams;
import es.voghdev.pdfviewpager.library.adapter.SimpleBitmapPool;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class BasePDFPagerAdapter
extends PagerAdapter {
    protected static final int FIRST_PAGE = 0;
    protected static final float DEFAULT_QUALITY = 2.0f;
    protected static final int DEFAULT_OFFSCREENSIZE = 1;
    String pdfPath;
    Context context;
    PdfRenderer renderer;
    BitmapContainer bitmapContainer;
    LayoutInflater inflater;
    protected float renderQuality;
    protected int offScreenSize;

    public BasePDFPagerAdapter(Context context, String pdfPath) {
        this.pdfPath = pdfPath;
        this.context = context;
        this.renderQuality = 2.0f;
        this.offScreenSize = 1;
        this.init();
    }

    public BasePDFPagerAdapter(Context context, String pdfPath, int offScreenSize) {
        this.pdfPath = pdfPath;
        this.context = context;
        this.renderQuality = 2.0f;
        this.offScreenSize = offScreenSize;
        this.init();
    }

    protected void init() {
        try {
            this.renderer = new PdfRenderer(this.getSeekableFileDescriptor(this.pdfPath));
            this.inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            PdfRendererParams params = this.extractPdfParamsFromFirstPage(this.renderer, this.renderQuality);
            this.bitmapContainer = new SimpleBitmapPool(params);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private PdfRendererParams extractPdfParamsFromFirstPage(PdfRenderer renderer, float renderQuality) {
        PdfRenderer.Page samplePage = this.getPDFPage(renderer, 0);
        PdfRendererParams params = new PdfRendererParams();
        params.setRenderQuality(renderQuality);
        params.setOffScreenSize(this.offScreenSize);
        params.setWidth((int)((float)samplePage.getWidth() * renderQuality));
        params.setHeight((int)((float)samplePage.getHeight() * renderQuality));
        samplePage.close();
        return params;
    }

    protected ParcelFileDescriptor getSeekableFileDescriptor(String path) throws IOException {
        ParcelFileDescriptor parcelFileDescriptor;
        File pdfCopy = new File(path);
        if (pdfCopy.exists()) {
            ParcelFileDescriptor parcelFileDescriptor2 = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
            return parcelFileDescriptor2;
        }
        if (this.isAnAsset(path)) {
            pdfCopy = new File(this.context.getCacheDir(), path);
            parcelFileDescriptor = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
        } else {
            URI uri = URI.create(String.format("file://%s", path));
            parcelFileDescriptor = this.context.getContentResolver().openFileDescriptor(Uri.parse((String)uri.toString()), "rw");
        }
        return parcelFileDescriptor;
    }

    private boolean isAnAsset(String path) {
        return !path.startsWith("/");
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View v = this.inflater.inflate(R.layout.view_pdf_page, container, false);
        ImageView iv = (ImageView)v.findViewById(R.id.imageView);
        if (this.renderer == null || this.getCount() < position) {
            return v;
        }
        PdfRenderer.Page page = this.getPDFPage(this.renderer, position);
        Bitmap bitmap = this.bitmapContainer.get(position);
        page.render(bitmap, null, null, 1);
        page.close();
        iv.setImageBitmap(bitmap);
        ((ViewPager)container).addView(v, 0);
        return v;
    }

    protected PdfRenderer.Page getPDFPage(PdfRenderer renderer, int position) {
        return renderer.openPage(position);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
    }

    public void close() {
        this.releaseAllBitmaps();
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    protected void releaseAllBitmaps() {
        if (this.bitmapContainer != null) {
            this.bitmapContainer.clear();
        }
    }

    public int getCount() {
        return this.renderer != null ? this.renderer.getPageCount() : 0;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == (View)object;
    }
}

