/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.graphics.pdf.PdfRenderer;
import android.support.v4.view.ViewPager;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import es.voghdev.pdfviewpager.library.R;
import es.voghdev.pdfviewpager.library.adapter.BasePDFPagerAdapter;
import es.voghdev.pdfviewpager.library.adapter.PdfScale;
import java.lang.ref.WeakReference;
import uk.co.senab.photoview.PhotoViewAttacher;

public class PDFPagerAdapter
extends BasePDFPagerAdapter
implements PhotoViewAttacher.OnMatrixChangedListener {
    SparseArray<WeakReference<PhotoViewAttacher>> attachers;
    PdfScale scale = new PdfScale();

    public PDFPagerAdapter(Context context, String pdfPath) {
        super(context, pdfPath);
        this.attachers = new SparseArray();
    }

    public PDFPagerAdapter(Context context, String pdfPath, int offScreenSize) {
        super(context, pdfPath, offScreenSize);
        this.attachers = new SparseArray();
    }

    public PDFPagerAdapter(Context context, String pdfPath, PdfScale scale) {
        super(context, pdfPath);
        this.attachers = new SparseArray();
        this.scale = scale;
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View v = this.inflater.inflate(R.layout.view_pdf_page, container, false);
        ImageView iv = (ImageView)v.findViewById(R.id.imageView);
        if (this.renderer == null || this.getCount() < position) {
            return v;
        }
        PdfRenderer.Page page = this.getPDFPage(this.renderer, position);
        Bitmap bitmap = this.bitmapContainer.get(position);
        page.render(bitmap, null, null, 1);
        page.close();
        PhotoViewAttacher attacher = new PhotoViewAttacher(iv);
        attacher.setScale(this.scale.getScale(), this.scale.getCenterX(), this.scale.getCenterY(), true);
        attacher.setOnMatrixChangeListener((PhotoViewAttacher.OnMatrixChangedListener)this);
        this.attachers.put(position, new WeakReference<PhotoViewAttacher>(attacher));
        iv.setImageBitmap(bitmap);
        attacher.update();
        ((ViewPager)container).addView(v, 0);
        return v;
    }

    @Override
    public void close() {
        super.close();
        if (this.attachers != null) {
            this.attachers.clear();
            this.attachers = null;
        }
    }

    public void onMatrixChanged(RectF rect) {
        if (this.scale.getScale() != 1.0f) {
            // empty if block
        }
    }
}

