/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import es.voghdev.pdfviewpager.library.R;
import es.voghdev.pdfviewpager.library.remote.DownloadFile;
import es.voghdev.pdfviewpager.library.remote.DownloadFileUrlConnectionImpl;

public class LegacyPDFView
extends LinearLayout
implements DownloadFile.Listener {
    TextView textView;
    ProgressBar progressBar;
    Button button;
    DownloadFile downloadFile;

    public LegacyPDFView(Context context) {
        super(context);
        this.init(null);
    }

    public LegacyPDFView(Context context, DownloadFile downloadFile) {
        super(context);
        this.downloadFile = downloadFile;
        this.init(null);
    }

    public LegacyPDFView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LegacyPDFView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        View v = LegacyPDFView.inflate((Context)this.getContext(), (int)this.getLayoutId(), (ViewGroup)this);
        if (this.viewFound(v, R.id.legacy_pdf_textView)) {
            this.textView = (TextView)v.findViewById(R.id.legacy_pdf_textView);
        }
        if (this.viewFound(v, R.id.legacy_pdf_button)) {
            this.button = (Button)v.findViewById(R.id.legacy_pdf_button);
        }
        if (this.viewFound(v, R.id.legacy_pdf_progressBar)) {
            this.progressBar = (ProgressBar)v.findViewById(R.id.legacy_pdf_progressBar);
        }
        if (this.downloadFile == null) {
            this.downloadFile = new DownloadFileUrlConnectionImpl(this.getContext(), new Handler(), this);
        }
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LegacyPDFView);
            a.recycle();
        }
    }

    protected boolean viewFound(View root, int id2) {
        return root.findViewById(id2) != null;
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.getButton().setOnClickListener(l);
    }

    public int getMax() {
        return this.getProgressBar().getMax();
    }

    public void setMax(int max) {
        this.getProgressBar().setMax(max);
    }

    public void setProgress(int progress) {
        this.getProgressBar().setProgress(progress);
    }

    public void setText(String text) {
        this.getTextView().setText((CharSequence)text);
    }

    public void setText(int resId) {
        this.getTextView().setText(resId);
    }

    protected int getLayoutId() {
        return R.layout.view_legacy_pdf;
    }

    protected TextView getTextView() {
        return this.textView;
    }

    protected ProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected Button getButton() {
        return this.button;
    }

    @Override
    public void onSuccess(String url, String destinationPath) {
    }

    @Override
    public void onFailure(Exception e) {
    }

    @Override
    public void onProgressUpdate(int progress, int total) {
        if (this.getMax() != total) {
            this.setMax(total);
        }
        this.setProgress(progress);
    }
}

