/*
 * Decompiled with CFR 0.152.
 */
package es.sdos.customlogger.util;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0015J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Les/sdos/customlogger/util/CustomTimingLogger;", "", "tag", "", "label", "(Ljava/lang/String;Ljava/lang/String;)V", "mDisabled", "", "mLabel", "mSplitLabels", "", "getMSplitLabels", "()Ljava/util/List;", "setMSplitLabels", "(Ljava/util/List;)V", "mSplits", "", "getMSplits", "setMSplits", "mTag", "addSplit", "", "splitLabel", "dumpToLog", "reset", "customlogger_release"})
public final class CustomTimingLogger {
    private String mTag;
    private String mLabel;
    private boolean mDisabled;
    @NotNull
    private List<Long> mSplits;
    @NotNull
    private List<String> mSplitLabels;

    @NotNull
    public final List<Long> getMSplits() {
        return this.mSplits;
    }

    public final void setMSplits(@NotNull List<Long> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.mSplits = list;
    }

    @NotNull
    public final List<String> getMSplitLabels() {
        return this.mSplitLabels;
    }

    public final void setMSplitLabels(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.mSplitLabels = list;
    }

    public final void reset(@NotNull String tag, @NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.mTag = tag;
        this.mLabel = label;
        this.reset();
    }

    public final void reset() {
        this.mDisabled = true;
        if (this.mDisabled) {
            return;
        }
        this.mSplits.clear();
        this.mSplitLabels.clear();
        this.addSplit(null);
    }

    public final void addSplit(@Nullable String splitLabel) {
        if (this.mDisabled) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        this.mSplits.add(now);
        this.mSplitLabels.add(splitLabel);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpToLog() {
        long first;
        if (this.mDisabled) {
            return "Debug disable";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Start: ").append("\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = this.mLabel;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        Log.d((String)this.mTag, (String)stringBuilder2.append(string2).append(": begin").toString());
        long now = first = ((Number)this.mSplits.get(0)).longValue();
        int n = 1;
        int n2 = this.mSplits.size();
        while (n < n2) {
            void i;
            now = ((Number)this.mSplits.get((int)i)).longValue();
            String splitLabel = this.mSplitLabels.get((int)i);
            long prev = ((Number)this.mSplits.get((int)(i - true))).longValue();
            stringBuilder.append(this.mTag + ": " + this.mLabel + ":      " + (now - prev) + " ms, " + splitLabel).append("\n");
            ++i;
        }
        stringBuilder.append(this.mTag + ": " + this.mLabel + ": end, " + (now - first) + " ms");
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"stringBuilder.toString()");
        return string3;
    }

    public CustomTimingLogger(@Nullable String tag, @Nullable String label) {
        List list;
        CustomTimingLogger customTimingLogger = this;
        customTimingLogger.mSplits = list = (List)new ArrayList();
        customTimingLogger = this;
        customTimingLogger.mSplitLabels = list = (List)new ArrayList();
        if (tag != null && label != null) {
            this.reset(tag, label);
        } else {
            this.reset();
        }
    }
}

