/*
 * Decompiled with CFR 0.152.
 */
package es.sandbox.ui.messages.spring.config;

import es.sandbox.ui.messages.Context;
import es.sandbox.ui.messages.Flash;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class FlashMessagesMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlashMessagesMethodArgumentResolver.class);
    private final Context context;

    public FlashMessagesMethodArgumentResolver(Context context) {
        if (context == null) {
            throw new NullPointerException("Context can't be null");
        }
        this.context = context;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Flash.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        LOGGER.trace("Accesing to the messages publisher from the request");
        return this.context.publisher(this.nativeRequest(webRequest));
    }

    private HttpServletRequest nativeRequest(NativeWebRequest webRequest) {
        return (HttpServletRequest)webRequest.getNativeRequest();
    }
}

