/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.utils;

import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import java.lang.reflect.Field;
import java.time.Instant;
import org.apache.commons.lang3.reflect.FieldUtils;

public class PuiMiniAudit {
    public static final String USR_ALTA = "usralta";
    public static final String FEC_ALTA = "fecalta";
    public static final String USR_MODIF = "usrmodif";
    public static final String FEC_MODIF = "fecmodif";

    public static void fillModifyRegistry(IDto oldDto, IDto dto) {
        if (PuiUserSession.getCurrentSession() != null) {
            PuiMiniAudit.fillModifyRegistry(dto, PuiUserSession.getCurrentSession().getUsername());
        }
        PuiMiniAudit.setValue(dto, USR_ALTA, PuiMiniAudit.getValue(oldDto, USR_ALTA));
        PuiMiniAudit.setValue(dto, FEC_ALTA, PuiMiniAudit.getValue(oldDto, FEC_ALTA));
    }

    public static void fillModifyRegistry(IDto dto, String userField, String dateField) {
        String usr = PuiUserSession.getCurrentSession() != null ? PuiUserSession.getCurrentSession().getUsername() : null;
        PuiMiniAudit.fillModifyRegistry(dto, userField, dateField, usr);
    }

    public static void fillModifyRegistry(IDto dto) {
        if (PuiUserSession.getCurrentSession() != null) {
            PuiMiniAudit.fillModifyRegistry(dto, PuiUserSession.getCurrentSession().getUsername());
        }
    }

    public static void fillModifyRegistry(IDto dto, String usrValue) {
        PuiMiniAudit.fillModifyRegistry(dto, USR_MODIF, FEC_MODIF, usrValue);
    }

    public static void fillModifyRegistry(IDto dto, String userField, String dateField, String usrValue) {
        if (usrValue == null) {
            return;
        }
        PuiMiniAudit.setValue(dto, dateField, Instant.now());
        PuiMiniAudit.setValue(dto, userField, usrValue);
    }

    public static void fillNewRegistry(IDto dto) {
        if (PuiUserSession.getCurrentSession() != null) {
            PuiMiniAudit.fillNewRegistry(dto, PuiUserSession.getCurrentSession().getUsername());
        }
    }

    public static void fillNewRegistry(IDto dto, String userField, String dateField) {
        String usr = PuiUserSession.getCurrentSession() != null ? PuiUserSession.getCurrentSession().getUsername() : null;
        PuiMiniAudit.fillModifyRegistry(dto, userField, dateField, usr);
    }

    public static void fillNewRegistry(IDto dto, String usrValue) {
        PuiMiniAudit.fillNewRegistry(dto, USR_ALTA, FEC_ALTA, usrValue);
    }

    public static void fillNewRegistry(IDto dto, String userField, String dateField, String usrValue) {
        if (usrValue == null) {
            return;
        }
        PuiMiniAudit.setValue(dto, dateField, Instant.now());
        PuiMiniAudit.setValue(dto, userField, usrValue);
    }

    private static Object getValue(IDto dto, String fieldName) {
        try {
            Field field = DtoRegistry.getJavaFieldFromFieldName(dto.getClass(), (String)fieldName);
            if (field != null) {
                return FieldUtils.readField((Field)field, (Object)dto, (boolean)true);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setValue(IDto dto, String fieldName, Object value) {
        try {
            Field field = DtoRegistry.getJavaFieldFromFieldName(dto.getClass(), (String)fieldName);
            if (field != null) {
                FieldUtils.writeField((Field)field, (Object)dto, (Object)value, (boolean)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

