/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.spring.configuration;

import es.prodevelop.pui9.classpath.PuiClassLoaderUtils;
import es.prodevelop.pui9.spring.configuration.annotations.PuiSpringConfiguration;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.aop.framework.ProxyProcessorSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.pui9.PuiTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@PuiSpringConfiguration
@EnableTransactionManagement
public class PuiDaoSpringConfiguration {
    @Autowired(required=false)
    @Qualifier(value="dataSource")
    protected DataSource dataSource;
    @Autowired
    @Qualifier(value="org.springframework.aop.config.internalAutoProxyCreator")
    private ProxyProcessorSupport proxySupport;

    @PostConstruct
    private void postConstruct() {
        this.proxySupport.setBeanClassLoader(PuiClassLoaderUtils.getClassLoader());
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        if (this.dataSource != null) {
            return new PuiTransactionManager(this.dataSource);
        }
        return null;
    }
}

