/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.generator.layers;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.model.generator.TemplateFileInfo;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.StringUtils;

public abstract class AbstractLayerGenerator {
    protected AbstractApplicationContext appContext;
    protected DefaultListableBeanFactory factory;
    protected BeanDefinitionRegistry definitionRegistry;
    @Autowired
    private PuiApplicationContext context;

    @PostConstruct
    private void postConstruct() {
        this.appContext = (AbstractApplicationContext)this.context.getAppContext();
        this.factory = (DefaultListableBeanFactory)this.appContext.getBeanFactory();
        this.definitionRegistry = (BeanDefinitionRegistry)this.appContext.getAutowireCapableBeanFactory();
    }

    public abstract List<TemplateFileInfo> getTemplateList(boolean var1);

    public final void registerClasses(List<TemplateFileInfo> templateList) throws Exception {
        List<Class<?>> classes = this.getClassesToRegister(templateList);
        for (Class<?> clazz : classes) {
            this.registerBean(clazz);
        }
    }

    protected String getBeanName(Class<?> clazz) {
        String beanName = clazz.getSimpleName();
        if (clazz.isInterface()) {
            beanName = beanName.substring(1);
        }
        if ((beanName = StringUtils.uncapitalize((String)beanName)).startsWith("v")) {
            beanName = StringUtils.capitalize((String)beanName);
        }
        return beanName;
    }

    protected abstract Object registerBean(Class<?> var1) throws Exception;

    protected abstract List<Class<?>> getClassesToRegister(List<TemplateFileInfo> var1) throws Exception;
}

