/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.generator.layers;

import es.prodevelop.pui9.classpath.PuiClassLoaderUtils;
import es.prodevelop.pui9.model.generator.TemplateFileInfo;
import es.prodevelop.pui9.model.generator.layers.AbstractLayerGenerator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public abstract class AbstractControllerLayerGenerator
extends AbstractLayerGenerator {
    public static final String subpackageName = ".controller";

    @Override
    public List<TemplateFileInfo> getTemplateList(boolean isView) {
        TemplateFileInfo web = new TemplateFileInfo("web/Controller.ftl", "%filename%Controller" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.controller");
        ArrayList<TemplateFileInfo> list = new ArrayList<TemplateFileInfo>();
        list.add(web);
        return list;
    }

    @Override
    protected List<Class<?>> getClassesToRegister(List<TemplateFileInfo> templateList) throws Exception {
        ArrayList classes = new ArrayList();
        for (TemplateFileInfo tfi : templateList) {
            String className = (tfi.getPackageName() + "." + tfi.getFileName()).replace(JavaFileObject.Kind.SOURCE.extension, "");
            Class<?> clazz = PuiClassLoaderUtils.getClassLoader().loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    @Override
    protected Object registerBean(Class<?> clazz) throws Exception {
        String beanName = this.getBeanName(clazz);
        if (this.definitionRegistry.containsBeanDefinition(beanName)) {
            throw new BeanCreationException("Bean " + beanName + " already exists");
        }
        CachingMetadataReaderFactory mrf = new CachingMetadataReaderFactory((ResourceLoader)this.appContext);
        MetadataReader mr = mrf.getMetadataReader(clazz.getName());
        ScannedGenericBeanDefinition bd = new ScannedGenericBeanDefinition(mr);
        bd.addMetadataAttribute(new BeanMetadataAttribute("org.springframework.context.annotation.ConfigurationClassPostProcessor.configurationClass", (Object)"lite"));
        bd.setScope("singleton");
        bd.setEnforceDestroyMethod(false);
        bd.setEnforceInitMethod(false);
        String className = clazz.getName().replace(".", "/") + JavaFileObject.Kind.CLASS.extension;
        URL url = PuiClassLoaderUtils.getClassLoader().getResource(className);
        UrlResource ur = new UrlResource(url);
        bd.setSource((Object)ur);
        bd.setResource((Resource)ur);
        this.definitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)bd);
        Object bean = this.factory.getBean(beanName);
        this.postCreateBean(bean);
        return bean;
    }

    protected abstract void postCreateBean(Object var1);
}

