/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao.interfaces;

import es.prodevelop.pui9.exceptions.PuiDaoCountException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoListException;
import es.prodevelop.pui9.exceptions.PuiDaoNoNumericColumnException;
import es.prodevelop.pui9.exceptions.PuiDaoSumException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.order.OrderBuilder;
import es.prodevelop.pui9.search.SearchRequest;
import es.prodevelop.pui9.search.SearchResponse;
import es.prodevelop.pui9.utils.PuiLanguage;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Consumer;
import org.jooq.Query;

public interface IDao<T extends IDto> {
    public static final String TABLE_PREFIX = "t1";
    public static final String TABLE_LANG_PREFIX = "t2";

    public Long count() throws PuiDaoCountException;

    public Long count(FilterBuilder var1) throws PuiDaoCountException;

    public Long count(String var1, boolean var2, FilterBuilder var3) throws PuiDaoCountException;

    public BigDecimal sum(String var1) throws PuiDaoSumException;

    public BigDecimal sum(String var1, FilterBuilder var2) throws PuiDaoSumException;

    public <N extends Number> N getNextValue(String var1, FilterBuilder var2) throws PuiDaoNoNumericColumnException;

    public <N extends Number> N getMaxValue(String var1, FilterBuilder var2) throws PuiDaoNoNumericColumnException;

    public T findOne(FilterBuilder var1) throws PuiDaoFindException;

    public T findOne(FilterBuilder var1, OrderBuilder var2) throws PuiDaoFindException;

    public T findOne(FilterBuilder var1, PuiLanguage var2) throws PuiDaoFindException;

    public List<T> findAll() throws PuiDaoFindException;

    public List<T> findAll(PuiLanguage var1) throws PuiDaoFindException;

    public List<T> findAll(OrderBuilder var1) throws PuiDaoFindException;

    public List<T> findAll(OrderBuilder var1, PuiLanguage var2) throws PuiDaoFindException;

    public List<T> findWhere(FilterBuilder var1) throws PuiDaoFindException;

    public List<T> findWhere(FilterBuilder var1, OrderBuilder var2) throws PuiDaoFindException;

    public List<T> findWhere(FilterBuilder var1, PuiLanguage var2) throws PuiDaoFindException;

    public List<T> findWhere(FilterBuilder var1, OrderBuilder var2, PuiLanguage var3) throws PuiDaoFindException;

    public void executeQuery(Query var1) throws PuiDaoFindException;

    public List<T> executeCustomQuery(Query var1) throws PuiDaoFindException;

    public List<T> executeCustomQueryWithParameters(Query var1, List<Object> var2) throws PuiDaoFindException;

    public Class<T> getDtoClass();

    public Class<? extends IDao<T>> getDaoClass();

    public void executePaginagedOperation(SearchRequest var1, Consumer<T> var2, Consumer<List<T>> var3);

    public SearchResponse<T> findPaginated(SearchRequest var1) throws PuiDaoListException;
}

