/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.elasticsearch.exceptions.PuiElasticSearchSearchException;
import es.prodevelop.pui9.elasticsearch.interfaces.IPuiElasticSearchEnablement;
import es.prodevelop.pui9.elasticsearch.services.interfaces.IPuiElasticSearchSearchingService;
import es.prodevelop.pui9.exceptions.PuiDaoListException;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.AbstractDatabaseDao;
import es.prodevelop.pui9.model.dao.interfaces.IViewDao;
import es.prodevelop.pui9.model.dto.interfaces.IViewDto;
import es.prodevelop.pui9.search.SearchRequest;
import es.prodevelop.pui9.search.SearchResponse;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractViewDao<T extends IViewDto>
extends AbstractDatabaseDao<T>
implements IViewDao<T> {
    @Autowired(required=false)
    private IPuiElasticSearchEnablement elasticSearchEnablement;
    @Autowired(required=false)
    private IPuiElasticSearchSearchingService elasticSearchSearchingService;

    @Override
    public SearchResponse<T> findPaginated(SearchRequest req) throws PuiDaoListException {
        if (req.isFromClient().booleanValue() && PuiUserSession.getCurrentSession() != null) {
            req.setZoneId(PuiUserSession.getCurrentSession().getZoneId());
        }
        if (req.getDtoClass() == null) {
            req.setDtoClass(this.getDtoClass());
        }
        if (this.elasticSearchEnablement != null && this.elasticSearchEnablement.isViewIndexable(this.getDtoClass()) && this.elasticSearchEnablement.isElasticSearchAvailable() && this.elasticSearchEnablement.isElasticSearchActive()) {
            try {
                return this.elasticSearchSearchingService.findPaginated(req);
            }
            catch (PuiElasticSearchSearchException e) {
                return super.findPaginated(req);
            }
        }
        return super.findPaginated(req);
    }

    @Override
    public Class<? extends IViewDao<T>> getDaoClass() {
        return super.getDaoClass();
    }
}

