/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.db.helpers.IDatabaseHelper;
import es.prodevelop.pui9.exceptions.PuiDaoCountException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoListException;
import es.prodevelop.pui9.exceptions.PuiDaoNoNumericColumnException;
import es.prodevelop.pui9.exceptions.PuiDaoSumException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.AbstractDao;
import es.prodevelop.pui9.model.dao.DaoRowMapper;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.order.Order;
import es.prodevelop.pui9.order.OrderBuilder;
import es.prodevelop.pui9.order.OrderDirection;
import es.prodevelop.pui9.search.SearchRequest;
import es.prodevelop.pui9.search.SearchResponse;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;
import org.springframework.util.ObjectUtils;

public abstract class AbstractDatabaseDao<T extends IDto>
extends AbstractDao<T> {
    protected static final String PARAMETER = "?";
    @Autowired(required=false)
    protected IDatabaseHelper dbHelper;
    protected JdbcTemplate jdbcTemplate;
    private DaoRowMapper<T> rowMapper;

    @Autowired(required=false)
    private void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    protected void postConstruct() {
        super.postConstruct();
        this.rowMapper = this.getRowMapper();
    }

    protected DaoRowMapper<T> getRowMapper() {
        return new DaoRowMapper(this, this.dtoClass);
    }

    protected String getEntityName() {
        return this.daoRegistry.getEntityName(this);
    }

    @Override
    public Long count() throws PuiDaoCountException {
        return this.count(null);
    }

    @Override
    public Long count(FilterBuilder filterBuilder) throws PuiDaoCountException {
        return this.count(null, false, filterBuilder);
    }

    @Override
    public Long count(String column, boolean distinct, FilterBuilder filterBuilder) throws PuiDaoCountException {
        SelectSelectStep count;
        if (!ObjectUtils.isEmpty((Object)column)) {
            String prefix = null;
            if (DtoRegistry.getAllColumnNames((Class)this.dtoClass).contains(column)) {
                prefix = "t1";
            } else if (DtoRegistry.getLangColumnNames((Class)this.dtoClass).contains(column)) {
                prefix = "t2";
            }
            if (prefix == null) {
                return null;
            }
            count = distinct ? this.dbHelper.getDSLContext().select((SelectField)DSL.countDistinct((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, column})))) : this.dbHelper.getDSLContext().select((SelectField)DSL.count((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, column}))));
        } else {
            count = this.dbHelper.getDSLContext().select((SelectField)DSL.count());
        }
        count.from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)((SelectJoinStep)count));
        }
        if (filterBuilder != null) {
            String filter = this.dbHelper.processFilters(this.dtoClass, filterBuilder.asFilterGroup(), true);
            count.where(filter);
        }
        return this.performCount((Select<Record1<Integer>>)count);
    }

    protected Long performCount(Select<Record1<Integer>> query) throws PuiDaoCountException {
        this.checkDataSource();
        try {
            return (Long)this.jdbcTemplate.queryForObject(query.getSQL(), Long.class);
        }
        catch (DataAccessException e) {
            throw new PuiDaoCountException((Exception)((Object)e));
        }
    }

    @Override
    public BigDecimal sum(String column) throws PuiDaoSumException {
        return this.sum(column, null);
    }

    @Override
    public BigDecimal sum(String column, FilterBuilder filterBuilder) throws PuiDaoSumException {
        if (!DtoRegistry.getNumericFields((Class)this.dtoClass).contains(column) && !DtoRegistry.getFloatingFields((Class)this.dtoClass).contains(column)) {
            return null;
        }
        String prefix = null;
        if (DtoRegistry.getAllColumnNames((Class)this.dtoClass).contains(column)) {
            prefix = "t1";
        } else if (DtoRegistry.getLangColumnNames((Class)this.dtoClass).contains(column)) {
            prefix = "t2";
        }
        if (prefix == null) {
            return null;
        }
        SelectSelectStep sum = this.dbHelper.getDSLContext().select((SelectField)DSL.sum((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, column}), BigDecimal.class)));
        sum.from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)((SelectJoinStep)sum));
        }
        if (!filterBuilder.isEmpty()) {
            String filter = this.dbHelper.processFilters(this.dtoClass, filterBuilder.asFilterGroup(), true);
            sum.where(filter);
        }
        return this.performSum((Select<Record1<BigDecimal>>)sum);
    }

    protected BigDecimal performSum(Select<Record1<BigDecimal>> query) throws PuiDaoSumException {
        this.checkDataSource();
        try {
            return (BigDecimal)this.jdbcTemplate.queryForObject(query.getSQL(), BigDecimal.class);
        }
        catch (DataAccessException e) {
            throw new PuiDaoSumException((Exception)((Object)e));
        }
    }

    @Override
    public T findOne(FilterBuilder filterBuilder) throws PuiDaoFindException {
        return this.findOne(filterBuilder, (PuiLanguage)null);
    }

    @Override
    public T findOne(FilterBuilder filterBuilder, OrderBuilder orderBuilder) throws PuiDaoFindException {
        List<T> list = this.doFindWhere(filterBuilder, orderBuilder, null);
        if (!list.isEmpty()) {
            return (T)((IDto)list.get(0));
        }
        return null;
    }

    @Override
    public T findOne(FilterBuilder filterBuilder, PuiLanguage language) throws PuiDaoFindException {
        List<T> list = this.doFindWhere(filterBuilder, null, language);
        if (!list.isEmpty()) {
            return (T)((IDto)list.get(0));
        }
        return null;
    }

    @Override
    public List<T> findAll() throws PuiDaoFindException {
        return this.doFindWhere(null, null, null);
    }

    @Override
    public List<T> findAll(OrderBuilder orderBuilder) throws PuiDaoFindException {
        return this.doFindWhere(null, orderBuilder, null);
    }

    @Override
    public List<T> findAll(PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(null, null, language);
    }

    @Override
    public List<T> findAll(OrderBuilder orderBuilder, PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(null, orderBuilder, language);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, null, null);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder, OrderBuilder orderBuilder) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, orderBuilder, null);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder, PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, null, language);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder, OrderBuilder orderBuilder, PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, orderBuilder, language);
    }

    @Override
    public <N extends Number> N getNextValue(String columnName, FilterBuilder filterBuilder) throws PuiDaoNoNumericColumnException {
        Object value = this.getMaxValue(columnName, filterBuilder);
        if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).add(BigDecimal.ONE);
        } else if (value instanceof Integer) {
            value = (Integer)value + 1;
        } else if (value instanceof Long) {
            value = (Long)value + 1L;
        } else if (value instanceof Double) {
            value = (Double)value + 1.0;
        } else if (value instanceof Float) {
            value = Float.valueOf(((Float)value).floatValue() + 1.0f);
        } else if (value instanceof BigInteger) {
            value = ((BigInteger)value).add(BigInteger.ONE);
        }
        return value;
    }

    @Override
    public <N extends Number> N getMaxValue(String columnName, FilterBuilder filterBuilder) throws PuiDaoNoNumericColumnException {
        String filter;
        String auxFieldName = DtoRegistry.getFieldNameFromColumnName((Class)this.dtoClass, (String)columnName);
        if (auxFieldName == null) {
            auxFieldName = columnName;
        }
        if (!DtoRegistry.getNumericFields((Class)this.dtoClass).contains(auxFieldName) && !DtoRegistry.getFloatingFields((Class)this.dtoClass).contains(auxFieldName)) {
            throw new PuiDaoNoNumericColumnException(columnName);
        }
        String auxColumnName = DtoRegistry.getColumnNameFromFieldName((Class)this.dtoClass, (String)columnName);
        if (auxColumnName != null) {
            columnName = auxColumnName;
        }
        String prefix = null;
        if (DtoRegistry.getAllColumnNames((Class)this.dtoClass).contains(columnName)) {
            prefix = "t1";
        } else if (DtoRegistry.getLangColumnNames((Class)this.dtoClass).contains(columnName)) {
            prefix = "t2";
        }
        if (prefix == null) {
            return null;
        }
        SelectJoinStep max = this.dbHelper.getDSLContext().select((SelectField)DSL.max((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, columnName})))).from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)max);
        }
        if (filterBuilder != null && !ObjectUtils.isEmpty((Object)(filter = this.dbHelper.processFilters(this.dtoClass, filterBuilder.asFilterGroup(), true)))) {
            max.where(filter);
        }
        String fieldName = DtoRegistry.getFieldNameFromColumnName((Class)this.dtoClass, (String)columnName);
        java.lang.reflect.Field field = DtoRegistry.getJavaFieldFromFieldName((Class)this.dtoClass, (String)fieldName);
        Number value = null;
        try {
            value = (Number)this.performMaxValue(max.getSQL(), field.getType());
        }
        catch (Exception e) {
            value = null;
        }
        if (value == null) {
            try {
                value = (Number)field.getType().getConstructor(String.class).newInstance("0");
            }
            catch (Exception e) {
                return null;
            }
        }
        return (N)value;
    }

    protected <N extends Number> N performMaxValue(String sql, Class<?> fieldType) {
        this.checkDataSource();
        return (N)((Number)this.jdbcTemplate.queryForObject(sql, fieldType));
    }

    @Override
    public void executeQuery(Query query) throws PuiDaoFindException {
        if (query == null) {
            return;
        }
        this.checkDataSource();
        try {
            this.jdbcTemplate.execute(query.getSQL());
        }
        catch (DataAccessException e) {
            throw new PuiDaoFindException((Exception)((Object)e));
        }
    }

    @Override
    public List<T> executeCustomQuery(Query query) throws PuiDaoFindException {
        if (query == null) {
            return Collections.emptyList();
        }
        this.checkDataSource();
        try {
            return this.jdbcTemplate.query(query.getSQL(), this.rowMapper);
        }
        catch (DataAccessException e) {
            throw new PuiDaoFindException((Exception)((Object)e));
        }
    }

    @Override
    public List<T> executeCustomQueryWithParameters(Query query, List<Object> parameters) throws PuiDaoFindException {
        if (query == null) {
            return Collections.emptyList();
        }
        this.checkDataSource();
        try {
            return this.jdbcTemplate.query(query.getSQL(), this.rowMapper, parameters.toArray());
        }
        catch (DataAccessException e) {
            throw new PuiDaoFindException((Exception)((Object)e));
        }
    }

    @Override
    public void executePaginagedOperation(SearchRequest req, Consumer<T> consumer, Consumer<List<T>> bulkConsumer) {
        req.setPage(SearchRequest.DEFAULT_PAGE);
        req.setPerformCount(Boolean.valueOf(false));
        while (true) {
            List list;
            try {
                list = this.findPaginated(req).getData();
            }
            catch (PuiDaoListException e) {
                list = Collections.emptyList();
            }
            if (ObjectUtils.isEmpty((Object)list)) break;
            if (consumer != null) {
                for (IDto obj : list) {
                    consumer.accept(obj);
                }
            } else if (bulkConsumer != null) {
                bulkConsumer.accept(list);
            }
            req.setPage(Integer.valueOf(req.getPage() + 1));
        }
    }

    @Override
    public SearchResponse<T> findPaginated(SearchRequest req) throws PuiDaoListException {
        SelectSelectStep select;
        req.setDtoClass(this.dtoClass);
        if (req.isFromClient().booleanValue() && PuiUserSession.getCurrentSession() != null) {
            req.setZoneId(PuiUserSession.getCurrentSession().getZoneId());
        }
        FilterBuilder filterBuilder = req.buildSearchFilter(this.dtoClass);
        OrderBuilder orderBuilder = req.buildSearchOrder(this.dtoClass);
        if (!ObjectUtils.isEmpty((Object)req.getQueryLang()) && PuiLanguageUtils.hasLanguageSupport((Class)this.dtoClass)) {
            FilterBuilder langBuilder = FilterBuilder.newOrFilter().addEqualsExact("lang", req.getQueryLang()).addIsNull("lang");
            FilterBuilder filterBuilderAux = filterBuilder;
            filterBuilder = FilterBuilder.newAndFilter();
            filterBuilder.addGroup(langBuilder);
            filterBuilder.addGroup(filterBuilderAux);
        }
        String filters = this.dbHelper.processFilters(this.dtoClass, filterBuilder.asFilterGroup(), true);
        String quickSearch = null;
        if (!ObjectUtils.isEmpty((Object)req.getQueryFields())) {
            quickSearch = this.dbHelper.processSearchText(this.dtoClass, req.getQueryFields(), req.getQueryText(), req.getZoneId());
        } else if (!ObjectUtils.isEmpty((Object)req.getQueryFieldText())) {
            quickSearch = this.dbHelper.processSearchText(this.dtoClass, req.getQueryFieldText(), req.getZoneId());
        }
        String where = ObjectUtils.isEmpty((Object)filters) && ObjectUtils.isEmpty(quickSearch) ? null : (!ObjectUtils.isEmpty((Object)filters) && ObjectUtils.isEmpty((Object)quickSearch) ? filters : (ObjectUtils.isEmpty((Object)filters) && !ObjectUtils.isEmpty((Object)quickSearch) ? quickSearch : "(" + filters + ") AND (" + quickSearch + ")"));
        if (ObjectUtils.isEmpty((Object)req.getColumns())) {
            select = this.dbHelper.getDSLContext().select(new SelectFieldOrAsterisk[]{DSL.asterisk()});
        } else if (req.isDistinctValues().booleanValue()) {
            select = this.dbHelper.getDSLContext().selectDistinct((Collection)req.getColumns().stream().map(DSL::field).collect(Collectors.toList()));
        } else {
            select = this.dbHelper.getDSLContext().select((Collection)req.getColumns().stream().map(DSL::field).collect(Collectors.toList()));
            if (!ObjectUtils.isEmpty((Object)req.getDistinctOnColumns())) {
                select.distinctOn((Collection)req.getDistinctOnColumns().stream().map(dc -> DSL.field((String)dc)).collect(Collectors.toList()));
            }
        }
        select.from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)((SelectJoinStep)select));
        }
        if (!ObjectUtils.isEmpty((Object)where)) {
            select.where(where);
        }
        if (orderBuilder != null && !ObjectUtils.isEmpty((Object)orderBuilder.toString())) {
            Iterator it = orderBuilder.getOrders().iterator();
            while (it.hasNext()) {
                if (DtoRegistry.getAllColumnNames((Class)this.dtoClass).contains(((Order)it.next()).getColumn())) continue;
                it.remove();
            }
            if (this.daoRegistry.hasLanguageSupport(this)) {
                orderBuilder.getOrders().forEach(order -> {
                    String column = DtoRegistry.getColumnNameFromFieldName((Class)this.dtoClass, (String)order.getColumn());
                    if (column == null) {
                        return;
                    }
                    if (DtoRegistry.getColumnNames((Class)this.dtoClass).contains(column)) {
                        order.setColumn("t1." + column);
                    } else {
                        order.setColumn("t2." + column);
                    }
                });
            }
            if (!ObjectUtils.isEmpty((Object)orderBuilder.getOrders())) {
                select.orderBy((Collection)orderBuilder.getOrders().stream().map(o -> o.getDirection().equals((Object)OrderDirection.asc) ? DSL.field((String)o.getColumn()).asc() : DSL.field((String)o.getColumn()).desc()).collect(Collectors.toList()));
            }
        }
        Long total = 0L;
        if (req.isPerformCount().booleanValue()) {
            SelectJoinStep count = DSL.select((SelectField)DSL.count((SelectFieldOrAsterisk)DSL.asterisk())).from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
            if (this.daoRegistry.hasLanguageSupport(this)) {
                this.addTranslationJoins((SelectJoinStep<Record>)count);
            }
            if (!ObjectUtils.isEmpty((Object)where)) {
                count.where(where);
            }
            try {
                total = this.performCount((Select<Record1<Integer>>)count);
            }
            catch (PuiDaoCountException e) {
                throw new PuiDaoListException((Exception)((Object)e));
            }
        }
        Integer from = req.getPage() - 1;
        Integer size = req.getRows();
        List<T> list = this.getListPaginated(from, size, (SelectJoinStep)select);
        SearchResponse res = new SearchResponse();
        for (String sumColumn : req.getSumColumns()) {
            BigDecimal sum;
            try {
                sum = this.sum(sumColumn, filterBuilder);
            }
            catch (PuiDaoSumException e) {
                sum = null;
            }
            res.addSumData(sumColumn, sum);
        }
        res.setCurrentPage(Integer.valueOf(from + 1));
        res.setCurrentRecords(Integer.valueOf(list.size()));
        res.setTotalRecords(total);
        res.setTotalPages(Long.valueOf(total / (long)size.intValue()));
        if (total % (long)size.intValue() > 0L) {
            res.setTotalPages(Long.valueOf(res.getTotalPages() + 1L));
        }
        res.setData(list);
        return res;
    }

    protected List<T> doFindWhere(FilterBuilder filterBuilder, OrderBuilder orderBuilder, PuiLanguage language) throws PuiDaoFindException {
        Select<Record> query = this.buildSelectSql(filterBuilder, orderBuilder, language);
        return this.executeCustomQuery((Query)query);
    }

    private Select<Record> buildSelectSql(FilterBuilder filterBuilder, OrderBuilder orderBuilder, PuiLanguage language) {
        String filter;
        java.lang.reflect.Field field;
        SelectJoinStep select = this.dbHelper.getDSLContext().select(new SelectFieldOrAsterisk[]{DSL.asterisk()}).from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)select);
        }
        if ((field = DtoRegistry.getJavaFieldFromAllFields((Class)this.dtoClass, (String)"lang")) != null && language != null && PuiLanguageUtils.hasLanguageSupport((Class)this.dtoClass)) {
            FilterBuilder langFb = FilterBuilder.newOrFilter().addEqualsExact("lang", language.getIsocode()).addIsNull("lang");
            FilterBuilder auxFb = filterBuilder;
            filterBuilder = FilterBuilder.newAndFilter().addGroup(auxFb).addGroup(langFb);
        }
        if (filterBuilder != null && !ObjectUtils.isEmpty((Object)(filter = this.dbHelper.processFilters(this.dtoClass, filterBuilder.asFilterGroup(), true)))) {
            select.where(filter);
        }
        if (orderBuilder != null && !ObjectUtils.isEmpty((Object)orderBuilder.toString())) {
            Iterator it = orderBuilder.getOrders().iterator();
            while (it.hasNext()) {
                if (DtoRegistry.getAllColumnNames((Class)this.dtoClass).contains(((Order)it.next()).getColumn())) continue;
                it.remove();
            }
            if (this.daoRegistry.hasLanguageSupport(this)) {
                orderBuilder.getOrders().forEach(order -> {
                    String column = DtoRegistry.getColumnNameFromFieldName((Class)this.dtoClass, (String)order.getColumn());
                    if (column != null) {
                        order.setColumn(column);
                    }
                    if (DtoRegistry.getColumnNames((Class)this.dtoClass).contains(column)) {
                        order.setColumn("t1." + column);
                    } else {
                        order.setColumn("t2." + column);
                    }
                });
            }
            if (!ObjectUtils.isEmpty((Object)orderBuilder.getOrders())) {
                select.orderBy((Collection)orderBuilder.getOrders().stream().map(o -> o.getDirection().equals((Object)OrderDirection.asc) ? DSL.field((String)o.getColumn()).asc() : DSL.field((String)o.getColumn()).desc()).collect(Collectors.toList()));
            }
        }
        return select;
    }

    protected void addTranslationJoins(SelectJoinStep<? extends Record> step) {
    }

    private <S extends SelectJoinStep<Record>> List<T> getListPaginated(int page, int size, S select) throws PuiDaoListException {
        S newSelect = this.dbHelper.getSqlForPagination(page, size, select);
        return this.performListPaginated(newSelect);
    }

    protected <S extends SelectJoinStep<Record>> List<T> performListPaginated(S select) throws PuiDaoListException {
        this.checkDataSource();
        try {
            return this.jdbcTemplate.query(select.getSQL(), this.rowMapper);
        }
        catch (DataAccessException e) {
            throw new PuiDaoListException((Exception)((Object)e));
        }
    }

    protected void customizeDto(T dto) {
    }

    protected void checkDataSource() {
        if (this.jdbcTemplate == null) {
            throw new DataSourceLookupFailureException("No database configured for this application");
        }
    }
}

