/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.exceptions.PuiDaoAttributeLengthException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoNoNumericColumnException;
import es.prodevelop.pui9.exceptions.PuiDaoNullParametersException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.interfaces.IDao;
import es.prodevelop.pui9.model.dao.registry.DaoRegistry;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.utils.PuiLanguage;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public abstract class AbstractDao<T extends IDto>
implements IDao<T> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    protected DaoRegistry daoRegistry;
    protected Class<T> dtoClass;

    @PostConstruct
    protected void postConstruct() {
        this.daoRegistry.registerDao(this.getClass());
        this.dtoClass = this.daoRegistry.getDtoFromDao(this.getClass(), false);
    }

    @Override
    public Class<T> getDtoClass() {
        return this.dtoClass;
    }

    @Override
    public Class<? extends IDao<T>> getDaoClass() {
        return this.getClass();
    }

    protected List<T> findByColumn(String fieldName, Object value) throws PuiDaoFindException {
        return this.findByColumn(fieldName, value, PuiUserSession.getSessionLanguage());
    }

    protected List<T> findByColumn(String fieldName, Object value, PuiLanguage language) throws PuiDaoFindException {
        String columnName = DtoRegistry.getColumnNameFromFieldName(this.dtoClass, (String)fieldName);
        FilterBuilder filterBuilder = FilterBuilder.newAndFilter();
        if (DtoRegistry.getStringFields(this.dtoClass).contains(fieldName) && value instanceof String) {
            filterBuilder.addEqualsExact(columnName, (String)value);
        } else {
            filterBuilder.addEquals(columnName, value);
        }
        return this.findWhere(filterBuilder, language);
    }

    protected void checkValues(ITableDto dto) throws PuiDaoNullParametersException, PuiDaoAttributeLengthException {
        LinkedHashMap map = new LinkedHashMap();
        map.putAll(DtoRegistry.getMapFieldsFromFieldName(dto.getClass()));
        map.putAll(DtoRegistry.getLangMapFieldsFromFieldName(dto.getClass()));
        List notNullFieldNames = DtoRegistry.getNotNullFields(dto.getClass());
        for (String fieldName : notNullFieldNames) {
            Object value;
            Field field;
            if (DtoRegistry.getSequenceFields(dto.getClass()).contains(fieldName) || (field = (Field)map.get(fieldName)) == null) continue;
            try {
                value = FieldUtils.readField((Field)field, (Object)dto, (boolean)true);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null) {
                throw new PuiDaoNullParametersException(fieldName);
            }
            if (!DtoRegistry.getStringFields(dto.getClass()).contains(fieldName) || !ObjectUtils.isEmpty((Object)value)) continue;
            throw new PuiDaoNullParametersException(fieldName);
        }
        Map maxLengthFieldNames = DtoRegistry.getFieldNamesMaxLength(dto.getClass());
        for (Map.Entry entry : maxLengthFieldNames.entrySet()) {
            String value;
            Field field;
            String fieldName = (String)entry.getKey();
            Integer maxLength = (Integer)entry.getValue();
            if (maxLength.equals(-1) || (field = (Field)map.get(fieldName)) == null || !field.getType().equals(String.class)) continue;
            try {
                value = (String)FieldUtils.readField((Field)field, (Object)dto, (boolean)true);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null || value.length() <= maxLength) continue;
            throw new PuiDaoAttributeLengthException(fieldName, maxLength, value.length());
        }
    }

    protected void setAutoincrementableValues(List<T> dtoList) throws PuiDaoNoNumericColumnException {
        List fieldNames = DtoRegistry.getAutoincrementableFieldNames(this.dtoClass);
        for (String fieldName : fieldNames) {
            try {
                Field field = DtoRegistry.getJavaFieldFromFieldName(this.dtoClass, (String)fieldName);
                if (field.get(dtoList.get(0)) != null) continue;
                String columnName = DtoRegistry.getColumnNameFromFieldName(this.dtoClass, (String)fieldName);
                FilterBuilder filterBuilder = this.getAutoincrementableColumnFilter((IDto)dtoList.get(0), columnName);
                Object nextId = this.getNextValue(columnName, filterBuilder);
                for (IDto dto : dtoList) {
                    if (FieldUtils.readField((Field)field, (Object)dto, (boolean)true) == null) continue;
                    FieldUtils.writeField((Field)field, (Object)dto, nextId, (boolean)true);
                    if (nextId instanceof Long) {
                        nextId = ((Number)nextId).longValue() + 1L;
                        continue;
                    }
                    if (!(nextId instanceof Integer)) continue;
                    nextId = ((Number)nextId).intValue() + 1;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
        }
    }

    protected FilterBuilder getAutoincrementableColumnFilter(T dto, String columnName) {
        return null;
    }

    protected Map<String, Object> convertFieldsToColumns(Map<String, Object> fieldValuesMap) {
        List dtoColumns = DtoRegistry.getColumnNames(this.dtoClass);
        LinkedHashMap<String, Object> columnValuesMap = new LinkedHashMap<String, Object>();
        fieldValuesMap.forEach((fieldName, value) -> {
            String columnName = DtoRegistry.getColumnNameFromFieldName(this.dtoClass, (String)fieldName);
            if (columnName == null) {
                columnName = fieldName;
            }
            columnValuesMap.put(columnName, value);
        });
        columnValuesMap.keySet().removeIf(fieldName -> !dtoColumns.contains(fieldName));
        return columnValuesMap;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

