/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.lang;

import es.prodevelop.pui9.utils.PuiLanguage;
import java.util.List;
import java.util.Locale;
import org.springframework.util.ObjectUtils;

public class LanguageThreadLocal {
    private static LanguageThreadLocal singleton;
    private ThreadLocal<PuiLanguage> threadLocal = new ThreadLocal();

    public static LanguageThreadLocal getSingleton() {
        if (singleton == null) {
            singleton = new LanguageThreadLocal();
        }
        return singleton;
    }

    private LanguageThreadLocal() {
    }

    public void setData(String langs) {
        if (ObjectUtils.isEmpty((Object)langs)) {
            return;
        }
        List<Locale.LanguageRange> allLangs = Locale.LanguageRange.parse(langs);
        if (ObjectUtils.isEmpty(allLangs)) {
            return;
        }
        String langTag = allLangs.get(0).getRange();
        Locale locale = Locale.forLanguageTag(langTag);
        this.setData(new PuiLanguage(locale));
    }

    public void setData(PuiLanguage lang) {
        this.threadLocal.set(lang);
    }

    public PuiLanguage getData() {
        return this.threadLocal.get();
    }

    public void removeData() {
        this.threadLocal.remove();
    }
}

