/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.eventlistener;

import java.util.concurrent.Executor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="applicationEventMulticaster")
public class PuiApplicationEventMulticaster
extends SimpleApplicationEventMulticaster {
    private PuiApplicationEventMulticaster() {
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        ResolvableType type = eventType != null ? eventType : ResolvableType.forInstance((Object)event);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        for (ApplicationListener listener : this.getApplicationListeners(event, type)) {
            Executor executor = this.getTaskExecutor();
            if (executor != null) {
                executor.execute(() -> {
                    SecurityContextHolder.getContext().setAuthentication(auth);
                    this.invokeListener(listener, event);
                });
                continue;
            }
            this.invokeListener(listener, event);
        }
    }
}

