/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.ByteBuffer;
import com.aowagie.text.pdf.PdfObject;

public class PdfNumber
extends PdfObject {
    private double value;

    public PdfNumber(String content) {
        super(2);
        try {
            this.value = Double.parseDouble(content.trim());
            this.setContent(content);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(content + " is not a valid number - " + nfe.toString());
        }
    }

    public PdfNumber(int value) {
        super(2);
        this.value = value;
        this.setContent(String.valueOf(value));
    }

    PdfNumber(double value) {
        super(2);
        this.value = value;
        this.setContent(ByteBuffer.formatDouble(value));
    }

    public PdfNumber(float value) {
        this((double)value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }
}

