/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.Document;
import com.aowagie.text.DocumentException;
import com.aowagie.text.ExceptionConverter;
import com.aowagie.text.Rectangle;
import com.aowagie.text.pdf.BadPdfFormatException;
import com.aowagie.text.pdf.ByteBuffer;
import com.aowagie.text.pdf.PRIndirectReference;
import com.aowagie.text.pdf.PRStream;
import com.aowagie.text.pdf.PageResources;
import com.aowagie.text.pdf.PdfAnnotation;
import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfBoolean;
import com.aowagie.text.pdf.PdfContentByte;
import com.aowagie.text.pdf.PdfContents;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfDocument;
import com.aowagie.text.pdf.PdfException;
import com.aowagie.text.pdf.PdfFormField;
import com.aowagie.text.pdf.PdfImportedPage;
import com.aowagie.text.pdf.PdfIndirectReference;
import com.aowagie.text.pdf.PdfLiteral;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfNull;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfPage;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfReaderInstance;
import com.aowagie.text.pdf.PdfRectangle;
import com.aowagie.text.pdf.PdfStream;
import com.aowagie.text.pdf.PdfString;
import com.aowagie.text.pdf.PdfTemplate;
import com.aowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;

class PdfCopy
extends PdfWriter {
    private HashMap indirects;
    private final HashMap indirectMap;
    private PdfReader reader;
    private PdfIndirectReference acroForm;
    private final int[] namePtr = new int[]{0};
    private boolean rotateContents = true;
    private PdfArray fieldArray;
    private HashMap fieldTemplates;

    PdfCopy(Document document, OutputStream os, Calendar globalDate) throws DocumentException {
        super(new PdfDocument(globalDate), os);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    public boolean isRotateContents() {
        return this.rotateContents;
    }

    public void setRotateContents(boolean rotateContents) {
        this.rotateContents = rotateContents;
    }

    @Override
    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != reader) {
                try {
                    this.currentPdfReaderInstance.getReader().close();
                    this.currentPdfReaderInstance.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = reader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.getImportedPage(pageNumber);
    }

    private PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfObject type;
        PdfObject obj;
        PdfIndirectReference theRef;
        RefKey key = new RefKey(in);
        IndirectReferences iRef = (IndirectReferences)this.indirects.get(key);
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        if ((obj = PdfReader.getPdfObjectRelease(in)) != null && obj.isDictionary() && (type = PdfReader.getPdfObjectRelease(((PdfDictionary)obj).get(PdfName.TYPE))) != null && PdfName.PAGE.equals(type)) {
            return theRef;
        }
        iRef.setCopied();
        obj = this.copyObject(obj);
        this.addToBody(obj, theRef);
        return theRef;
    }

    private PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary();
        PdfObject type = PdfReader.getPdfObjectRelease(in.get(PdfName.TYPE));
        Iterator<PdfName> iterator = in.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName element;
            PdfName key = element = iterator.next();
            PdfObject value = in.get(key);
            if (type != null && PdfName.PAGE.equals(type)) {
                if (key.equals(PdfName.B) || key.equals(PdfName.PARENT)) continue;
                out.put(key, this.copyObject(value));
                continue;
            }
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    private PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        Iterator<PdfName> iterator = in.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName element;
            PdfName key = element = iterator.next();
            PdfObject value = in.get(key);
            out.put(key, this.copyObject(value));
        }
        return out;
    }

    private PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        ListIterator<PdfObject> i = in.listIterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            out.add(this.copyObject(value));
        }
        return out;
    }

    private PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        if (in == null) {
            return PdfNull.PDFNULL;
        }
        switch (in.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type);
        return null;
    }

    private int setFromIPage(PdfImportedPage iPage) {
        int pageNum = iPage.getPageNumber();
        PdfReaderInstance inst = this.currentPdfReaderInstance = iPage.getPdfReaderInstance();
        this.reader = inst.getReader();
        this.setFromReader(this.reader);
        return pageNum;
    }

    private void setFromReader(PdfReader reader) {
        this.reader = reader;
        this.indirects = (HashMap)this.indirectMap.get(reader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(reader, this.indirects);
            PdfDictionary catalog = reader.getCatalog();
            PRIndirectReference ref = null;
            PdfObject o = catalog.get(PdfName.ACROFORM);
            if (o == null || o.type() != 10) {
                return;
            }
            ref = (PRIndirectReference)o;
            if (this.acroForm == null) {
                this.acroForm = this.body.getPdfIndirectReference();
            }
            this.indirects.put(new RefKey(ref), new IndirectReferences(this.acroForm));
        }
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) {
        try {
            PdfDocument.PdfCatalog theCat = this.pdf.getCatalog(rootObj);
            if (this.fieldArray == null) {
                if (this.acroForm != null) {
                    theCat.put(PdfName.ACROFORM, this.acroForm);
                }
            } else {
                this.addFieldResources(theCat);
            }
            return theCat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    private void addFieldResources(PdfDictionary catalog) throws IOException {
        PdfDictionary dic;
        if (this.fieldArray == null) {
            return;
        }
        PdfDictionary acroForm = new PdfDictionary();
        catalog.put(PdfName.ACROFORM, acroForm);
        acroForm.put(PdfName.FIELDS, this.fieldArray);
        acroForm.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary dr = new PdfDictionary();
        acroForm.put(PdfName.DR, dr);
        for (PdfTemplate template : this.fieldTemplates.keySet()) {
            PdfFormField.mergeResources(dr, (PdfDictionary)template.getResources());
        }
        PdfDictionary fonts = dr.getAsDict(PdfName.FONT);
        if (fonts == null) {
            fonts = new PdfDictionary();
            dr.put(PdfName.FONT, fonts);
        }
        if (!fonts.contains(PdfName.HELV)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.HELVETICA);
            dic.put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            dic.put(PdfName.NAME, PdfName.HELV);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.HELV, this.addToBody(dic).getIndirectReference());
        }
        if (!fonts.contains(PdfName.ZADB)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            dic.put(PdfName.NAME, PdfName.ZADB);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.ZADB, this.addToBody(dic).getIndirectReference());
        }
    }

    @Override
    public void close() {
        if (this.open) {
            PdfReaderInstance ri = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
            if (ri != null) {
                try {
                    ri.getReader().close();
                    ri.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addAnnotation(PdfAnnotation annot) {
    }

    @Override
    PdfIndirectReference add(PdfPage page, PdfContents contents) throws PdfException {
        return null;
    }

    @Override
    public void freeReader(PdfReader reader) throws IOException {
        this.indirectMap.remove(reader);
        if (this.currentPdfReaderInstance != null && this.currentPdfReaderInstance.getReader() == reader) {
            try {
                this.currentPdfReaderInstance.getReader().close();
                this.currentPdfReaderInstance.getReaderFile().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentPdfReaderInstance = null;
        }
    }

    private static class StampContent
    extends PdfContentByte {
        private final PageResources pageResources;

        private StampContent(PdfWriter writer, PageResources pageResources) {
            super(writer);
            this.pageResources = pageResources;
        }

        @Override
        public PdfContentByte getDuplicate() {
            return new StampContent(this.writer, this.pageResources);
        }

        @Override
        PageResources getPageResources() {
            return this.pageResources;
        }
    }

    private static class PageStamp {
        private final PdfDictionary pageN;
        private StampContent under;
        private StampContent over;
        private PageResources pageResources;
        private final PdfReader reader;
        private final PdfCopy cstp;

        private PageStamp(PdfReader reader, PdfDictionary pageN, PdfCopy cstp) {
            this.pageN = pageN;
            this.reader = reader;
            this.cstp = cstp;
        }

        public PdfContentByte getUnderContent() {
            if (this.under == null) {
                if (this.pageResources == null) {
                    this.pageResources = new PageResources();
                    PdfDictionary resources = this.pageN.getAsDict(PdfName.RESOURCES);
                    this.pageResources.setOriginalResources(resources, this.cstp.namePtr);
                }
                this.under = new StampContent(this.cstp, this.pageResources);
            }
            return this.under;
        }

        public PdfContentByte getOverContent() {
            if (this.over == null) {
                if (this.pageResources == null) {
                    this.pageResources = new PageResources();
                    PdfDictionary resources = this.pageN.getAsDict(PdfName.RESOURCES);
                    this.pageResources.setOriginalResources(resources, this.cstp.namePtr);
                }
                this.over = new StampContent(this.cstp, this.pageResources);
            }
            return this.over;
        }

        private void applyRotation(PdfDictionary pageN, ByteBuffer out) {
            if (!this.cstp.rotateContents) {
                return;
            }
            Rectangle page = this.reader.getPageSizeWithRotation(pageN);
            int rotation = page.getRotation();
            switch (rotation) {
                case 90: {
                    out.append(PdfContents.ROTATE90);
                    out.append(page.getTop());
                    out.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                    break;
                }
                case 180: {
                    out.append(PdfContents.ROTATE180);
                    out.append(page.getRight());
                    out.append(' ');
                    out.append(page.getTop());
                    out.append(PdfContents.ROTATEFINAL);
                    break;
                }
                case 270: {
                    out.append(PdfContents.ROTATE270);
                    out.append('0').append(' ');
                    out.append(page.getRight());
                    out.append(PdfContents.ROTATEFINAL);
                }
            }
        }

        private void addDocumentField(PdfIndirectReference ref) {
            if (this.cstp.fieldArray == null) {
                this.cstp.fieldArray = new PdfArray();
            }
            this.cstp.fieldArray.add(ref);
        }

        private void expandFields(PdfFormField field, ArrayList allAnnots) {
            allAnnots.add(field);
            ArrayList kids = field.getKids();
            if (kids != null) {
                for (int k = 0; k < kids.size(); ++k) {
                    this.expandFields((PdfFormField)kids.get(k), allAnnots);
                }
            }
        }

        public void addAnnotation(PdfAnnotation annot) {
            try {
                ArrayList<PdfAnnotation> allAnnots = new ArrayList<PdfAnnotation>();
                if (annot.isForm()) {
                    PdfFormField field = (PdfFormField)annot;
                    if (field.getParent() != null) {
                        return;
                    }
                    this.expandFields(field, allAnnots);
                    if (this.cstp.fieldTemplates == null) {
                        this.cstp.fieldTemplates = new LinkedHashMap();
                    }
                } else {
                    allAnnots.add(annot);
                }
                for (int k = 0; k < allAnnots.size(); ++k) {
                    annot = (PdfAnnotation)allAnnots.get(k);
                    if (annot.isForm()) {
                        PdfFormField field;
                        HashMap templates;
                        if (!annot.isUsed() && (templates = annot.getTemplates()) != null) {
                            this.cstp.fieldTemplates.putAll(templates);
                        }
                        if ((field = (PdfFormField)annot).getParent() == null) {
                            this.addDocumentField(field.getIndirectReference());
                        }
                    }
                    if (annot.isAnnotation()) {
                        PdfRectangle rect;
                        PdfObject pdfobj = PdfReader.getPdfObject(this.pageN.get(PdfName.ANNOTS), this.pageN);
                        PdfArray annots = null;
                        if (pdfobj == null || !pdfobj.isArray()) {
                            annots = new PdfArray();
                            this.pageN.put(PdfName.ANNOTS, annots);
                        } else {
                            annots = (PdfArray)pdfobj;
                        }
                        annots.add(annot.getIndirectReference());
                        if (!(annot.isUsed() || (rect = (PdfRectangle)annot.get(PdfName.RECT)) == null || rect.left() == 0.0f && rect.right() == 0.0f && rect.top() == 0.0f && rect.bottom() == 0.0f)) {
                            int rotation = this.reader.getPageRotation(this.pageN);
                            Rectangle pageSize = this.reader.getPageSizeWithRotation(this.pageN);
                            switch (rotation) {
                                case 90: {
                                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.getTop() - rect.bottom(), rect.left(), pageSize.getTop() - rect.top(), rect.right()));
                                    break;
                                }
                                case 180: {
                                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.getRight() - rect.left(), pageSize.getTop() - rect.bottom(), pageSize.getRight() - rect.right(), pageSize.getTop() - rect.top()));
                                    break;
                                }
                                case 270: {
                                    annot.put(PdfName.RECT, new PdfRectangle(rect.bottom(), pageSize.getRight() - rect.left(), rect.top(), pageSize.getRight() - rect.right()));
                                }
                            }
                        }
                    }
                    if (annot.isUsed()) continue;
                    annot.setUsed();
                    this.cstp.addToBody((PdfObject)annot, annot.getIndirectReference());
                }
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
    }

    private static class RefKey {
        private final int num;
        private final int gen;

        private RefKey(PRIndirectReference ref) {
            this.num = ref.getNumber();
            this.gen = ref.getGeneration();
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RefKey)) {
                return false;
            }
            RefKey other = (RefKey)o;
            return this.gen == other.gen && this.num == other.num;
        }

        public String toString() {
            return Integer.toString(this.num) + ' ' + this.gen;
        }
    }

    private static class IndirectReferences {
        private final PdfIndirectReference theRef;
        private boolean hasCopied;

        private IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        private void setCopied() {
            this.hasCopied = true;
        }

        private boolean getCopied() {
            return this.hasCopied;
        }

        private PdfIndirectReference getRef() {
            return this.theRef;
        }
    }
}

