/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.Rectangle;
import com.aowagie.text.pdf.CMYKColor;
import com.aowagie.text.pdf.ExtendedColor;
import com.aowagie.text.pdf.GrayColor;
import com.aowagie.text.pdf.PdfAction;
import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfBoolean;
import com.aowagie.text.pdf.PdfBorderArray;
import com.aowagie.text.pdf.PdfBorderDictionary;
import com.aowagie.text.pdf.PdfColor;
import com.aowagie.text.pdf.PdfContentByte;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfFileSpecification;
import com.aowagie.text.pdf.PdfIndirectReference;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfNumber;
import com.aowagie.text.pdf.PdfOCG;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfRectangle;
import com.aowagie.text.pdf.PdfString;
import com.aowagie.text.pdf.PdfTemplate;
import com.aowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class PdfAnnotation
extends PdfDictionary {
    static final PdfName HIGHLIGHT_INVERT = PdfName.I;
    static final PdfName HIGHLIGHT_TOGGLE = PdfName.T;
    static final int FLAGS_HIDDEN = 2;
    public static final int FLAGS_PRINT = 4;
    static final int FLAGS_NOVIEW = 32;
    static final int FLAGS_LOCKED = 128;
    static final PdfName APPEARANCE_NORMAL = PdfName.N;
    private static final int MARKUP_UNDERLINE = 1;
    private static final int MARKUP_STRIKEOUT = 2;
    private static final int MARKUP_SQUIGGLY = 3;
    protected PdfWriter writer;
    private PdfIndirectReference reference;
    protected HashMap templates;
    protected boolean form = false;
    protected boolean annotation = true;
    protected boolean used = false;
    private int placeInPage = -1;

    PdfAnnotation(PdfWriter writer, Rectangle rect) {
        this.writer = writer;
        if (rect != null) {
            this.put(PdfName.RECT, new PdfRectangle(rect));
        }
    }

    public PdfAnnotation(PdfWriter writer, float llx, float lly, float urx, float ury, PdfString title, PdfString content) {
        this.writer = writer;
        this.put(PdfName.SUBTYPE, PdfName.TEXT);
        this.put(PdfName.T, title);
        this.put(PdfName.RECT, new PdfRectangle(llx, lly, urx, ury));
        this.put(PdfName.CONTENTS, content);
    }

    public PdfAnnotation(PdfWriter writer, float llx, float lly, float urx, float ury, PdfAction action) {
        this.writer = writer;
        this.put(PdfName.SUBTYPE, PdfName.LINK);
        this.put(PdfName.RECT, new PdfRectangle(llx, lly, urx, ury));
        this.put(PdfName.A, action);
        this.put(PdfName.BORDER, new PdfBorderArray(0.0f, 0.0f, 0.0f));
        this.put(PdfName.C, new PdfColor(0, 0, 255));
    }

    public static PdfAnnotation createScreen(PdfWriter writer, Rectangle rect, String clipTitle, PdfFileSpecification fs, String mimeType, boolean playOnDisplay) throws IOException {
        PdfAnnotation ann = new PdfAnnotation(writer, rect);
        ann.put(PdfName.SUBTYPE, PdfName.SCREEN);
        ann.put(PdfName.F, new PdfNumber(4));
        ann.put(PdfName.TYPE, PdfName.ANNOT);
        ann.setPage();
        PdfIndirectReference ref = ann.getIndirectReference();
        PdfAction action = PdfAction.rendition(clipTitle, fs, mimeType, ref);
        PdfIndirectReference actionRef = writer.addToBody(action).getIndirectReference();
        if (playOnDisplay) {
            PdfDictionary aa = new PdfDictionary();
            aa.put(new PdfName("PV"), actionRef);
            ann.put(PdfName.AA, aa);
        }
        ann.put(PdfName.A, actionRef);
        return ann;
    }

    public PdfIndirectReference getIndirectReference() {
        if (this.reference == null) {
            this.reference = this.writer.getPdfIndirectReference();
        }
        return this.reference;
    }

    private static PdfAnnotation createLink(PdfWriter writer, Rectangle rect, PdfName highlight) {
        PdfAnnotation annot = new PdfAnnotation(writer, rect);
        annot.put(PdfName.SUBTYPE, PdfName.LINK);
        if (!highlight.equals(HIGHLIGHT_INVERT)) {
            annot.put(PdfName.H, highlight);
        }
        return annot;
    }

    private static PdfAnnotation createFileAttachment(PdfWriter writer, Rectangle rect, String contents, PdfFileSpecification fs) throws IOException {
        PdfAnnotation annot = new PdfAnnotation(writer, rect);
        annot.put(PdfName.SUBTYPE, PdfName.FILEATTACHMENT);
        if (contents != null) {
            annot.put(PdfName.CONTENTS, new PdfString(contents, "UnicodeBig"));
        }
        annot.put(PdfName.FS, fs.getReference());
        return annot;
    }

    public void setDefaultAppearanceString(PdfContentByte cb) {
        byte[] b = cb.getInternalBuffer().toByteArray();
        int len = b.length;
        for (int k = 0; k < len; ++k) {
            if (b[k] != 10) continue;
            b[k] = 32;
        }
        this.put(PdfName.DA, new PdfString(b));
    }

    public void setFlags(int flags) {
        if (flags == 0) {
            this.remove(PdfName.F);
        } else {
            this.put(PdfName.F, new PdfNumber(flags));
        }
    }

    public void setBorder(PdfBorderArray border) {
        this.put(PdfName.BORDER, border);
    }

    public void setBorderStyle(PdfBorderDictionary border) {
        this.put(PdfName.BS, border);
    }

    public void setHighlighting(PdfName highlight) {
        if (highlight.equals(HIGHLIGHT_INVERT)) {
            this.remove(PdfName.H);
        } else {
            this.put(PdfName.H, highlight);
        }
    }

    void setAppearance(PdfName ap, PdfTemplate template) {
        PdfDictionary dic = (PdfDictionary)this.get(PdfName.AP);
        if (dic == null) {
            dic = new PdfDictionary();
        }
        dic.put(ap, template.getIndirectReference());
        this.put(PdfName.AP, dic);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new LinkedHashMap();
        }
        this.templates.put(template, null);
    }

    void setAppearance(PdfName ap, String state, PdfTemplate template) {
        PdfObject obj;
        PdfDictionary dicAp = (PdfDictionary)this.get(PdfName.AP);
        if (dicAp == null) {
            dicAp = new PdfDictionary();
        }
        PdfDictionary dic = (obj = dicAp.get(ap)) != null && obj.isDictionary() ? (PdfDictionary)obj : new PdfDictionary();
        dic.put(new PdfName(state), template.getIndirectReference());
        dicAp.put(ap, dic);
        this.put(PdfName.AP, dicAp);
        if (!this.form) {
            return;
        }
        if (this.templates == null) {
            this.templates = new LinkedHashMap();
        }
        this.templates.put(template, null);
    }

    public void setAppearanceState(String state) {
        if (state == null) {
            this.remove(PdfName.AS);
            return;
        }
        this.put(PdfName.AS, new PdfName(state));
    }

    public void setColor(Color color) {
        this.put(PdfName.C, new PdfColor(color));
    }

    public void setTitle(String title) {
        if (title == null) {
            this.remove(PdfName.T);
            return;
        }
        this.put(PdfName.T, new PdfString(title, "UnicodeBig"));
    }

    public void setPopup(PdfAnnotation popup) {
        this.put(PdfName.POPUP, popup.getIndirectReference());
        popup.put(PdfName.PARENT, this.getIndirectReference());
    }

    public void setAction(PdfAction action) {
        this.put(PdfName.A, action);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed() {
        this.used = true;
    }

    public HashMap getTemplates() {
        return this.templates;
    }

    public boolean isForm() {
        return this.form;
    }

    public boolean isAnnotation() {
        return this.annotation;
    }

    public void setPage(int page) {
        this.put(PdfName.P, this.writer.getPageReference(page));
    }

    void setPage() {
        this.put(PdfName.P, this.writer.getCurrentPage());
    }

    public int getPlaceInPage() {
        return this.placeInPage;
    }

    public void setPlaceInPage(int placeInPage) {
        this.placeInPage = placeInPage;
    }

    public void setRotate(int v) {
        this.put(PdfName.ROTATE, new PdfNumber(v));
    }

    private PdfDictionary getMK() {
        PdfDictionary mk = (PdfDictionary)this.get(PdfName.MK);
        if (mk == null) {
            mk = new PdfDictionary();
            this.put(PdfName.MK, mk);
        }
        return mk;
    }

    public void setMKRotation(int rotation) {
        this.getMK().put(PdfName.R, new PdfNumber(rotation));
    }

    static PdfArray getMKColor(Color color) {
        PdfArray array = new PdfArray();
        int type = ExtendedColor.getType(color);
        switch (type) {
            case 1: {
                array.add(new PdfNumber(((GrayColor)color).getGray()));
                break;
            }
            case 2: {
                CMYKColor cmyk = (CMYKColor)color;
                array.add(new PdfNumber(cmyk.getCyan()));
                array.add(new PdfNumber(cmyk.getMagenta()));
                array.add(new PdfNumber(cmyk.getYellow()));
                array.add(new PdfNumber(cmyk.getBlack()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new RuntimeException("Separations, patterns and shadings are not allowed in MK dictionary.");
            }
            default: {
                array.add(new PdfNumber((float)color.getRed() / 255.0f));
                array.add(new PdfNumber((float)color.getGreen() / 255.0f));
                array.add(new PdfNumber((float)color.getBlue() / 255.0f));
            }
        }
        return array;
    }

    public void setMKBorderColor(Color color) {
        if (color == null) {
            this.getMK().remove(PdfName.BC);
        } else {
            this.getMK().put(PdfName.BC, PdfAnnotation.getMKColor(color));
        }
    }

    public void setMKBackgroundColor(Color color) {
        if (color == null) {
            this.getMK().remove(PdfName.BG);
        } else {
            this.getMK().put(PdfName.BG, PdfAnnotation.getMKColor(color));
        }
    }

    public void setMKNormalCaption(String caption) {
        this.getMK().put(PdfName.CA, new PdfString(caption, "UnicodeBig"));
    }

    public void setMKRolloverCaption(String caption) {
        this.getMK().put(PdfName.RC, new PdfString(caption, "UnicodeBig"));
    }

    public void setMKAlternateCaption(String caption) {
        this.getMK().put(PdfName.AC, new PdfString(caption, "UnicodeBig"));
    }

    public void setMKNormalIcon(PdfTemplate template) {
        this.getMK().put(PdfName.I, template.getIndirectReference());
    }

    public void setMKRolloverIcon(PdfTemplate template) {
        this.getMK().put(PdfName.RI, template.getIndirectReference());
    }

    public void setMKAlternateIcon(PdfTemplate template) {
        this.getMK().put(PdfName.IX, template.getIndirectReference());
    }

    void setMKIconFit(PdfName scale, PdfName scalingType, float leftoverLeft, float leftoverBottom, boolean fitInBounds) {
        PdfDictionary dic = new PdfDictionary();
        if (!scale.equals(PdfName.A)) {
            dic.put(PdfName.SW, scale);
        }
        if (!scalingType.equals(PdfName.P)) {
            dic.put(PdfName.S, scalingType);
        }
        if (leftoverLeft != 0.5f || leftoverBottom != 0.5f) {
            PdfArray array = new PdfArray(new PdfNumber(leftoverLeft));
            array.add(new PdfNumber(leftoverBottom));
            dic.put(PdfName.A, array);
        }
        if (fitInBounds) {
            dic.put(PdfName.FB, PdfBoolean.PDFTRUE);
        }
        this.getMK().put(PdfName.IF, dic);
    }

    public void setMKTextPosition(int tp) {
        this.getMK().put(PdfName.TP, new PdfNumber(tp));
    }

    public void setLayer(PdfOCG layer) {
        this.put(PdfName.OC, layer.getRef());
    }

    public void setName(String name) {
        this.put(PdfName.NM, new PdfString(name));
    }
}

