/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.ExceptionConverter;
import com.aowagie.text.Utilities;
import com.aowagie.text.pdf.BaseFont;
import com.aowagie.text.pdf.CJKFont;
import com.aowagie.text.pdf.IntHashtable;
import com.aowagie.text.pdf.PdfEncodings;
import com.aowagie.text.pdf.PdfIndirectReference;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfWriter;
import com.aowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    private final PdfIndirectReference indirectReference;
    private final PdfName fontName;
    private final BaseFont baseFont;
    private TrueTypeFontUnicode ttu;
    private CJKFont cjkFont;
    private byte[] shortTag;
    private HashMap longTag;
    private IntHashtable cjkTag;
    private final int fontType;
    private boolean symbolic;
    private boolean subset = true;

    FontDetails(PdfName fontName, PdfIndirectReference indirectReference, BaseFont baseFont) {
        this.fontName = fontName;
        this.indirectReference = indirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    byte[] convertToBytes(String text) {
        byte[] b = null;
        switch (this.fontType) {
            case 5: {
                return this.baseFont.convertToBytes(text);
            }
            case 0: 
            case 1: {
                b = this.baseFont.convertToBytes(text);
                int len = b.length;
                for (int k = 0; k < len; ++k) {
                    this.shortTag[b[k] & 0xFF] = 1;
                }
                break;
            }
            case 2: {
                int len = text.length();
                for (int k = 0; k < len; ++k) {
                    this.cjkTag.put(this.cjkFont.getCidCode(text.charAt(k)), 0);
                }
                b = this.baseFont.convertToBytes(text);
                break;
            }
            case 4: {
                b = this.baseFont.convertToBytes(text);
                break;
            }
            case 3: {
                try {
                    int k;
                    int len = text.length();
                    int[] metrics = null;
                    char[] glyph = new char[len];
                    int i = 0;
                    if (this.symbolic) {
                        b = PdfEncodings.convertToBytes(text, "symboltt");
                        len = b.length;
                        for (k = 0; k < len; ++k) {
                            metrics = this.ttu.getMetricsTT(b[k] & 0xFF);
                            if (metrics == null) continue;
                            this.longTag.put(metrics[0], new int[]{metrics[0], metrics[1], this.ttu.getUnicodeDifferences(b[k] & 0xFF)});
                            glyph[i++] = (char)metrics[0];
                        }
                    } else {
                        for (k = 0; k < len; ++k) {
                            int val;
                            if (Utilities.isSurrogatePair(text, k)) {
                                val = Utilities.convertToUtf32(text, k);
                                ++k;
                            } else {
                                val = text.charAt(k);
                            }
                            metrics = this.ttu.getMetricsTT(val);
                            if (metrics == null) continue;
                            int m0 = metrics[0];
                            Integer gl = m0;
                            if (!this.longTag.containsKey(gl)) {
                                this.longTag.put(gl, new int[]{m0, metrics[1], val});
                            }
                            glyph[i++] = (char)m0;
                        }
                    }
                    String s = new String(glyph, 0, i);
                    b = s.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new ExceptionConverter(e);
                }
            }
        }
        return b;
    }

    void writeFont(PdfWriter writer) {
        try {
            switch (this.fontType) {
                case 5: {
                    this.baseFont.writeFont(writer, this.indirectReference, null);
                    break;
                }
                case 0: 
                case 1: {
                    int lastChar;
                    int firstChar;
                    for (firstChar = 0; firstChar < 256 && this.shortTag[firstChar] == 0; ++firstChar) {
                    }
                    for (lastChar = 255; lastChar >= firstChar && this.shortTag[lastChar] == 0; --lastChar) {
                    }
                    if (firstChar > 255) {
                        firstChar = 255;
                        lastChar = 255;
                    }
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{firstChar, lastChar, this.shortTag, this.subset});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.longTag, this.subset});
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }
}

