/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.OutputStreamCounter;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class PdfLiteral
extends PdfObject {
    private int position;

    public PdfLiteral(String text) {
        super(0, text);
    }

    PdfLiteral(byte[] b) {
        super(0, b);
    }

    PdfLiteral(int size) {
        super(0, (byte[])null);
        this.bytes = new byte[size];
        Arrays.fill(this.bytes, (byte)32);
    }

    PdfLiteral(int type, String text) {
        super(type, text);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        if (os instanceof OutputStreamCounter) {
            this.position = ((OutputStreamCounter)os).getCounter();
        }
        super.toPdf(writer, os);
    }

    public int getPosition() {
        return this.position;
    }

    public int getPosLength() {
        if (this.bytes != null) {
            return this.bytes.length;
        }
        return 0;
    }
}

