/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfLiteral;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfNumber;
import com.aowagie.text.pdf.PdfRectangle;
import com.aowagie.text.pdf.PdfStream;
import com.aowagie.text.pdf.PdfTemplate;

class PdfFormXObject
extends PdfStream {
    private static final PdfNumber ONE = new PdfNumber(1);
    private static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate template, int compressionLevel) {
        PdfArray matrix;
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.FORM);
        this.put(PdfName.RESOURCES, template.getResources());
        this.put(PdfName.BBOX, new PdfRectangle(template.getBoundingBox()));
        this.put(PdfName.FORMTYPE, ONE);
        if (template.getLayer() != null) {
            this.put(PdfName.OC, template.getLayer().getRef());
        }
        if (template.getGroup() != null) {
            this.put(PdfName.GROUP, template.getGroup());
        }
        if ((matrix = template.getMatrix()) == null) {
            this.put(PdfName.MATRIX, MATRIX);
        } else {
            this.put(PdfName.MATRIX, matrix);
        }
        this.bytes = template.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        this.flateCompress(compressionLevel);
    }
}

