/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.PdfAnnotation;
import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfBoolean;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfEncodings;
import com.aowagie.text.pdf.PdfFileSpecification;
import com.aowagie.text.pdf.PdfIndirectReference;
import com.aowagie.text.pdf.PdfLiteral;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfNumber;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfRendition;
import com.aowagie.text.pdf.PdfStream;
import com.aowagie.text.pdf.PdfString;
import com.aowagie.text.pdf.PdfWriter;
import com.aowagie.text.pdf.collection.PdfTargetDictionary;
import java.io.IOException;
import java.net.URL;

public class PdfAction
extends PdfDictionary {
    private static final int FIRSTPAGE = 1;
    private static final int PREVPAGE = 2;
    private static final int NEXTPAGE = 3;
    private static final int LASTPAGE = 4;
    private static final int PRINTDIALOG = 5;

    public PdfAction() {
    }

    public PdfAction(URL url) {
        this(url.toExternalForm());
    }

    public PdfAction(String url) {
        this(url, false);
    }

    private PdfAction(String url, boolean isMap) {
        this.put(PdfName.S, PdfName.URI);
        this.put(PdfName.URI, new PdfString(url));
        if (isMap) {
            this.put(PdfName.ISMAP, PdfBoolean.PDFTRUE);
        }
    }

    PdfAction(PdfIndirectReference destination) {
        this.put(PdfName.S, PdfName.GOTO);
        this.put(PdfName.D, destination);
    }

    public PdfAction(String filename, String name) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(filename));
        this.put(PdfName.D, new PdfString(name));
    }

    public PdfAction(String filename, int page) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(filename));
        this.put(PdfName.D, new PdfLiteral("[" + (page - 1) + " /FitH 10000]"));
    }

    public PdfAction(int named) {
        this.put(PdfName.S, PdfName.NAMED);
        switch (named) {
            case 1: {
                this.put(PdfName.N, PdfName.FIRSTPAGE);
                break;
            }
            case 4: {
                this.put(PdfName.N, PdfName.LASTPAGE);
                break;
            }
            case 3: {
                this.put(PdfName.N, PdfName.NEXTPAGE);
                break;
            }
            case 2: {
                this.put(PdfName.N, PdfName.PREVPAGE);
                break;
            }
            case 5: {
                this.put(PdfName.S, PdfName.JAVASCRIPT);
                this.put(PdfName.JS, new PdfString("this.print(true);\r"));
                break;
            }
            default: {
                throw new RuntimeException("Invalid named action.");
            }
        }
    }

    public PdfAction(String application, String parameters, String operation, String defaultDir) {
        this.put(PdfName.S, PdfName.LAUNCH);
        if (parameters == null && operation == null && defaultDir == null) {
            this.put(PdfName.F, new PdfString(application));
        } else {
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.F, new PdfString(application));
            if (parameters != null) {
                dic.put(PdfName.P, new PdfString(parameters));
            }
            if (operation != null) {
                dic.put(PdfName.O, new PdfString(operation));
            }
            if (defaultDir != null) {
                dic.put(PdfName.D, new PdfString(defaultDir));
            }
            this.put(PdfName.WIN, dic);
        }
    }

    static PdfAction rendition(String file, PdfFileSpecification fs, String mimeType, PdfIndirectReference ref) throws IOException {
        PdfAction js = new PdfAction();
        js.put(PdfName.S, PdfName.RENDITION);
        js.put(PdfName.R, new PdfRendition(file, fs, mimeType));
        js.put(new PdfName("OP"), new PdfNumber(0));
        js.put(new PdfName("AN"), ref);
        return js;
    }

    static PdfAction javaScript(String code, PdfWriter writer, boolean unicode) {
        PdfAction js = new PdfAction();
        js.put(PdfName.S, PdfName.JAVASCRIPT);
        if (unicode && code.length() < 50) {
            js.put(PdfName.JS, new PdfString(code, "UnicodeBig"));
        } else if (!unicode && code.length() < 100) {
            js.put(PdfName.JS, new PdfString(code));
        } else {
            try {
                byte[] b = PdfEncodings.convertToBytes(code, unicode ? "UnicodeBig" : "PDF");
                PdfStream stream = new PdfStream(b);
                stream.flateCompress(writer.getCompressionLevel());
                js.put(PdfName.JS, writer.addToBody(stream).getIndirectReference());
            }
            catch (Exception e) {
                js.put(PdfName.JS, new PdfString(code));
            }
        }
        return js;
    }

    private static PdfAction createHide(PdfObject obj, boolean hide) {
        PdfAction action = new PdfAction();
        action.put(PdfName.S, PdfName.HIDE);
        action.put(PdfName.T, obj);
        if (!hide) {
            action.put(PdfName.H, PdfBoolean.PDFFALSE);
        }
        return action;
    }

    private static PdfArray buildArray(Object[] names) {
        PdfArray array = new PdfArray();
        for (Object obj : names) {
            if (obj instanceof String) {
                array.add(new PdfString((String)obj));
                continue;
            }
            if (obj instanceof PdfAnnotation) {
                array.add(((PdfAnnotation)obj).getIndirectReference());
                continue;
            }
            throw new RuntimeException("The array must contain String or PdfAnnotation.");
        }
        return array;
    }

    private static PdfAction gotoEmbedded(String filename, PdfTargetDictionary target, PdfObject dest, boolean newWindow) {
        PdfAction action = new PdfAction();
        action.put(PdfName.S, PdfName.GOTOE);
        action.put(PdfName.T, target);
        action.put(PdfName.D, dest);
        action.put(PdfName.NEWWINDOW, new PdfBoolean(newWindow));
        if (filename != null) {
            action.put(PdfName.F, new PdfString(filename));
        }
        return action;
    }
}

