/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.PRIndirectReference;
import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;

public class PRAcroForm
extends PdfDictionary {
    private final ArrayList fields;
    private final ArrayList stack;
    private final HashMap fieldByName;
    private final PdfReader reader;

    PRAcroForm(PdfReader reader) {
        this.reader = reader;
        this.fields = new ArrayList();
        this.fieldByName = new LinkedHashMap();
        this.stack = new ArrayList();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    public ArrayList getFields() {
        return this.fields;
    }

    void readAcroForm(PdfDictionary root) {
        if (root == null) {
            return;
        }
        this.hashMap = root.hashMap;
        this.pushAttrib(root);
        PdfArray fieldlist = (PdfArray)PdfReader.getPdfObjectRelease(root.get(PdfName.FIELDS));
        this.iterateFields(fieldlist, null, null);
    }

    private void iterateFields(PdfArray fieldlist, PRIndirectReference fieldDict, String title) {
        ListIterator<PdfObject> it = fieldlist.listIterator();
        while (it.hasNext()) {
            PdfArray kids;
            boolean isFieldDict;
            PRIndirectReference ref = (PRIndirectReference)it.next();
            PdfDictionary dict = (PdfDictionary)PdfReader.getPdfObjectRelease(ref);
            PRIndirectReference myFieldDict = fieldDict;
            String myTitle = title;
            PdfString tField = (PdfString)dict.get(PdfName.T);
            boolean bl = isFieldDict = tField != null;
            if (isFieldDict) {
                myFieldDict = ref;
                myTitle = title == null ? tField.toString() : title + '.' + tField.toString();
            }
            if ((kids = (PdfArray)dict.get(PdfName.KIDS)) != null) {
                this.pushAttrib(dict);
                this.iterateFields(kids, myFieldDict, myTitle);
                this.stack.remove(this.stack.size() - 1);
                continue;
            }
            if (myFieldDict == null) continue;
            PdfDictionary mergedDict = (PdfDictionary)this.stack.get(this.stack.size() - 1);
            if (isFieldDict) {
                mergedDict = this.mergeAttrib(mergedDict, dict);
            }
            mergedDict.put(PdfName.T, new PdfString(myTitle));
            FieldInformation fi = new FieldInformation(myTitle, mergedDict, myFieldDict);
            this.fields.add(fi);
            this.fieldByName.put(myTitle, fi);
        }
    }

    private PdfDictionary mergeAttrib(PdfDictionary parent, PdfDictionary child) {
        PdfDictionary targ = new PdfDictionary();
        if (parent != null) {
            targ.putAll(parent);
        }
        for (PdfName element : child.getKeys()) {
            PdfName key = element;
            if (!key.equals(PdfName.DR) && !key.equals(PdfName.DA) && !key.equals(PdfName.Q) && !key.equals(PdfName.FF) && !key.equals(PdfName.DV) && !key.equals(PdfName.V) && !key.equals(PdfName.FT) && !key.equals(PdfName.F)) continue;
            targ.put(key, child.get(key));
        }
        return targ;
    }

    private void pushAttrib(PdfDictionary dict) {
        PdfDictionary dic = null;
        if (!this.stack.isEmpty()) {
            dic = (PdfDictionary)this.stack.get(this.stack.size() - 1);
        }
        dic = this.mergeAttrib(dic, dict);
        this.stack.add(dic);
    }

    public static class FieldInformation {
        private final String name;
        private final PdfDictionary info;
        private final PRIndirectReference ref;

        private FieldInformation(String name, PdfDictionary info, PRIndirectReference ref) {
            this.name = name;
            this.info = info;
            this.ref = ref;
        }

        public String getName() {
            return this.name;
        }

        public PdfDictionary getInfo() {
            return this.info;
        }

        public PRIndirectReference getRef() {
            return this.ref;
        }
    }
}

