/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static Boolean imageIOExist = null;

    public static byte[] normalizeImageToPdf(byte[] byArray) throws IOException {
        BufferedImage bufferedImage;
        if (!ImageUtils.canNormalize()) {
            throw new UnsupportedOperationException("El entorno actual no soporta esta operacion");
        }
        Object object = new ByteArrayInputStream(byArray);
        Object object2 = null;
        try {
            bufferedImage = ImageIO.read((InputStream)object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
        try {
            object2 = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                BufferedImage bufferedImage2 = ImageUtils.removeAlphaChannel(bufferedImage);
                if (!ImageIO.write((RenderedImage)bufferedImage2, "jpg", (OutputStream)object2)) {
                    throw new IOException("No se ha podido convertir la imagen a JPEG");
                }
                object = ((ByteArrayOutputStream)object2).toByteArray();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((ByteArrayOutputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ByteArrayOutputStream)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("No ha podido decodificar la imagen", exception);
        }
        return object;
    }

    private static BufferedImage removeAlphaChannel(BufferedImage bufferedImage) {
        if (!bufferedImage.getColorModel().hasAlpha()) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static boolean canNormalize() {
        if (imageIOExist == null) {
            try {
                Class.forName("javax.imageio.ImageIO", false, ImageUtils.class.getClassLoader());
                imageIOExist = Boolean.TRUE;
            }
            catch (Exception exception) {
                imageIOExist = Boolean.FALSE;
            }
        }
        return imageIOExist;
    }
}

