/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins;

import es.gob.afirma.standalone.plugins.AfirmaPlugin;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PluginPreferences {
    private final Preferences preferences;
    private static PluginPreferences instance = null;

    public static PluginPreferences getInstance(AfirmaPlugin afirmaPlugin) {
        if (instance == null) {
            instance = new PluginPreferences(afirmaPlugin);
        }
        return instance;
    }

    private PluginPreferences(AfirmaPlugin afirmaPlugin) {
        this.preferences = Preferences.userNodeForPackage(afirmaPlugin.getClass());
    }

    public void saveConfig(Properties properties) {
        try {
            for (String string : this.preferences.childrenNames()) {
                this.preferences.remove(string);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(PluginPreferences.class.getName()).warning("No se pudo eliminar la configuracion anterior del plugin: " + backingStoreException);
        }
        for (String string : properties.keySet().toArray(new String[properties.size()])) {
            this.preferences.put(string, properties.getProperty(string));
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(PluginPreferences.class.getName()).warning("No se pudo guardar la nueva configuracion del plugin: " + backingStoreException);
        }
    }

    public Properties recoverConfig() {
        Properties properties = new Properties();
        try {
            for (String string : this.preferences.keys()) {
                properties.setProperty(string, this.preferences.get(string, ""));
            }
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(PluginPreferences.class.getName()).warning("No se pudo recuperar toda la configuracion del plugin: " + backingStoreException);
        }
        return properties;
    }
}

