/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins;

import es.gob.afirma.standalone.plugins.ConfigurationPanel;
import es.gob.afirma.standalone.plugins.PluginControlledException;
import es.gob.afirma.standalone.plugins.PluginInfo;
import es.gob.afirma.standalone.plugins.PluginPreferences;
import es.gob.afirma.standalone.plugins.SignDataProcessor;
import java.lang.reflect.Constructor;
import java.security.cert.Certificate;
import java.util.Properties;

public abstract class AfirmaPlugin {
    private PluginInfo info = null;
    private SignDataProcessor inlineProcessor = null;
    private ClassLoader classLoader = null;

    public final PluginInfo getInfo() {
        return this.info;
    }

    public final void setInfo(PluginInfo pluginInfo) {
        this.info = pluginInfo;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final Properties getConfig() {
        return PluginPreferences.getInstance(this).recoverConfig();
    }

    public final ConfigurationPanel buildConfigurationPanel() throws ReflectiveOperationException {
        ConfigurationPanel configurationPanel;
        String string = this.getInfo().getConfigPanel();
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string, true, this.getClass().getClassLoader());
            configurationPanel = (ConfigurationPanel)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ReflectiveOperationException("No se pudo crear el panel de configuracion", exception);
        }
        return configurationPanel;
    }

    public byte[] preSignProcess(byte[] byArray, String string) throws PluginControlledException {
        return byArray;
    }

    public byte[] postSignProcess(byte[] byArray, String string, Certificate[] certificateArray) throws PluginControlledException {
        return byArray;
    }

    public final SignDataProcessor getInlineProcessor(int n) throws PluginControlledException {
        String string;
        if (this.inlineProcessor == null && (string = this.info.getInlineProcessorClassname()) != null) {
            try {
                Class<?> clazz = Class.forName(string, true, this.getClass().getClassLoader());
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.inlineProcessor = (SignDataProcessor)constructor.newInstance(n);
            }
            catch (Exception exception) {
                throw new PluginControlledException("No se ha podido cargar la clase de procesado en linea", exception);
            }
        }
        return this.inlineProcessor;
    }

    public void install() throws PluginControlledException {
    }

    public void uninstall() throws PluginControlledException {
    }

    public void reset() throws PluginControlledException {
    }

    public final boolean equals(Object object) {
        if (object != null && object instanceof AfirmaPlugin) {
            PluginInfo pluginInfo = this.getInfo();
            PluginInfo pluginInfo2 = ((AfirmaPlugin)object).getInfo();
            return pluginInfo.getInternalName().equals(pluginInfo2.getInternalName());
        }
        if (object != null && object instanceof PluginInfo) {
            PluginInfo pluginInfo = this.getInfo();
            PluginInfo pluginInfo3 = (PluginInfo)object;
            return pluginInfo.getInternalName().equals(pluginInfo3.getInternalName());
        }
        return super.equals(object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        return this.info != null ? this.info.toString() : super.toString();
    }
}

