/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins.manager;

import es.gob.afirma.standalone.plugins.AfirmaPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class PluginsPreferences {
    private final Preferences preferences;
    private final String name;
    private static Map<String, PluginsPreferences> instances = null;

    public static PluginsPreferences getInstance(AfirmaPlugin afirmaPlugin) {
        String string = afirmaPlugin.getInfo().getInternalName();
        if (instances == null) {
            instances = new HashMap<String, PluginsPreferences>();
        }
        if (!instances.containsKey(string)) {
            instances.put(string, new PluginsPreferences(afirmaPlugin));
        }
        return instances.get(string);
    }

    private PluginsPreferences(AfirmaPlugin afirmaPlugin) {
        this.name = afirmaPlugin.getInfo().getInternalName();
        this.preferences = Preferences.userNodeForPackage(afirmaPlugin.getClass());
    }

    public void saveConfig(Properties properties) {
        try {
            for (String string : this.preferences.childrenNames()) {
                this.preferences.remove(string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(PluginsPreferences.class.getName()).warning("No se pudo eliminar la configuracion anterior del plugin: " + exception);
        }
        for (String string : properties.keySet().toArray(new String[properties.size()])) {
            this.preferences.put(string, properties.getProperty(string));
        }
    }

    public Properties recoverConfig() {
        Properties properties = new Properties();
        try {
            for (String string : this.preferences.keys()) {
                properties.setProperty(string, this.preferences.get(string, ""));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(PluginsPreferences.class.getName()).warning("No se pudo recuperar toda la configuracion del plugin: " + exception);
        }
        return properties;
    }

    public void removeConfig() {
        try {
            this.preferences.removeNode();
        }
        catch (Exception exception) {
            Logger.getLogger(PluginsPreferences.class.getName()).warning("No se pudo eliminar la configuracion del plugin: " + exception);
        }
        instances.remove(this.name);
    }
}

