/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins.manager;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.standalone.plugins.AfirmaPlugin;
import es.gob.afirma.standalone.plugins.MinimalPluginInfo;
import es.gob.afirma.standalone.plugins.Permission;
import es.gob.afirma.standalone.plugins.PluginControlledException;
import es.gob.afirma.standalone.plugins.PluginInfo;
import es.gob.afirma.standalone.plugins.manager.PermissionChecker;
import es.gob.afirma.standalone.plugins.manager.PluginException;
import es.gob.afirma.standalone.plugins.manager.PluginInstalledException;
import es.gob.afirma.standalone.plugins.manager.PluginLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginsManager {
    private static final String PLUGIN_RELATION_FILENAME = "installed";
    private static final String RELATIONS_SEPARATOR = ":";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private List<AfirmaPlugin> pluginsLoadedList = null;
    private File pluginsDir = null;

    public PluginsManager(File file) {
        this.pluginsDir = file;
    }

    public List<AfirmaPlugin> getPluginsLoadedList() throws PluginException {
        return this.getPluginsLoadedList(false);
    }

    public List<AfirmaPlugin> getPluginsLoadedList(boolean bl) throws PluginException {
        if (this.pluginsLoadedList == null || bl) {
            this.pluginsLoadedList = this.loadPlugins();
        }
        return new ArrayList<AfirmaPlugin>(this.pluginsLoadedList);
    }

    private List<AfirmaPlugin> loadPlugins() throws PluginException {
        ArrayList<AfirmaPlugin> arrayList = new ArrayList<AfirmaPlugin>();
        File file = new File(this.pluginsDir, PLUGIN_RELATION_FILENAME);
        if (file.isFile() && file.canRead()) {
            MinimalPluginInfo[] minimalPluginInfoArray;
            try {
                minimalPluginInfoArray = PluginsManager.loadPluginsList(file);
            }
            catch (Exception exception) {
                throw new PluginException("Error al cargar el listado de plugins", exception);
            }
            for (MinimalPluginInfo minimalPluginInfo : minimalPluginInfoArray) {
                try {
                    AfirmaPlugin afirmaPlugin = this.loadPlugin(minimalPluginInfo);
                    arrayList.add(afirmaPlugin);
                }
                catch (PluginException pluginException) {
                    LOGGER.log(Level.WARNING, String.format("No se ha podido cargar la informacion del plugin %s. Se eliminara del listado", minimalPluginInfo.getInternalName()), pluginException);
                }
            }
        }
        return arrayList;
    }

    private static MinimalPluginInfo[] loadPluginsList(File file) throws IOException {
        if (!file.isFile() || !file.canRead()) {
            return new MinimalPluginInfo[0];
        }
        ArrayList<MinimalPluginInfo> arrayList = new ArrayList<MinimalPluginInfo>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            do {
                if ((string = bufferedReader.readLine()) == null || string.trim().isEmpty()) continue;
                try {
                    String[] stringArray = string.trim().split(RELATIONS_SEPARATOR);
                    arrayList.add(new MinimalPluginInfo(stringArray[0], Integer.parseInt(stringArray[1])));
                }
                catch (Exception exception) {
                    LOGGER.warning(String.format("No se puede cargar el plugin correspondiente a la linea %s. Se descartara.", string));
                }
            } while (string != null);
        }
        catch (Exception exception) {
            throw new IOException("No se pudo leer el listado de plugins instalados", exception);
        }
        return arrayList.toArray(new MinimalPluginInfo[arrayList.size()]);
    }

    private AfirmaPlugin loadPlugin(MinimalPluginInfo minimalPluginInfo) throws PluginException {
        File file2 = new File(this.pluginsDir, minimalPluginInfo.getInternalName());
        if (!file2.isDirectory()) {
            throw new PluginException("No se ha encontrado el plugin " + minimalPluginInfo.getInternalName());
        }
        File[] fileArray = file2.listFiles(file -> file.isFile() && file.canRead());
        if (fileArray == null || fileArray.length == 0) {
            throw new PluginException("No se han encontrado los ficheros del plugin " + minimalPluginInfo.getInternalName());
        }
        return PluginsManager.loadPluginFromFiles(fileArray);
    }

    private static void savePluginsList(File file, List<AfirmaPlugin> list) throws IOException {
        if (!list.isEmpty()) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                for (AfirmaPlugin afirmaPlugin : list) {
                    PluginInfo pluginInfo = afirmaPlugin.getInfo();
                    String string = pluginInfo.getInternalName() + RELATIONS_SEPARATOR + pluginInfo.getVersionCode() + "\n";
                    fileOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
                }
                fileOutputStream.flush();
            }
            AOFileUtils.setAllPermissions((File)file);
        } else {
            PluginsManager.deleteDirectoryAndContent(file.getParentFile());
        }
    }

    public static AfirmaPlugin loadPluginFromFiles(File[] fileArray) throws PluginException {
        AfirmaPlugin afirmaPlugin;
        try {
            afirmaPlugin = PluginLoader.loadPlugin(fileArray);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Error en la carga de un conjunto de ficheros de plugin", iOException);
            throw new PluginException("Error en la carga de un conjunto de ficheros de plugin", iOException);
        }
        catch (PluginException pluginException) {
            LOGGER.log(Level.SEVERE, "El plugin importado no es valido", pluginException);
            throw pluginException;
        }
        return afirmaPlugin;
    }

    public static void closePlugin(AfirmaPlugin afirmaPlugin) {
        ClassLoader classLoader = afirmaPlugin.getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            try {
                ((URLClassLoader)classLoader).close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "No se pudo descargar un plugin de memoria", iOException);
            }
        }
    }

    public AfirmaPlugin installPlugin(File file, String string) throws PluginInstalledException, PluginException, IOException, PluginControlledException {
        AfirmaPlugin afirmaPlugin;
        File file2 = PluginsManager.copyPluginToDirectory(file, string, this.pluginsDir);
        try {
            afirmaPlugin = PluginsManager.loadPluginFromFiles(new File[]{file2});
        }
        catch (Exception exception) {
            PluginsManager.deleteDirectoryAndContent(file2.getParentFile());
            throw new PluginException("No se pudo cargar el plugin recien importado", exception);
        }
        PluginInfo pluginInfo = afirmaPlugin.getInfo();
        if (PermissionChecker.check(pluginInfo, Permission.INSTALL)) {
            try {
                afirmaPlugin.install();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Ocurrio un error al instalar el plugin. Lo desinstalamos", exception);
                try {
                    this.uninstallPlugin(afirmaPlugin);
                }
                catch (Exception exception2) {
                    LOGGER.warning("No se han podido eliminar los ficheros importados del plugin");
                }
                if (exception instanceof PluginControlledException) {
                    throw (PluginControlledException)exception;
                }
                throw new PluginException("Ocurrio un error al instalar el plugin", exception);
            }
        }
        this.addPluginToRelationsFile((MinimalPluginInfo)afirmaPlugin.getInfo());
        if (this.pluginsLoadedList == null) {
            this.pluginsLoadedList = new ArrayList<AfirmaPlugin>();
        }
        this.pluginsLoadedList.add(afirmaPlugin);
        return afirmaPlugin;
    }

    private static File copyPluginToDirectory(File file, String string, File file2) throws IOException, PluginInstalledException {
        File file3;
        if (!file2.isDirectory()) {
            try {
                if (!file2.getParentFile().exists()) {
                    PluginsManager.createDirWithPermissions(file2.getParentFile());
                }
                PluginsManager.createDirWithPermissions(file2);
            }
            catch (Exception exception) {
                throw new IOException("No se ha podido crear el directorio interno de plugins: " + LoggerUtil.getCleanUserHomePath((String)file2.getAbsolutePath()), exception);
            }
        }
        if ((file3 = new File(file2, string)).exists()) {
            throw new PluginInstalledException("El plugin seleccionado ya se encuentra instalado");
        }
        try {
            PluginsManager.createDirWithPermissions(file3);
        }
        catch (Exception exception) {
            throw new IOException("No se ha podido crear el directorio para la copia del plugin: " + LoggerUtil.getCleanUserHomePath((String)file3.getAbsolutePath()), exception);
        }
        File file4 = new File(file3, file.getName());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file4);){
            Files.copy(file.toPath(), fileOutputStream);
        }
        AOFileUtils.setAllPermissions((File)file4);
        return file4;
    }

    private void addPluginToRelationsFile(MinimalPluginInfo minimalPluginInfo) throws IOException {
        byte[] byArray = (minimalPluginInfo.getInternalName() + RELATIONS_SEPARATOR + minimalPluginInfo.getVersionCode() + "\n").getBytes(StandardCharsets.UTF_8);
        File file = new File(this.pluginsDir, PLUGIN_RELATION_FILENAME);
        if (!file.isFile()) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
            }
            AOFileUtils.setAllPermissions((File)file);
        } else {
            Files.write(file.toPath(), byArray, StandardOpenOption.APPEND);
        }
    }

    public void uninstallPlugin(AfirmaPlugin afirmaPlugin) throws IOException {
        PluginInfo pluginInfo = afirmaPlugin.getInfo();
        LOGGER.info("Se desinstala el plugin: " + pluginInfo.getName());
        if (PermissionChecker.check(pluginInfo, Permission.INSTALL)) {
            LOGGER.info("Se ejecuta la funcion de desinstalacion del plugin");
            try {
                afirmaPlugin.uninstall();
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "El proceso de desinstalacion interno del plugin devolvio un error", exception);
            }
        }
        String string = pluginInfo.getInternalName();
        this.pluginsLoadedList.remove(afirmaPlugin);
        ((URLClassLoader)afirmaPlugin.getClass().getClassLoader()).close();
        if (!this.pluginsDir.isDirectory()) {
            LOGGER.warning("No existe el directorio de plugins, asi que no deberia haber ninguno instalado");
            return;
        }
        File file = new File(this.pluginsDir, string);
        if (!file.exists()) {
            LOGGER.warning("El plugin seleccionado, no se encuentra instalado");
            return;
        }
        PluginsManager.deleteDirectoryAndContent(file);
        File file2 = new File(this.pluginsDir, PLUGIN_RELATION_FILENAME);
        PluginsManager.savePluginsList(file2, this.pluginsLoadedList);
    }

    public void forceRemove(String string) throws IOException {
        File file = new File(this.pluginsDir, string);
        if (!file.exists()) {
            LOGGER.warning("El plugin seleccionado, no se encuentra instalado");
            return;
        }
        PluginsManager.deleteDirectoryAndContent(file);
    }

    private static void deleteDirectoryAndContent(File file) throws IOException {
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                Files.delete(file2.toPath());
                continue;
            }
            PluginsManager.deleteDirectoryAndContent(file2);
        }
        Files.delete(file.toPath());
    }

    private static void createDirWithPermissions(File file) throws IOException {
        if (!file.mkdirs()) {
            throw new IOException("No se pudo crear el directorio: " + LoggerUtil.getCleanUserHomePath((String)file.getAbsolutePath()));
        }
        AOFileUtils.setAllPermissions((File)file);
    }
}

