/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins.manager;

import es.gob.afirma.standalone.plugins.AfirmaPlugin;
import es.gob.afirma.standalone.plugins.GenericMenuOption;
import es.gob.afirma.standalone.plugins.PluginAction;
import es.gob.afirma.standalone.plugins.PluginButton;
import es.gob.afirma.standalone.plugins.PluginCommandAction;
import es.gob.afirma.standalone.plugins.PluginInfo;
import es.gob.afirma.standalone.plugins.manager.PluginException;
import es.gob.afirma.standalone.plugins.manager.PluginInfoLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class PluginLoader {
    private static final String CONFIG_FILE = "/plugin.json";
    public static final Map<String, AfirmaPlugin> classLoaderForPlugin = new HashMap<String, AfirmaPlugin>();

    static AfirmaPlugin loadPlugin(File[] fileArray) throws IOException, PluginException {
        AfirmaPlugin afirmaPlugin;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File object : fileArray) {
            arrayList.add(object.toURI().toURL());
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), PluginLoader.class.getClassLoader());
        try {
            ArrayList<AfirmaPlugin> arrayList2 = new ArrayList<AfirmaPlugin>();
            try {
                ServiceLoader<AfirmaPlugin> serviceLoader = ServiceLoader.load(AfirmaPlugin.class, uRLClassLoader);
                for (AfirmaPlugin afirmaPlugin2 : serviceLoader) {
                    arrayList2.add(afirmaPlugin2);
                }
            }
            catch (Error error) {
                uRLClassLoader.close();
                throw new PluginException("Se han contrado plugins mal definidos en el fichero importado");
            }
            if (arrayList2.size() == 0) {
                uRLClassLoader.close();
                throw new PluginException("No se encontro ningun plugin en los archivos");
            }
            if (arrayList2.size() > 1) {
                uRLClassLoader.close();
                throw new PluginException("No se permite la carga simulatea de varios plugins");
            }
            afirmaPlugin = (AfirmaPlugin)arrayList2.get(0);
            afirmaPlugin.setClassLoader((ClassLoader)uRLClassLoader);
            PluginInfo pluginInfo = PluginLoader.loadPluginConfiguration(afirmaPlugin);
            PluginLoader.registryPluginReferences(afirmaPlugin, pluginInfo);
            if (pluginInfo.getButtons() != null) {
                for (PluginButton pluginButton : pluginInfo.getButtons()) {
                    if (pluginButton.getActionClassName() == null) {
                        uRLClassLoader.close();
                        throw new PluginException(String.format("El plugin '%1s' no ha definido accion para un boton", pluginInfo.getName()));
                    }
                    if (pluginButton.getWindow() == null) {
                        uRLClassLoader.close();
                        throw new PluginException(String.format("El plugin '%1s' no ha definido la ventana en la que debe aparecer un boton", pluginInfo.getName()));
                    }
                    try {
                        PluginAction pluginAction = (PluginAction)PluginLoader.loadAction(pluginButton.getActionClassName(), PluginAction.class, uRLClassLoader);
                        pluginAction.setPlugin(afirmaPlugin);
                        pluginButton.setAction(pluginAction);
                    }
                    catch (Exception exception) {
                        uRLClassLoader.close();
                        throw new PluginException(String.format("El plugin '%1s' definio una clase de accion erronea: %2s", pluginInfo.getName(), pluginButton.getActionClassName()), exception);
                    }
                }
            }
            afirmaPlugin.setInfo(pluginInfo);
        }
        catch (Exception exception) {
            uRLClassLoader.close();
            throw new PluginException(String.format("Ha ocurrido un error al intentar cargar el plugin", new Object[0]), exception);
        }
        return afirmaPlugin;
    }

    private static void registryPluginReferences(AfirmaPlugin afirmaPlugin, PluginInfo pluginInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PluginLoader.getListActions(pluginInfo, arrayList);
        for (String string : arrayList) {
            if (classLoaderForPlugin.containsKey(string)) continue;
            classLoaderForPlugin.put(string, afirmaPlugin);
        }
    }

    private static void getListActions(PluginInfo pluginInfo, List<String> list) {
        if (pluginInfo != null) {
            if (pluginInfo.getButtons() != null) {
                for (PluginButton pluginButton : pluginInfo.getButtons()) {
                    list.add(pluginButton.getActionClassName());
                }
            }
            if (pluginInfo.getCommands() != null) {
                for (PluginButton pluginButton : pluginInfo.getCommands()) {
                    list.add(pluginButton.getCommandActionClass());
                }
            }
            if (pluginInfo.getMenu() != null) {
                PluginLoader.getListActionsFromMenus(pluginInfo.getMenu(), list);
            }
        }
    }

    private static void getListActionsFromMenus(GenericMenuOption genericMenuOption, List<String> list) {
        if (genericMenuOption.getActionClassName() != null) {
            list.add(genericMenuOption.getActionClassName());
        }
        if (genericMenuOption.getMenus() != null) {
            for (GenericMenuOption genericMenuOption2 : genericMenuOption.getMenus()) {
                PluginLoader.getListActionsFromMenus(genericMenuOption2, list);
            }
        }
    }

    private static PluginInfo loadPluginConfiguration(AfirmaPlugin afirmaPlugin) throws IOException, PluginException {
        PluginInfo pluginInfo;
        String string = afirmaPlugin.getClass().getPackage().getName();
        String string2 = '/' + string.replace('.', '/') + CONFIG_FILE;
        try (InputStream inputStream = afirmaPlugin.getClass().getResourceAsStream(string2);){
            if (inputStream == null) {
                throw new IOException(String.format("No se encontro el fichero %1s en el plugin", string2));
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                pluginInfo = PluginInfoLoader.parseInfo(inputStreamReader);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Error en la lectura del fichero /plugin.json", iOException);
        }
        catch (Exception exception) {
            throw new PluginException("Se ha encontrado un error en el fichero /plugin.json", exception);
        }
        return pluginInfo;
    }

    public static PluginAction getPluginAction(String string) throws PluginException {
        AfirmaPlugin afirmaPlugin = classLoaderForPlugin.get(string);
        PluginAction pluginAction = (PluginAction)PluginLoader.loadAction(string, PluginAction.class, afirmaPlugin.getClassLoader());
        pluginAction.setPlugin(afirmaPlugin);
        return pluginAction;
    }

    public static PluginCommandAction getPluginCommandAction(String string) throws PluginException {
        AfirmaPlugin afirmaPlugin = classLoaderForPlugin.get(string);
        PluginCommandAction pluginCommandAction = (PluginCommandAction)PluginLoader.loadAction(string, PluginCommandAction.class, afirmaPlugin.getClassLoader());
        pluginCommandAction.setPlugin(afirmaPlugin);
        return pluginCommandAction;
    }

    private static Object loadAction(String string, Class<?> clazz, ClassLoader classLoader) throws PluginException {
        Object obj;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName(string, false, classLoader);
        }
        catch (Throwable throwable) {
            throw new PluginException(String.format("La clase de accion %1s no existe", string), throwable);
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new PluginException(String.format("Se ha establecido un boton que no define una accion de tipo %1s", PluginAction.class.getName()));
        }
        try {
            obj = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new PluginException(String.format("No se puede instanciar la clase %s. El constructor por defecto deber existir y ser publico", string), throwable);
        }
        return obj;
    }
}

